/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.interactions.components.selections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.entities.Emoji;
import net.dv8tion.jda.api.interactions.components.Component;
import net.dv8tion.jda.api.interactions.components.selections.SelectOption;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.interactions.SelectionMenuImpl;
import net.dv8tion.jda.internal.utils.Checks;

public interface SelectionMenu
extends Component {
    @Nullable
    public String getPlaceholder();

    public int getMinValues();

    public int getMaxValues();

    @Nonnull
    public List<SelectOption> getOptions();

    public boolean isDisabled();

    @Nonnull
    @CheckReturnValue
    default public SelectionMenu asDisabled() {
        return this.withDisabled(true);
    }

    @Nonnull
    @CheckReturnValue
    default public SelectionMenu asEnabled() {
        return this.withDisabled(false);
    }

    @Nonnull
    @CheckReturnValue
    default public SelectionMenu withDisabled(boolean disabled) {
        return this.createCopy().setDisabled(disabled).build();
    }

    @Nonnull
    @CheckReturnValue
    default public Builder createCopy() {
        Builder builder = SelectionMenu.create(this.getId());
        builder.setRequiredRange(this.getMinValues(), this.getMaxValues());
        builder.setPlaceholder(this.getPlaceholder());
        builder.addOptions(this.getOptions());
        builder.setDisabled(this.isDisabled());
        return builder;
    }

    @Nonnull
    @CheckReturnValue
    public static Builder create(@Nonnull String customId) {
        return new Builder(customId);
    }

    @Nonnull
    @CheckReturnValue
    public static Builder fromData(@Nonnull DataObject data) {
        return new SelectionMenuImpl(data).createCopy();
    }

    public static class Builder {
        private String customId;
        private String placeholder;
        private int minValues = 1;
        private int maxValues = 1;
        private boolean disabled = false;
        private final List<SelectOption> options = new ArrayList<SelectOption>();

        protected Builder(@Nonnull String customId) {
            this.setId(customId);
        }

        @Nonnull
        public Builder setId(@Nonnull String customId) {
            Checks.notEmpty(customId, "Component ID");
            Checks.notLonger(customId, 100, "Component ID");
            this.customId = customId;
            return this;
        }

        @Nonnull
        public Builder setPlaceholder(@Nullable String placeholder) {
            if (placeholder != null) {
                Checks.notEmpty(placeholder, "Placeholder");
                Checks.notLonger(placeholder, 100, "Placeholder");
            }
            this.placeholder = placeholder;
            return this;
        }

        @Nonnull
        public Builder setMinValues(int minValues) {
            Checks.notNegative(minValues, "Min Values");
            Checks.check(minValues <= 25, "Min Values may not be greater than 25! Provided: %d", (Object)minValues);
            this.minValues = minValues;
            return this;
        }

        @Nonnull
        public Builder setMaxValues(int maxValues) {
            Checks.positive(maxValues, "Max Values");
            Checks.check(maxValues <= 25, "Min Values may not be greater than 25! Provided: %d", (Object)maxValues);
            this.maxValues = maxValues;
            return this;
        }

        @Nonnull
        public Builder setRequiredRange(int min, int max) {
            Checks.check(min <= max, "Min Values should be less than or equal to Max Values! Provided: [%d, %d]", min, max);
            return this.setMinValues(min).setMaxValues(max);
        }

        @Nonnull
        public Builder setDisabled(boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        @Nonnull
        public Builder addOptions(SelectOption ... options) {
            Checks.noneNull(options, "Options");
            Checks.check(this.options.size() + options.length <= 25, "Cannot have more than 25 options for a selection menu!");
            Collections.addAll(this.options, options);
            return this;
        }

        @Nonnull
        public Builder addOptions(@Nonnull Collection<? extends SelectOption> options) {
            Checks.noneNull(options, "Options");
            Checks.check(this.options.size() + options.size() <= 25, "Cannot have more than 25 options for a selection menu!");
            this.options.addAll(options);
            return this;
        }

        @Nonnull
        public Builder addOption(@Nonnull String label, @Nonnull String value) {
            return this.addOptions(new SelectOption(label, value));
        }

        @Nonnull
        public Builder addOption(@Nonnull String label, @Nonnull String value, @Nonnull Emoji emoji) {
            return this.addOption(label, value, null, emoji);
        }

        @Nonnull
        public Builder addOption(@Nonnull String label, @Nonnull String value, @Nonnull String description) {
            return this.addOption(label, value, description, null);
        }

        @Nonnull
        public Builder addOption(@Nonnull String label, @Nonnull String value, @Nullable String description, @Nullable Emoji emoji) {
            return this.addOptions(new SelectOption(label, value, description, false, emoji));
        }

        @Nonnull
        public List<SelectOption> getOptions() {
            return this.options;
        }

        @Nonnull
        public Builder setDefaultValues(@Nonnull Collection<String> values2) {
            Checks.noneNull(values2, "Values");
            HashSet<String> set = new HashSet<String>(values2);
            ListIterator<SelectOption> it = this.getOptions().listIterator();
            while (it.hasNext()) {
                SelectOption option = it.next();
                it.set(option.withDefault(set.contains(option.getValue())));
            }
            return this;
        }

        @Nonnull
        public Builder setDefaultOptions(@Nonnull Collection<? extends SelectOption> values2) {
            Checks.noneNull(values2, "Values");
            return this.setDefaultValues(values2.stream().map(SelectOption::getValue).collect(Collectors.toSet()));
        }

        @Nonnull
        public String getId() {
            return this.customId;
        }

        @Nullable
        public String getPlaceholder() {
            return this.placeholder;
        }

        public int getMinValues() {
            return this.minValues;
        }

        public int getMaxValues() {
            return this.maxValues;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        @Nonnull
        public SelectionMenu build() {
            Checks.check(this.minValues <= this.maxValues, "Min values cannot be greater than max values!");
            Checks.check(this.options.size() <= 25, "Cannot build a selection menu with more than 25 options.");
            int min = Math.min(this.minValues, this.options.size());
            int max = Math.min(this.maxValues, this.options.size());
            return new SelectionMenuImpl(this.customId, this.placeholder, min, max, this.disabled, this.options);
        }
    }
}

