/*
 * Decompiled with CFR 0.152.
 */
package me.pliexe.discordeconomybridge.discordsrv;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.events.interaction.GenericComponentInteractionCreateEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.interaction.SlashCommandEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.message.guild.GuildMessageReceivedEvent;
import github.scarsz.discordsrv.dependencies.jda.api.hooks.ListenerAdapter;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.commands.build.CommandData;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.ComponentInteraction;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.CommandListUpdateAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.pliexe.discordeconomybridge.DiscordEconomyBridge;
import me.pliexe.discordeconomybridge.discord.Command;
import me.pliexe.discordeconomybridge.discord.ComponentInteractionEvent;
import me.pliexe.discordeconomybridge.discord.MessageDeleteEvent;
import me.pliexe.discordeconomybridge.discordsrv.JDAListener;
import net.dv8tion.jda.api.exceptions.ContextException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lme/pliexe/discordeconomybridge/discordsrv/JDAListener;", "Lgithub/scarsz/discordsrv/dependencies/jda/api/hooks/ListenerAdapter;", "main", "Lme/pliexe/discordeconomybridge/DiscordEconomyBridge;", "(Lme/pliexe/discordeconomybridge/DiscordEconomyBridge;)V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "onGenericComponentInteractionCreate", "", "event", "Lgithub/scarsz/discordsrv/dependencies/jda/api/events/interaction/GenericComponentInteractionCreateEvent;", "onGuildMessageReceived", "Lgithub/scarsz/discordsrv/dependencies/jda/api/events/message/guild/GuildMessageReceivedEvent;", "onMessageDelete", "Lgithub/scarsz/discordsrv/dependencies/jda/api/events/message/MessageDeleteEvent;", "onSlashCommand", "Lgithub/scarsz/discordsrv/dependencies/jda/api/events/interaction/SlashCommandEvent;", "registerSlashCommands", "guild", "Lgithub/scarsz/discordsrv/dependencies/jda/api/entities/Guild;", "DiscordEconomyBridge"})
public final class JDAListener
extends ListenerAdapter {
    private final Logger logger;
    private final DiscordEconomyBridge main;

    private final void registerSlashCommands(Guild guild) {
        try {
            this.logger.info("Registering slash commands for the guild \"" + guild.getName() + "\" : " + guild.getId());
            CommandListUpdateAction commandListUpdateAction = guild.updateCommands();
            Intrinsics.checkNotNullExpressionValue(commandListUpdateAction, "guild.updateCommands()");
            CommandListUpdateAction updateCommands = commandListUpdateAction;
            Map $this$forEach$iv = this.main.getCommandHandler().getCommands();
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv;
            boolean bl = false;
            Iterator iterator2 = map.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $dstr$_u24__u24$value = element$iv = iterator2.next();
                boolean bl2 = false;
                Map.Entry entry = $dstr$_u24__u24$value;
                boolean bl3 = false;
                Command value = (Command)entry.getValue();
                updateCommands.addCommands(new CommandData[]{value.getSlashCommandDataSRV()});
            }
            updateCommands.queue((Consumer)registerSlashCommands.2.INSTANCE);
            this.logger.info("Done registering slash commands for \"" + guild.getName() + "\" : " + guild.getId());
        }
        catch (ContextException e) {
            this.main.getLogger().severe("Did you invite your bot with applications.commands scope?");
            e.printStackTrace();
        }
    }

    public void onGuildMessageReceived(@NotNull GuildMessageReceivedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.main.getCommandHandler().runCommand(event);
    }

    public void onGenericComponentInteractionCreate(@NotNull GenericComponentInteractionCreateEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter(event, "event");
            HashMap<String, Function1<ComponentInteractionEvent, Unit>> hashMap = this.main.getCommandHandler().getEvents();
            ComponentInteraction componentInteraction = event.getInteraction();
            Intrinsics.checkNotNullExpressionValue(componentInteraction, "event.interaction");
            Function1<ComponentInteractionEvent, Unit> function1 = hashMap.get(componentInteraction.getMessageId());
            if (function1 == null) break block0;
            Function1<ComponentInteractionEvent, Unit> function12 = function1;
            boolean bl = false;
            boolean bl2 = false;
            Function1<ComponentInteractionEvent, Unit> it = function12;
            boolean bl3 = false;
            it.invoke(new ComponentInteractionEvent(this.main, event));
        }
    }

    public void onMessageDelete(@NotNull github.scarsz.discordsrv.dependencies.jda.api.events.message.MessageDeleteEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter(event, "event");
            Function1<MessageDeleteEvent, Unit> function1 = this.main.getCommandHandler().getMessageDeleteEvents().get(event.getMessageId());
            if (function1 == null) break block0;
            Function1<MessageDeleteEvent, Unit> function12 = function1;
            boolean bl = false;
            boolean bl2 = false;
            Function1<MessageDeleteEvent, Unit> it = function12;
            boolean bl3 = false;
            it.invoke(new MessageDeleteEvent(event));
        }
    }

    public void onSlashCommand(@NotNull SlashCommandEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.main.getCommandHandler().runCommand(event);
    }

    public JDAListener(@NotNull DiscordEconomyBridge main) {
        Intrinsics.checkNotNullParameter((Object)main, "main");
        this.main = main;
        this.logger = this.main.getLogger();
        this.logger.info("[Bot] Loading Commands!");
        this.main.getCommandHandler().loadCommands();
        this.logger.info("[Bot] Loading command Aliases!");
        this.main.getCommandHandler().loadAliases();
        this.logger.info("[Bot] Loading command cooldowns!");
        this.main.getCommandHandler().loadCooldowns();
        if (this.main.getDefaultConfig().contains("slashCommandServers")) {
            try {
                List<String> list = this.main.getDefaultConfig().getStringList("slashCommandServers");
                Intrinsics.checkNotNullExpressionValue(list, "main.defaultConfig.getSt\u2026st(\"slashCommandServers\")");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String guildID = (String)element$iv;
                    boolean bl = false;
                    DiscordSRV discordSRV = DiscordSRV.getPlugin();
                    Intrinsics.checkNotNullExpressionValue(discordSRV, "DiscordSRV.getPlugin()");
                    Guild guild = discordSRV.getJda().getGuildById(guildID);
                    if (guild == null) continue;
                    this.registerSlashCommands(guild);
                }
            }
            catch (ClassCastException e) {
                this.main.getLogger().severe("Field \"slashCommandServers\" is of an invalid type, it must be an list of strings. The plugin will continue and ignore this configuration.");
            }
        }
    }
}

