/*
 * Decompiled with CFR 0.152.
 */
package me.pliexe.discordeconomybridge.discord.commands;

import java.text.DecimalFormat;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.pliexe.discordeconomybridge.DiscordEconomyBridge;
import me.pliexe.discordeconomybridge.UtilsKt;
import me.pliexe.discordeconomybridge.discord.Command;
import me.pliexe.discordeconomybridge.discord.CommandEventData;
import me.pliexe.discordeconomybridge.discord.CommandOptions;
import me.pliexe.discordeconomybridge.discord.DiscordMember;
import me.pliexe.discordeconomybridge.discord.DiscordUser;
import me.pliexe.discordeconomybridge.discord.DiscordUtilsKt;
import me.pliexe.discordeconomybridge.discord.UniversalPlayer;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0017"}, d2={"Lme/pliexe/discordeconomybridge/discord/commands/RemoveMoney;", "Lme/pliexe/discordeconomybridge/discord/Command;", "main", "Lme/pliexe/discordeconomybridge/DiscordEconomyBridge;", "(Lme/pliexe/discordeconomybridge/DiscordEconomyBridge;)V", "adminCommand", "", "getAdminCommand", "()Z", "description", "", "getDescription", "()Ljava/lang/String;", "name", "getName", "usage", "getUsage", "getCommandOptions", "Lme/pliexe/discordeconomybridge/discord/CommandOptions;", "run", "", "event", "Lme/pliexe/discordeconomybridge/discord/CommandEventData;", "DiscordEconomyBridge"})
public final class RemoveMoney
extends Command {
    @Override
    @NotNull
    public String getUsage() {
        return "@user amount";
    }

    @Override
    @NotNull
    public String getName() {
        return "removemoney";
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Remove money from a user's balance";
    }

    @Override
    public boolean getAdminCommand() {
        return true;
    }

    @Override
    @NotNull
    public CommandOptions getCommandOptions() {
        return CommandOptions.addOption$default(CommandOptions.addOption$default(new CommandOptions(), OptionType.USER, "user", "The user that will lose the money!", false, 8, null), OptionType.NUMBER, "amount", "The amount of money to add!", false, 8, null).setDefaultEnabled(false);
    }

    @Override
    public void run(@NotNull CommandEventData event) {
        Intrinsics.checkNotNullParameter(event, "event");
        double amount = 0.0;
        DiscordUser user = null;
        if (event.isSlashCommand()) {
            DiscordUser discordUser = event.getOptionUser("user");
            Intrinsics.checkNotNull(discordUser);
            user = discordUser;
            Double d = event.getOptionDouble("amount");
            Intrinsics.checkNotNull(d);
            amount = d;
        } else {
            List<String> list = event.getArgs();
            Intrinsics.checkNotNull(list);
            if (list.isEmpty()) {
                this.fail(event, "User was not specified!");
                return;
            }
            if (event.userMentionsSize() <= 0) {
                this.fail(event, "Couldn't get user!");
                return;
            }
            if (event.getArgs().size() < 2) {
                this.fail(event, "Amount to remove was not specified!");
                return;
            }
            Double d = StringsKt.toDoubleOrNull(event.getArgs().get(1));
            if (d == null) {
                this.fail(event, "Amount must be an numeric value!");
                return;
            }
            amount = d;
            user = event.getUserMention(0);
        }
        UUID uUID = this.getMain().getLinkHandler().getUuid(user.getId());
        if (uUID == null) {
            this.fail(event, "This user does not have their account linked!");
            return;
        }
        UUID uuid = uUID;
        UniversalPlayer player = UniversalPlayer.Companion.getByUUID(uuid);
        player.createEconomyAccountIfNotPresent(this.getMain());
        player.withdrawPlayer(this.getMain(), amount);
        DecimalFormat formatter = new DecimalFormat("#,###.##");
        CommandEventData.sendYMLEmbed$default(event, "removemoneyCommandEmbed", new Function1<String, String>(this, event, player, amount, formatter){
            final /* synthetic */ RemoveMoney this$0;
            final /* synthetic */ CommandEventData $event;
            final /* synthetic */ UniversalPlayer $player;
            final /* synthetic */ double $amount;
            final /* synthetic */ DecimalFormat $formatter;

            @NotNull
            public final String invoke(@NotNull String it) {
                String string;
                Intrinsics.checkNotNullParameter(it, "it");
                String form2 = DiscordUtilsKt.setCommandPlaceholders(it, this.$event.getPrefix(), this.$event.getCommandName(), this.this$0.getDescription(), this.this$0.getUsage());
                if (this.$event.getMember() == null) {
                    string = DiscordUtilsKt.setPlaceholdersForDiscordMessage(this.$event.getAuthor(), this.$player, form2);
                } else {
                    DiscordMember discordMember = this.$event.getMember();
                    Intrinsics.checkNotNull(discordMember);
                    string = DiscordUtilsKt.setPlaceholdersForDiscordMessage(discordMember, this.$player, form2);
                }
                return StringsKt.replace$default(string, "{amount_decrease}", UtilsKt.formatMoney(this.$amount, RemoveMoney.access$getMain$p(this.this$0).getPluginConfig().getCurrency(), RemoveMoney.access$getMain$p(this.this$0).getPluginConfig().getCurrencyLeftSide(), this.$formatter), false, 4, null);
            }
            {
                this.this$0 = removeMoney;
                this.$event = commandEventData;
                this.$player = universalPlayer;
                this.$amount = d;
                this.$formatter = decimalFormat;
                super(1);
            }
        }, null, false, 12, null).queue();
        this.getMain().getCommandHandler().commandComplete(this, event);
    }

    public RemoveMoney(@NotNull DiscordEconomyBridge main) {
        Intrinsics.checkNotNullParameter((Object)main, "main");
        super(main);
    }

    public static final /* synthetic */ DiscordEconomyBridge access$getMain$p(RemoveMoney $this) {
        return $this.getMain();
    }
}

