/*
 * Decompiled with CFR 0.152.
 */
package me.pliexe.discordeconomybridge.discord.commands;

import java.text.DecimalFormat;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import me.pliexe.discordeconomybridge.DiscordEconomyBridge;
import me.pliexe.discordeconomybridge.UtilsKt;
import me.pliexe.discordeconomybridge.discord.Command;
import me.pliexe.discordeconomybridge.discord.CommandEventData;
import me.pliexe.discordeconomybridge.discord.CommandOptions;
import me.pliexe.discordeconomybridge.discord.ComponentInteractionEvent;
import me.pliexe.discordeconomybridge.discord.DiscordEmbed;
import me.pliexe.discordeconomybridge.discord.DiscordMember;
import me.pliexe.discordeconomybridge.discord.DiscordUtilsKt;
import me.pliexe.discordeconomybridge.discord.Message;
import me.pliexe.discordeconomybridge.discord.MessageAction;
import me.pliexe.discordeconomybridge.discord.commands.Coinflip;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\bR\u0014\u0010\u000e\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\b\u00a8\u0006\u0016"}, d2={"Lme/pliexe/discordeconomybridge/discord/commands/Coinflip;", "Lme/pliexe/discordeconomybridge/discord/Command;", "main", "Lme/pliexe/discordeconomybridge/DiscordEconomyBridge;", "(Lme/pliexe/discordeconomybridge/DiscordEconomyBridge;)V", "description", "", "getDescription", "()Ljava/lang/String;", "isGame", "", "()Z", "name", "getName", "usage", "getUsage", "getCommandOptions", "Lme/pliexe/discordeconomybridge/discord/CommandOptions;", "run", "", "event", "Lme/pliexe/discordeconomybridge/discord/CommandEventData;", "DiscordEconomyBridge"})
public final class Coinflip
extends Command {
    private final boolean isGame;

    @Override
    @NotNull
    public String getName() {
        return "coinflip";
    }

    @Override
    @NotNull
    public String getUsage() {
        return "@user(The user to challenge) amount(The amount to wager)";
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Flip a coin. You win if you get head.";
    }

    @Override
    @NotNull
    public CommandOptions getCommandOptions() {
        return CommandOptions.addOption$default(CommandOptions.addOption$default(new CommandOptions(), OptionType.USER, "user", "User to challenge", false, 8, null), OptionType.NUMBER, "wager", "The amount of money to wager", false, 8, null);
    }

    @Override
    public boolean isGame() {
        return this.isGame;
    }

    @Override
    public void run(@NotNull CommandEventData event) {
        String string;
        double challengerBalance;
        double balance;
        Intrinsics.checkNotNullParameter(event, "event");
        if (!event.inGuild()) {
            this.fail(event, "This command may only be run in a discord server (Guild)");
            return;
        }
        UUID uUID = this.getMain().getLinkHandler().getUuid(event.getAuthor().getId());
        if (uUID == null) {
            this.fail(event, "Your account is not linked!");
            return;
        }
        UUID wagerUuid = uUID;
        OfflinePlayer wagerPlayer = this.getServer().getOfflinePlayer(wagerUuid);
        DiscordMember challenger = null;
        double wager = 0.0;
        if (event.isSlashCommand()) {
            Double d = event.getOptionDouble("wager");
            Intrinsics.checkNotNull(d);
            wager = d;
            DiscordMember discordMember = event.getOptionMember("user");
            Intrinsics.checkNotNull(discordMember);
            challenger = discordMember;
        } else {
            List<String> list = event.getArgs();
            Intrinsics.checkNotNull(list);
            if (list.isEmpty()) {
                this.fail(event, "User was not specified!");
                return;
            }
            if (event.memberMentionsSize() <= 0) {
                this.fail(event, "User not found!");
                return;
            }
            if (event.getArgs().size() < 2) {
                this.fail(event, "The amount to wager was not specified!");
                return;
            }
            challenger = event.getMemberMention(0);
            Double d = StringsKt.toDoubleOrNull(event.getArgs().get(1));
            if (d == null) {
                this.fail(event, "The wager must be an numeric value!");
                return;
            }
            wager = d;
        }
        if (Intrinsics.areEqual(challenger.getId(), event.getAuthor().getId())) {
            this.fail(event, "You may not play coinflip with yourself!");
            return;
        }
        double minBet = this.getMain().getPluginConfig().getMinBet();
        if (wager < minBet) {
            this.fail(event, "The wager may not be lower than " + minBet);
            return;
        }
        double maxBet = this.getMain().getPluginConfig().getMaxBet();
        if (wager > maxBet) {
            this.fail(event, "The wager may not be higher than " + maxBet);
            return;
        }
        if (!this.getMain().getEconomy().hasAccount(wagerPlayer)) {
            this.getMain().getEconomy().createPlayerAccount(wagerPlayer);
        }
        if (wager > (balance = this.getMain().getEconomy().getBalance(wagerPlayer))) {
            this.fail(event, "You don't have this much money to wager!");
            return;
        }
        UUID uUID2 = this.getMain().getLinkHandler().getUuid(challenger.getId());
        if (uUID2 == null) {
            this.fail(event, "The user that you're trying to challenge does not have their account linked!");
            return;
        }
        UUID challengerUuid = uUID2;
        OfflinePlayer challengerPlayer = this.getServer().getOfflinePlayer(challengerUuid);
        if (!this.getMain().getEconomy().hasAccount(challengerPlayer)) {
            this.getMain().getEconomy().createPlayerAccount(challengerPlayer);
        }
        if (wager > (challengerBalance = this.getMain().getEconomy().getBalance(challengerPlayer))) {
            this.fail(event, "The opponent does not have enough money to accept!");
            return;
        }
        DecimalFormat formatter = new DecimalFormat("#,###.##");
        Function5<DiscordMember, DiscordMember, OfflinePlayer, String, ComponentInteractionEvent, Unit> $fun$sendMsg$1 = new Function5<DiscordMember, DiscordMember, OfflinePlayer, String, ComponentInteractionEvent, Unit>(this, event, wager, formatter){
            final /* synthetic */ Coinflip this$0;
            final /* synthetic */ CommandEventData $event;
            final /* synthetic */ double $wager;
            final /* synthetic */ DecimalFormat $formatter;

            public final void invoke(@NotNull DiscordMember winner, @NotNull DiscordMember loser, @NotNull OfflinePlayer winnerServer, @NotNull String landSide, @NotNull ComponentInteractionEvent bevent) {
                Intrinsics.checkNotNullParameter(winner, "winner");
                Intrinsics.checkNotNullParameter(loser, "loser");
                Intrinsics.checkNotNullParameter(winnerServer, "winnerServer");
                Intrinsics.checkNotNullParameter(landSide, "landSide");
                Intrinsics.checkNotNullParameter(bevent, "bevent");
                bevent.editMessage(ComponentInteractionEvent.getYMLEmbed$default(bevent, "coinflipCommandEmbed", new Function1<String, String>(this, winner, winnerServer, loser, landSide){
                    final /* synthetic */ run.1 this$0;
                    final /* synthetic */ DiscordMember $winner;
                    final /* synthetic */ OfflinePlayer $winnerServer;
                    final /* synthetic */ DiscordMember $loser;
                    final /* synthetic */ String $landSide;

                    @NotNull
                    public final String invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        String form2 = DiscordUtilsKt.setCommandPlaceholders(it, this.this$0.$event.getPrefix(), this.this$0.$event.getCommandName(), this.this$0.this$0.getDescription(), this.this$0.this$0.getUsage());
                        return StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(DiscordUtilsKt.setPlaceholdersForDiscordMessage(this.$winner, this.$winnerServer, form2), "%discord_other_username%", this.$loser.getUser().getName(), false, 4, null), "%discord_other_tag%", this.$loser.getUser().getAsTag(), false, 4, null), "%discord_other_discriminator%", this.$loser.getUser().getDiscriminator(), false, 4, null), "{land_side}", this.$landSide, false, 4, null), "{amount_wagered}", UtilsKt.formatMoney(this.this$0.$wager, Coinflip.access$getMain$p(this.this$0.this$0).getPluginConfig().getCurrency(), Coinflip.access$getMain$p(this.this$0.this$0).getPluginConfig().getCurrencyLeftSide(), this.this$0.$formatter), false, 4, null);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$winner = discordMember;
                        this.$winnerServer = offlinePlayer;
                        this.$loser = discordMember2;
                        this.$landSide = string;
                        super(1);
                    }
                }, null, false, 12, null)).removeActinRows().queue();
            }
            {
                this.this$0 = coinflip;
                this.$event = commandEventData;
                this.$wager = d;
                this.$formatter = decimalFormat;
                super(5);
            }
        };
        Function2<ComponentInteractionEvent, Message, Unit> $fun$decline$2 = new Function2<ComponentInteractionEvent, Message, Unit>(this, event, wagerPlayer, challenger, wager, formatter){
            final /* synthetic */ Coinflip this$0;
            final /* synthetic */ CommandEventData $event;
            final /* synthetic */ OfflinePlayer $wagerPlayer;
            final /* synthetic */ DiscordMember $challenger;
            final /* synthetic */ double $wager;
            final /* synthetic */ DecimalFormat $formatter;

            public final void invoke(@Nullable ComponentInteractionEvent bevent, @Nullable Message msg) {
                Coinflip.access$getMain$p(this.this$0).getCommandHandler().removeCooldown(this.this$0, this.$event);
                DiscordEmbed embed2 = CommandEventData.getYMLEmbed$default(this.$event, "coinflipCommandDeclineEmbed", new Function1<String, String>(this){
                    final /* synthetic */ run.2 this$0;

                    @NotNull
                    public final String invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        String form2 = DiscordUtilsKt.setCommandPlaceholders(it, this.this$0.$event.getPrefix(), this.this$0.$event.getCommandName(), this.this$0.this$0.getDescription(), this.this$0.this$0.getUsage());
                        DiscordMember discordMember = this.this$0.$event.getMember();
                        Intrinsics.checkNotNull(discordMember);
                        OfflinePlayer offlinePlayer = this.this$0.$wagerPlayer;
                        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "wagerPlayer");
                        return StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(DiscordUtilsKt.setPlaceholdersForDiscordMessage(discordMember, offlinePlayer, form2), "%discord_other_username%", this.this$0.$challenger.getUser().getName(), false, 4, null), "%discord_other_tag%", this.this$0.$challenger.getUser().getAsTag(), false, 4, null), "%discord_other_discriminator%", this.this$0.$challenger.getUser().getDiscriminator(), false, 4, null), "{amount_wagered}", UtilsKt.formatMoney(this.this$0.$wager, Coinflip.access$getMain$p(this.this$0.this$0).getPluginConfig().getCurrency(), Coinflip.access$getMain$p(this.this$0.this$0).getPluginConfig().getCurrencyLeftSide(), this.this$0.$formatter), false, 4, null);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }, null, false, 12, null);
                if (bevent == null) {
                    Message message = msg;
                    Intrinsics.checkNotNull(message);
                    message.editMessage(embed2).queue();
                } else {
                    bevent.editMessage(embed2).removeActinRows().queue();
                }
            }

            public static /* synthetic */ void invoke$default(run.2 var0, ComponentInteractionEvent componentInteractionEvent, Message message, int n, Object object) {
                if ((n & 1) != 0) {
                    componentInteractionEvent = null;
                }
                if ((n & 2) != 0) {
                    message = null;
                }
                var0.invoke(componentInteractionEvent, message);
            }
            {
                this.this$0 = coinflip;
                this.$event = commandEventData;
                this.$wagerPlayer = offlinePlayer;
                this.$challenger = discordMember;
                this.$wager = d;
                this.$formatter = decimalFormat;
                super(2);
            }
        };
        this.getMain().getCommandHandler().commandComplete(this, event);
        MessageAction messageAction = CommandEventData.sendYMLEmbed$default(event, "coinflipCommandConfirmEmbed", new Function1<String, String>(this, event, wagerPlayer, challenger, wager, formatter){
            final /* synthetic */ Coinflip this$0;
            final /* synthetic */ CommandEventData $event;
            final /* synthetic */ OfflinePlayer $wagerPlayer;
            final /* synthetic */ DiscordMember $challenger;
            final /* synthetic */ double $wager;
            final /* synthetic */ DecimalFormat $formatter;

            @NotNull
            public final String invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                String form2 = DiscordUtilsKt.setCommandPlaceholders(it, this.$event.getPrefix(), this.$event.getCommandName(), this.this$0.getDescription(), this.this$0.getUsage());
                DiscordMember discordMember = this.$event.getMember();
                Intrinsics.checkNotNull(discordMember);
                OfflinePlayer offlinePlayer = this.$wagerPlayer;
                Intrinsics.checkNotNullExpressionValue(offlinePlayer, "wagerPlayer");
                return StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(DiscordUtilsKt.setPlaceholdersForDiscordMessage(discordMember, offlinePlayer, form2), "%discord_other_username%", this.$challenger.getUser().getName(), false, 4, null), "%discord_other_tag%", this.$challenger.getUser().getAsTag(), false, 4, null), "%discord_other_discriminator%", this.$challenger.getUser().getDiscriminator(), false, 4, null), "{amount_wagered}", UtilsKt.formatMoney(this.$wager, Coinflip.access$getMain$p(this.this$0).getPluginConfig().getCurrency(), Coinflip.access$getMain$p(this.this$0).getPluginConfig().getCurrencyLeftSide(), this.$formatter), false, 4, null);
            }
            {
                this.this$0 = coinflip;
                this.$event = commandEventData;
                this.$wagerPlayer = offlinePlayer;
                this.$challenger = discordMember;
                this.$wager = d;
                this.$formatter = decimalFormat;
                super(1);
            }
        }, null, false, 12, null);
        String string2 = DiscordUtilsKt.getStringOrStringList("coinflipButtonAccept", this.getMain().getDiscordMessagesConfig());
        if (string2 == null) {
            string2 = "Accept";
        }
        if ((string = DiscordUtilsKt.getStringOrStringList("coinflipButtonDecline", this.getMain().getDiscordMessagesConfig())) == null) {
            string = "Decline";
        }
        messageAction.setYesOrNoButtons(string2, string).queue((Function1<? super Message, Unit>)new Function1<Message, Unit>(this, challenger, wagerPlayer, wager, challengerPlayer, $fun$sendMsg$1, event, $fun$decline$2){
            final /* synthetic */ Coinflip this$0;
            final /* synthetic */ DiscordMember $challenger;
            final /* synthetic */ OfflinePlayer $wagerPlayer;
            final /* synthetic */ double $wager;
            final /* synthetic */ OfflinePlayer $challengerPlayer;
            final /* synthetic */ run.1 $sendMsg$1;
            final /* synthetic */ CommandEventData $event;
            final /* synthetic */ run.2 $decline$2;

            public final void invoke(@NotNull Message message) {
                Intrinsics.checkNotNullParameter(message, "message");
                message.awaitYesOrNo(Coinflip.access$getMain$p(this.this$0).getPluginConfig().getCommandTimeout(), (Function1<? super ComponentInteractionEvent, Boolean>)new Function1<ComponentInteractionEvent, Boolean>(this){
                    final /* synthetic */ run.4 this$0;

                    public final boolean invoke(@NotNull ComponentInteractionEvent it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return Intrinsics.areEqual(it.getUser().getId(), this.this$0.$challenger.getId());
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }, (Function3<? super Boolean, ? super ComponentInteractionEvent, ? super Boolean, Unit>)new Function3<Boolean, ComponentInteractionEvent, Boolean, Unit>(this, message){
                    final /* synthetic */ run.4 this$0;
                    final /* synthetic */ Message $message;

                    public final void invoke(boolean outcome, @Nullable ComponentInteractionEvent interaction, boolean deleted) {
                        if (outcome) {
                            double currentBalancePlayer = Coinflip.access$getMain$p(this.this$0.this$0).getEconomy().getBalance(this.this$0.$wagerPlayer);
                            if (this.this$0.$wager > currentBalancePlayer) {
                                Coinflip coinflip = this.this$0.this$0;
                                ComponentInteractionEvent componentInteractionEvent = interaction;
                                Intrinsics.checkNotNull(componentInteractionEvent);
                                coinflip.fail(componentInteractionEvent, "You don't have enough money.");
                                return;
                            }
                            double currentBalanceOpp = Coinflip.access$getMain$p(this.this$0.this$0).getEconomy().getBalance(this.this$0.$challengerPlayer);
                            if (this.this$0.$wager > currentBalanceOpp) {
                                Coinflip coinflip = this.this$0.this$0;
                                ComponentInteractionEvent componentInteractionEvent = interaction;
                                Intrinsics.checkNotNull(componentInteractionEvent);
                                coinflip.fail(componentInteractionEvent, "The opponent does not have enough money.");
                                return;
                            }
                            if (Random.Default.nextInt(0, 2) > 0) {
                                if (!Coinflip.access$getMain$p(this.this$0.this$0).getEconomy().hasAccount(this.this$0.$challengerPlayer)) {
                                    Coinflip.access$getMain$p(this.this$0.this$0).getEconomy().createPlayerAccount(this.this$0.$challengerPlayer);
                                }
                                Coinflip.access$getMain$p(this.this$0.this$0).getEconomy().depositPlayer(this.this$0.$challengerPlayer, this.this$0.$wager);
                                Coinflip.access$getMain$p(this.this$0.this$0).getEconomy().withdrawPlayer(this.this$0.$wagerPlayer, this.this$0.$wager);
                                run.1 v4 = this.this$0.$sendMsg$1;
                                DiscordMember discordMember = this.this$0.$challenger;
                                DiscordMember discordMember2 = this.this$0.$event.getMember();
                                Intrinsics.checkNotNull(discordMember2);
                                OfflinePlayer offlinePlayer = this.this$0.$challengerPlayer;
                                Intrinsics.checkNotNullExpressionValue(offlinePlayer, "challengerPlayer");
                                ComponentInteractionEvent componentInteractionEvent = interaction;
                                Intrinsics.checkNotNull(componentInteractionEvent);
                                v4.invoke(discordMember, discordMember2, offlinePlayer, "tail", componentInteractionEvent);
                            } else {
                                if (!Coinflip.access$getMain$p(this.this$0.this$0).getEconomy().hasAccount(this.this$0.$challengerPlayer)) {
                                    Coinflip.access$getMain$p(this.this$0.this$0).getEconomy().createPlayerAccount(this.this$0.$challengerPlayer);
                                }
                                Coinflip.access$getMain$p(this.this$0.this$0).getEconomy().depositPlayer(this.this$0.$wagerPlayer, this.this$0.$wager);
                                Coinflip.access$getMain$p(this.this$0.this$0).getEconomy().withdrawPlayer(this.this$0.$challengerPlayer, this.this$0.$wager);
                                run.1 v9 = this.this$0.$sendMsg$1;
                                DiscordMember discordMember = this.this$0.$event.getMember();
                                Intrinsics.checkNotNull(discordMember);
                                DiscordMember discordMember3 = this.this$0.$challenger;
                                OfflinePlayer offlinePlayer = this.this$0.$wagerPlayer;
                                Intrinsics.checkNotNullExpressionValue(offlinePlayer, "wagerPlayer");
                                ComponentInteractionEvent componentInteractionEvent = interaction;
                                Intrinsics.checkNotNull(componentInteractionEvent);
                                v9.invoke(discordMember, discordMember3, offlinePlayer, "head", componentInteractionEvent);
                            }
                        } else if (!deleted) {
                            if (interaction == null) {
                                this.this$0.$decline$2.invoke(null, this.$message);
                            } else {
                                run.2.invoke$default(this.this$0.$decline$2, interaction, null, 2, null);
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$message = message;
                        super(3);
                    }
                });
            }
            {
                this.this$0 = coinflip;
                this.$challenger = discordMember;
                this.$wagerPlayer = offlinePlayer;
                this.$wager = d;
                this.$challengerPlayer = offlinePlayer2;
                this.$sendMsg$1 = var7_6;
                this.$event = commandEventData;
                this.$decline$2 = var9_8;
                super(1);
            }
        });
    }

    public Coinflip(@NotNull DiscordEconomyBridge main) {
        Intrinsics.checkNotNullParameter((Object)main, "main");
        super(main);
        this.isGame = true;
    }

    public static final /* synthetic */ DiscordEconomyBridge access$getMain$p(Coinflip $this) {
        return $this.getMain();
    }
}

