/*
 * Decompiled with CFR 0.152.
 */
package me.pliexe.discordeconomybridge.discord;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.clip.placeholderapi.PlaceholderAPI;
import me.pliexe.discordeconomybridge.DiscordEconomyBridge;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0019\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000eJ\b\u0010#\u001a\u00020\u000eH\u0016J\u0016\u0010$\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006&"}, d2={"Lme/pliexe/discordeconomybridge/discord/UniversalPlayer;", "", "player", "Lorg/bukkit/entity/Player;", "(Lorg/bukkit/entity/Player;)V", "Lorg/bukkit/OfflinePlayer;", "(Lorg/bukkit/OfflinePlayer;)V", "onlinePlayer", "offlinePlayer", "(Lorg/bukkit/entity/Player;Lorg/bukkit/OfflinePlayer;)V", "isOnline", "", "()Z", "name", "", "getName", "()Ljava/lang/String;", "getOfflinePlayer", "()Lorg/bukkit/OfflinePlayer;", "getOnlinePlayer", "()Lorg/bukkit/entity/Player;", "uniqueId", "Ljava/util/UUID;", "getUniqueId", "()Ljava/util/UUID;", "createEconomyAccountIfNotPresent", "", "main", "Lme/pliexe/discordeconomybridge/DiscordEconomyBridge;", "depositPlayer", "amount", "", "getBalance", "setPlaceholderAPI", "text", "toString", "withdrawPlayer", "Companion", "DiscordEconomyBridge"})
public final class UniversalPlayer {
    @Nullable
    private final Player onlinePlayer;
    @Nullable
    private final OfflinePlayer offlinePlayer;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String toString() {
        return this.getName();
    }

    @NotNull
    public final String getName() {
        Object object = this.onlinePlayer;
        if (object == null || (object = object.getName()) == null) {
            OfflinePlayer offlinePlayer = this.offlinePlayer;
            Intrinsics.checkNotNull(offlinePlayer);
            String string = offlinePlayer.getName();
            object = string;
            Intrinsics.checkNotNullExpressionValue(string, "offlinePlayer!!.name");
        }
        return object;
    }

    @NotNull
    public final UUID getUniqueId() {
        Object object = this.onlinePlayer;
        if (object == null || (object = object.getUniqueId()) == null) {
            OfflinePlayer offlinePlayer = this.offlinePlayer;
            Intrinsics.checkNotNull(offlinePlayer);
            UUID uUID = offlinePlayer.getUniqueId();
            object = uUID;
            Intrinsics.checkNotNullExpressionValue(uUID, "offlinePlayer!!.uniqueId");
        }
        return object;
    }

    public final boolean isOnline() {
        boolean bl;
        Player player = this.onlinePlayer;
        if (player != null) {
            bl = player.isOnline();
        } else {
            OfflinePlayer offlinePlayer = this.offlinePlayer;
            Intrinsics.checkNotNull(offlinePlayer);
            bl = offlinePlayer.isOnline();
        }
        return bl;
    }

    @NotNull
    public final String setPlaceholderAPI(@NotNull String text) {
        String string;
        Intrinsics.checkNotNullParameter(text, "text");
        if (this.onlinePlayer == null) {
            String string2 = PlaceholderAPI.setPlaceholders((OfflinePlayer)this.offlinePlayer, (String)text);
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "PlaceholderAPI.setPlaceh\u2026ders(offlinePlayer, text)");
        } else {
            String string3 = PlaceholderAPI.setPlaceholders((Player)this.onlinePlayer, (String)text);
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "PlaceholderAPI.setPlaceholders(onlinePlayer, text)");
        }
        return string;
    }

    public final double getBalance(@NotNull DiscordEconomyBridge main) {
        double d;
        Intrinsics.checkNotNullParameter((Object)main, "main");
        if (this.onlinePlayer == null) {
            if (main.getEconomy().hasAccount(this.offlinePlayer)) {
                Economy economy = main.getEconomy();
                OfflinePlayer offlinePlayer = this.offlinePlayer;
                Intrinsics.checkNotNull(offlinePlayer);
                d = economy.getBalance(offlinePlayer);
            } else {
                d = 0.0;
            }
        } else {
            d = main.getEconomy().hasAccount((OfflinePlayer)this.onlinePlayer) ? main.getEconomy().getBalance((OfflinePlayer)this.onlinePlayer) : 0.0;
        }
        return d;
    }

    public final void createEconomyAccountIfNotPresent(@NotNull DiscordEconomyBridge main) {
        Intrinsics.checkNotNullParameter((Object)main, "main");
        if (this.onlinePlayer == null) {
            Economy economy = main.getEconomy();
            OfflinePlayer offlinePlayer = this.offlinePlayer;
            Intrinsics.checkNotNull(offlinePlayer);
            if (!economy.hasAccount(offlinePlayer)) {
                main.getEconomy().createPlayerAccount(this.offlinePlayer);
            }
        } else if (!main.getEconomy().hasAccount((OfflinePlayer)this.onlinePlayer)) {
            main.getEconomy().createPlayerAccount(this.offlinePlayer);
        }
    }

    public final void depositPlayer(@NotNull DiscordEconomyBridge main, double amount) {
        Intrinsics.checkNotNullParameter((Object)main, "main");
        if (this.onlinePlayer == null) {
            Economy economy = main.getEconomy();
            OfflinePlayer offlinePlayer = this.offlinePlayer;
            Intrinsics.checkNotNull(offlinePlayer);
            economy.depositPlayer(offlinePlayer, amount);
        } else {
            main.getEconomy().depositPlayer((OfflinePlayer)this.onlinePlayer, amount);
        }
    }

    public final void withdrawPlayer(@NotNull DiscordEconomyBridge main, double amount) {
        Intrinsics.checkNotNullParameter((Object)main, "main");
        if (this.onlinePlayer == null) {
            Economy economy = main.getEconomy();
            OfflinePlayer offlinePlayer = this.offlinePlayer;
            Intrinsics.checkNotNull(offlinePlayer);
            economy.withdrawPlayer(offlinePlayer, amount);
        } else {
            main.getEconomy().withdrawPlayer((OfflinePlayer)this.onlinePlayer, amount);
        }
    }

    @Nullable
    public final Player getOnlinePlayer() {
        return this.onlinePlayer;
    }

    @Nullable
    public final OfflinePlayer getOfflinePlayer() {
        return this.offlinePlayer;
    }

    public UniversalPlayer(@Nullable Player onlinePlayer, @Nullable OfflinePlayer offlinePlayer) {
        this.onlinePlayer = onlinePlayer;
        this.offlinePlayer = offlinePlayer;
    }

    public UniversalPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this(player, null);
    }

    public UniversalPlayer(@NotNull OfflinePlayer player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this(null, player);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"Lme/pliexe/discordeconomybridge/discord/UniversalPlayer$Companion;", "", "()V", "getByString", "Lme/pliexe/discordeconomybridge/discord/UniversalPlayer;", "getter", "", "getByUUID", "uuid", "Ljava/util/UUID;", "getByUUIDorNull", "getByUsername", "username", "DiscordEconomyBridge"})
    public static final class Companion {
        @NotNull
        public final UniversalPlayer getByUUID(@NotNull UUID uuid) {
            UniversalPlayer universalPlayer;
            Intrinsics.checkNotNullParameter(uuid, "uuid");
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
                if (offlinePlayer == null) {
                    throw (Throwable)new Error("The player couldn't be gotten!");
                }
                OfflinePlayer offlinePlayer2 = offlinePlayer;
                universalPlayer = new UniversalPlayer(offlinePlayer2);
            } else {
                universalPlayer = new UniversalPlayer(player);
            }
            return universalPlayer;
        }

        @Nullable
        public final UniversalPlayer getByUUIDorNull(@NotNull UUID uuid) {
            UniversalPlayer universalPlayer;
            Intrinsics.checkNotNullParameter(uuid, "uuid");
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
                if (offlinePlayer == null) {
                    return null;
                }
                OfflinePlayer offlinePlayer2 = offlinePlayer;
                universalPlayer = new UniversalPlayer(offlinePlayer2);
            } else {
                universalPlayer = new UniversalPlayer(player);
            }
            return universalPlayer;
        }

        @Nullable
        public final UniversalPlayer getByUsername(@NotNull String username) {
            UniversalPlayer universalPlayer;
            Intrinsics.checkNotNullParameter(username, "username");
            Player player = Bukkit.getPlayer((String)username);
            if (player != null) {
                Player player2 = player;
                boolean bl = false;
                boolean bl2 = false;
                Player it = player2;
                boolean bl3 = false;
                universalPlayer = new UniversalPlayer(it);
            } else {
                Companion companion = this;
                boolean bl = false;
                boolean bl4 = false;
                Companion $this$run = companion;
                boolean bl5 = false;
                String string = DiscordEconomyBridge.Companion.getUserCache().getString(username);
                if (string != null) {
                    OfflinePlayer offlinePlayer;
                    String string2 = string;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    String uuid = string2;
                    boolean bl8 = false;
                    try {
                        UniversalPlayer universalPlayer2;
                        OfflinePlayer offlinePlayer2 = Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuid));
                        if (offlinePlayer2 != null) {
                            offlinePlayer = offlinePlayer2;
                            boolean bl9 = false;
                            boolean bl10 = false;
                            OfflinePlayer it = offlinePlayer;
                            boolean bl11 = false;
                            universalPlayer2 = new UniversalPlayer(it);
                        } else {
                            universalPlayer2 = null;
                        }
                        offlinePlayer = universalPlayer2;
                    }
                    catch (IllegalArgumentException e) {
                        offlinePlayer = null;
                    }
                    universalPlayer = offlinePlayer;
                } else {
                    universalPlayer = null;
                }
            }
            return universalPlayer;
        }

        @Nullable
        public final UniversalPlayer getByString(@NotNull String getter) {
            UniversalPlayer universalPlayer;
            Intrinsics.checkNotNullParameter(getter, "getter");
            try {
                UniversalPlayer universalPlayer2 = this.getByUsername(getter);
                if (universalPlayer2 == null) {
                    UUID uUID = UUID.fromString(getter);
                    Intrinsics.checkNotNullExpressionValue(uUID, "UUID.fromString(getter)");
                    universalPlayer2 = this.getByUUIDorNull(uUID);
                }
                universalPlayer = universalPlayer2;
            }
            catch (IllegalArgumentException e) {
                universalPlayer = null;
            }
            return universalPlayer;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

