/*
 * Decompiled with CFR 0.152.
 */
package me.pliexe.discordeconomybridge.discord;

import de.leonhard.storage.Config;
import java.util.Collection;
import javax.security.auth.login.LoginException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.pliexe.discordeconomybridge.DiscordEconomyBridge;
import me.pliexe.discordeconomybridge.discord.Listener;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.requests.GatewayIntent;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a \u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"getActivity", "Lnet/dv8tion/jda/api/entities/Activity;", "defaultConfig", "Lde/leonhard/storage/Config;", "registerClient", "Lnet/dv8tion/jda/api/JDA;", "main", "Lme/pliexe/discordeconomybridge/DiscordEconomyBridge;", "token", "", "DiscordEconomyBridge"})
public final class RegisterCustomClientKt {
    @Nullable
    public static final JDA registerClient(@NotNull DiscordEconomyBridge main, @NotNull Config defaultConfig, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)main, "main");
        Intrinsics.checkNotNullParameter(defaultConfig, "defaultConfig");
        Intrinsics.checkNotNullParameter(token, "token");
        try {
            JDABuilder jDABuilder = JDABuilder.createDefault(token).setAutoReconnect(true);
            Object[] objectArray = new Object[1];
            Server server = main.getServer();
            Intrinsics.checkNotNullExpressionValue(server, "main.server");
            objectArray[0] = new Listener(main, server);
            return jDABuilder.addEventListeners(objectArray).setActivity(RegisterCustomClientKt.getActivity(defaultConfig)).enableIntents((Collection<GatewayIntent>)CollectionsKt.mutableListOf(GatewayIntent.GUILD_MEMBERS, GatewayIntent.GUILD_MESSAGES, GatewayIntent.DIRECT_MESSAGES)).build();
        }
        catch (LoginException e) {
            main.getLogger().severe("Failed connecting to discord! Disabling plugin!\nReason: " + e.getMessage());
            main.getPluginLoader().disablePlugin((Plugin)main);
            return null;
        }
        catch (Exception e) {
            if (e instanceof IllegalStateException && StringsKt.equals$default(e.getMessage(), "Was shutdown trying to await status", false, 2, null)) {
                main.getPluginLoader().disablePlugin((Plugin)main);
                return null;
            }
            main.getLogger().warning("An unknown error occurred building JDA...\nError:" + e.getMessage() + '\n' + ExceptionsKt.stackTraceToString(e));
            main.getPluginLoader().disablePlugin((Plugin)main);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final Activity getActivity(@NotNull Config defaultConfig) {
        Intrinsics.checkNotNullParameter(defaultConfig, "defaultConfig");
        try {
            String message = defaultConfig.getString("statusMessage");
            if (message == null) return null;
            String string = defaultConfig.getString("statusType");
            if (string == null) return null;
            switch (string) {
                case "Playing": 
                case "playing": {
                    Activity activity = Activity.playing(message);
                    return activity;
                }
                case "Watching": 
                case "watching": {
                    Activity activity = Activity.watching(message);
                    return activity;
                }
                case "Streaming": 
                case "streaming": {
                    Activity activity = Activity.streaming(message, defaultConfig.getString("statusStreamURL"));
                    return activity;
                }
                case "listening": 
                case "Listening": {
                    Activity activity = Activity.listening(message);
                    return activity;
                }
                default: {
                    return null;
                }
            }
        }
        catch (ClassCastException e) {
            DiscordEconomyBridge.Companion.getLogger().severe("Type statusType or statusMessage is not a text (string). The plugin will continue to load.");
            return null;
        }
    }
}

