/*
 * Decompiled with CFR 0.152.
 */
package me.pliexe.discordeconomybridge.discord;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.pliexe.discordeconomybridge.DiscordEconomyBridge;
import me.pliexe.discordeconomybridge.discord.Command;
import me.pliexe.discordeconomybridge.discord.ComponentInteractionEvent;
import me.pliexe.discordeconomybridge.discord.DiscordEmbed;
import me.pliexe.discordeconomybridge.discord.DiscordUser;
import me.pliexe.discordeconomybridge.discord.DiscordUtilsKt;
import me.pliexe.discordeconomybridge.discord.LinkHandler;
import me.pliexe.discordeconomybridge.discord.Listener;
import me.pliexe.discordeconomybridge.discord.MessageDeleteEvent;
import me.pliexe.discordeconomybridge.discord.UniversalPlayer;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.PrivateChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.ReadyEvent;
import net.dv8tion.jda.api.events.interaction.GenericComponentInteractionCreateEvent;
import net.dv8tion.jda.api.events.interaction.SlashCommandEvent;
import net.dv8tion.jda.api.events.message.guild.GuildMessageReceivedEvent;
import net.dv8tion.jda.api.events.message.priv.PrivateMessageReceivedEvent;
import net.dv8tion.jda.api.exceptions.ContextException;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.components.ComponentInteraction;
import net.dv8tion.jda.api.requests.restaction.CommandListUpdateAction;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lme/pliexe/discordeconomybridge/discord/Listener;", "Lnet/dv8tion/jda/api/hooks/ListenerAdapter;", "main", "Lme/pliexe/discordeconomybridge/DiscordEconomyBridge;", "server", "Lorg/bukkit/Server;", "(Lme/pliexe/discordeconomybridge/DiscordEconomyBridge;Lorg/bukkit/Server;)V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getMain", "()Lme/pliexe/discordeconomybridge/DiscordEconomyBridge;", "init", "", "onGenericComponentInteractionCreate", "event", "Lnet/dv8tion/jda/api/events/interaction/GenericComponentInteractionCreateEvent;", "onGuildMessageReceived", "Lnet/dv8tion/jda/api/events/message/guild/GuildMessageReceivedEvent;", "onMessageDelete", "Lnet/dv8tion/jda/api/events/message/MessageDeleteEvent;", "onPrivateMessageReceived", "Lnet/dv8tion/jda/api/events/message/priv/PrivateMessageReceivedEvent;", "onReady", "Lnet/dv8tion/jda/api/events/ReadyEvent;", "onSlashCommand", "Lnet/dv8tion/jda/api/events/interaction/SlashCommandEvent;", "registerSlashCommands", "guild", "Lnet/dv8tion/jda/api/entities/Guild;", "DiscordEconomyBridge"})
public final class Listener
extends ListenerAdapter {
    private final Logger logger;
    @NotNull
    private final DiscordEconomyBridge main;

    public final void init() {
        this.logger.info("[Bot] Loading Commands!");
        this.main.getCommandHandler().loadCommands();
        this.logger.info("[Bot] Loading command Aliases!");
        this.main.getCommandHandler().loadAliases();
        this.logger.info("[Bot] Loading command cooldowns!");
        this.main.getCommandHandler().loadCooldowns();
        if (this.main.getDefaultConfig().contains("slashCommandServers")) {
            try {
                List<String> list = this.main.getDefaultConfig().getStringList("slashCommandServers");
                Intrinsics.checkNotNullExpressionValue(list, "main.defaultConfig.getSt\u2026st(\"slashCommandServers\")");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String guildID = (String)element$iv;
                    boolean bl = false;
                    JDA jDA = this.main.getJda();
                    Intrinsics.checkNotNull(jDA);
                    Guild guild = jDA.getGuildById(guildID);
                    if (guild == null) continue;
                    this.registerSlashCommands(guild);
                }
            }
            catch (ClassCastException e) {
                this.main.getLogger().severe("Field \"slashCommandServers\" is of an invalid type, it must be an list of strings. The plugin will continue and ignore this configuration.");
            }
        }
    }

    private final void registerSlashCommands(Guild guild) {
        try {
            this.logger.info("Registering slash commands for the guild \"" + guild.getName() + "\" : " + guild.getId());
            CommandListUpdateAction commandListUpdateAction = guild.updateCommands();
            Intrinsics.checkNotNullExpressionValue(commandListUpdateAction, "guild.updateCommands()");
            CommandListUpdateAction updateCommands = commandListUpdateAction;
            Map $this$forEach$iv = this.main.getCommandHandler().getCommands();
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv;
            boolean bl = false;
            Iterator iterator2 = map.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $dstr$_u24__u24$value = element$iv = iterator2.next();
                boolean bl2 = false;
                Map.Entry entry = $dstr$_u24__u24$value;
                boolean bl3 = false;
                Command value = (Command)entry.getValue();
                updateCommands.addCommands(value.getSlashCommandDataNative());
            }
            updateCommands.queue(registerSlashCommands.2.INSTANCE);
            this.logger.info("Done registering slash commands for \"" + guild.getName() + "\" : " + guild.getId());
        }
        catch (ContextException e) {
            this.main.getLogger().severe("Did you invite your bot with applications.commands scope?");
            e.printStackTrace();
        }
    }

    @Override
    public void onReady(@NotNull ReadyEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.init();
        this.logger.info("[Discord Economy Bridge Bot] Bot online!");
    }

    @Override
    public void onGuildMessageReceived(@NotNull GuildMessageReceivedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.main.getCommandHandler().runCommand(event);
    }

    @Override
    public void onGenericComponentInteractionCreate(@NotNull GenericComponentInteractionCreateEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter(event, "event");
            HashMap<String, Function1<ComponentInteractionEvent, Unit>> hashMap = this.main.getCommandHandler().getEvents();
            ComponentInteraction componentInteraction = event.getInteraction();
            Intrinsics.checkNotNullExpressionValue(componentInteraction, "event.interaction");
            Function1<ComponentInteractionEvent, Unit> function1 = hashMap.get(componentInteraction.getMessageId());
            if (function1 == null) break block0;
            Function1<ComponentInteractionEvent, Unit> function12 = function1;
            boolean bl = false;
            boolean bl2 = false;
            Function1<ComponentInteractionEvent, Unit> it = function12;
            boolean bl3 = false;
            it.invoke(new ComponentInteractionEvent(this.main, event));
        }
    }

    @Override
    public void onMessageDelete(@NotNull net.dv8tion.jda.api.events.message.MessageDeleteEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter(event, "event");
            Function1<MessageDeleteEvent, Unit> function1 = this.main.getCommandHandler().getMessageDeleteEvents().get(event.getMessageId());
            if (function1 == null) break block0;
            Function1<MessageDeleteEvent, Unit> function12 = function1;
            boolean bl = false;
            boolean bl2 = false;
            Function1<MessageDeleteEvent, Unit> it = function12;
            boolean bl3 = false;
            it.invoke(new MessageDeleteEvent(event));
        }
    }

    @Override
    public void onSlashCommand(@NotNull SlashCommandEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.main.getCommandHandler().runCommand(event);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onPrivateMessageReceived(@NotNull PrivateMessageReceivedEvent event) {
        String content;
        String string;
        Intrinsics.checkNotNullParameter(event, "event");
        User user = event.getAuthor();
        Intrinsics.checkNotNullExpressionValue(user, "event.author");
        if (user.isBot()) {
            return;
        }
        Message message = event.getMessage();
        Intrinsics.checkNotNullExpressionValue(message, "event.message");
        if (message.getContentRaw().length() == 4) {
            String content2;
            String string2;
            LinkHandler linkHandler = this.main.getLinkHandler();
            Message message2 = event.getMessage();
            Intrinsics.checkNotNullExpressionValue(message2, "event.message");
            String string3 = message2.getContentRaw();
            Intrinsics.checkNotNullExpressionValue(string3, "event.message.contentRaw");
            User user2 = event.getAuthor();
            Intrinsics.checkNotNullExpressionValue(user2, "event.author");
            String string4 = user2.getId();
            Intrinsics.checkNotNullExpressionValue(string4, "event.author.id");
            if (linkHandler.tryLink(string3, string4)) {
                String content3;
                String string5;
                LinkHandler linkHandler2 = this.main.getLinkHandler();
                User user3 = event.getAuthor();
                Intrinsics.checkNotNullExpressionValue(user3, "event.author");
                String string6 = user3.getId();
                Intrinsics.checkNotNullExpressionValue(string6, "event.author.id");
                OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)linkHandler2.getUuid(string6));
                DiscordEmbed embed2 = DiscordUtilsKt.getYMLEmbed$default(this.main, new DiscordEmbed(new EmbedBuilder(), null), "accountLinkSuccessful", new Function1<String, String>(event, player){
                    final /* synthetic */ PrivateMessageReceivedEvent $event;
                    final /* synthetic */ OfflinePlayer $player;

                    @NotNull
                    public final String invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        User user = this.$event.getAuthor();
                        Intrinsics.checkNotNullExpressionValue(user, "event.author");
                        DiscordUser discordUser = new DiscordUser(user);
                        OfflinePlayer offlinePlayer = this.$player;
                        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "player");
                        return DiscordUtilsKt.setPlaceholdersForDiscordMessage(discordUser, new UniversalPlayer(offlinePlayer), it);
                    }
                    {
                        this.$event = privateMessageReceivedEvent;
                        this.$player = offlinePlayer;
                        super(1);
                    }
                }, null, false, 48, null);
                if (embed2.getContent() != null) {
                    User user4 = event.getAuthor();
                    Intrinsics.checkNotNullExpressionValue(user4, "event.author");
                    DiscordUser discordUser = new DiscordUser(user4);
                    OfflinePlayer offlinePlayer = player;
                    Intrinsics.checkNotNullExpressionValue(offlinePlayer, "player");
                    UniversalPlayer universalPlayer = new UniversalPlayer(offlinePlayer);
                    String string7 = embed2.getContent();
                    Intrinsics.checkNotNull(string7);
                    String string8 = DiscordUtilsKt.setPlaceholdersForDiscordMessage(discordUser, universalPlayer, string7);
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string8;
                    boolean bl3 = false;
                    embed2.setContent(it);
                    string5 = string8;
                } else {
                    string5 = content3 = null;
                }
                if (!embed2.isEmpty()) {
                    event.getChannel().sendMessageEmbeds(embed2.getNative().build(), new MessageEmbed[0]).content(content3).queue();
                    return;
                }
                if (embed2.getContent() != null) {
                    String string9 = embed2.getContent();
                    Intrinsics.checkNotNull(string9);
                    if (!string9.isEmpty()) {
                        PrivateChannel privateChannel = event.getChannel();
                        String string10 = content3;
                        Intrinsics.checkNotNull(string10);
                        privateChannel.sendMessage(string10).queue();
                        return;
                    }
                }
                DiscordEmbed discordEmbed = new DiscordEmbed(new EmbedBuilder(), null).setColor(47110).setTitle("Account successfully linked to Discord!");
                StringBuilder stringBuilder = new StringBuilder().append("Your account has been linked to **");
                OfflinePlayer offlinePlayer = player;
                Intrinsics.checkNotNullExpressionValue(offlinePlayer, "player");
                DiscordEmbed embed22 = discordEmbed.setDescription(stringBuilder.append(offlinePlayer.getName()).append("** (").append(player.getUniqueId()).append(").").toString());
                event.getChannel().sendMessageEmbeds(embed22.getNative().build(), new MessageEmbed[0]).queue();
                return;
            }
            LinkHandler linkHandler3 = this.main.getLinkHandler();
            User user5 = event.getAuthor();
            Intrinsics.checkNotNullExpressionValue(user5, "event.author");
            String string11 = user5.getId();
            Intrinsics.checkNotNullExpressionValue(string11, "event.author.id");
            if (linkHandler3.isLinked(string11)) {
                String content4;
                String string12;
                LinkHandler linkHandler4 = this.main.getLinkHandler();
                User user6 = event.getAuthor();
                Intrinsics.checkNotNullExpressionValue(user6, "event.author");
                String string13 = user6.getId();
                Intrinsics.checkNotNullExpressionValue(string13, "event.author.id");
                OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)linkHandler4.getUuid(string13));
                DiscordEmbed embed3 = DiscordUtilsKt.getYMLEmbed$default(this.main, new DiscordEmbed(new EmbedBuilder(), null), "accountAlreadyLinked", new Function1<String, String>(event, player){
                    final /* synthetic */ PrivateMessageReceivedEvent $event;
                    final /* synthetic */ OfflinePlayer $player;

                    @NotNull
                    public final String invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        User user = this.$event.getAuthor();
                        Intrinsics.checkNotNullExpressionValue(user, "event.author");
                        DiscordUser discordUser = new DiscordUser(user);
                        OfflinePlayer offlinePlayer = this.$player;
                        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "player");
                        return DiscordUtilsKt.setPlaceholdersForDiscordMessage(discordUser, new UniversalPlayer(offlinePlayer), it);
                    }
                    {
                        this.$event = privateMessageReceivedEvent;
                        this.$player = offlinePlayer;
                        super(1);
                    }
                }, null, false, 48, null);
                if (embed3.getContent() != null) {
                    User user7 = event.getAuthor();
                    Intrinsics.checkNotNullExpressionValue(user7, "event.author");
                    DiscordUser discordUser = new DiscordUser(user7);
                    OfflinePlayer offlinePlayer = player;
                    Intrinsics.checkNotNullExpressionValue(offlinePlayer, "player");
                    UniversalPlayer universalPlayer = new UniversalPlayer(offlinePlayer);
                    String string14 = embed3.getContent();
                    Intrinsics.checkNotNull(string14);
                    String string15 = DiscordUtilsKt.setPlaceholdersForDiscordMessage(discordUser, universalPlayer, string14);
                    boolean bl = false;
                    boolean bl4 = false;
                    String it = string15;
                    boolean bl5 = false;
                    embed3.setContent(it);
                    string12 = string15;
                } else {
                    string12 = content4 = null;
                }
                if (!embed3.isEmpty()) {
                    event.getChannel().sendMessageEmbeds(embed3.getNative().build(), new MessageEmbed[0]).content(content4).queue();
                    return;
                }
                PrivateChannel privateChannel = event.getChannel();
                String string16 = content4;
                if (string16 == null) {
                    StringBuilder stringBuilder = new StringBuilder().append("Your account is already linked to **");
                    OfflinePlayer offlinePlayer = player;
                    Intrinsics.checkNotNullExpressionValue(offlinePlayer, "player");
                    string16 = stringBuilder.append(offlinePlayer.getName()).append("** (").append(player.getUniqueId()).append(").").toString();
                }
                privateChannel.sendMessage(string16).queue();
                return;
            }
            DiscordEmbed embed4 = DiscordUtilsKt.getYMLEmbed$default(this.main, new DiscordEmbed(new EmbedBuilder(), null), "accountLinkUnknown", new Function1<String, String>(event){
                final /* synthetic */ PrivateMessageReceivedEvent $event;

                @NotNull
                public final String invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    User user = this.$event.getAuthor();
                    Intrinsics.checkNotNullExpressionValue(user, "event.author");
                    return DiscordUtilsKt.setDiscordPlaceholders(new DiscordUser(user), it);
                }
                {
                    this.$event = privateMessageReceivedEvent;
                    super(1);
                }
            }, null, false, 48, null);
            if (embed4.getContent() != null) {
                User user8 = event.getAuthor();
                Intrinsics.checkNotNullExpressionValue(user8, "event.author");
                DiscordUser discordUser = new DiscordUser(user8);
                String string17 = embed4.getContent();
                Intrinsics.checkNotNull(string17);
                String string18 = DiscordUtilsKt.setDiscordPlaceholders(discordUser, string17);
                boolean bl = false;
                boolean bl6 = false;
                String it = string18;
                boolean bl7 = false;
                embed4.setContent(it);
                string2 = string18;
            } else {
                string2 = content2 = null;
            }
            if (!embed4.isEmpty()) {
                event.getChannel().sendMessageEmbeds(embed4.getNative().build(), new MessageEmbed[0]).content(content2).queue();
                return;
            }
            PrivateChannel privateChannel = event.getChannel();
            String string19 = content2;
            if (string19 == null) {
                string19 = "I don't know of such code, try again.";
            }
            privateChannel.sendMessage(string19).queue();
            return;
        }
        DiscordEmbed embed5 = DiscordUtilsKt.getYMLEmbed$default(this.main, new DiscordEmbed(new EmbedBuilder(), null), "accountLinkInvalid", new Function1<String, String>(event){
            final /* synthetic */ PrivateMessageReceivedEvent $event;

            @NotNull
            public final String invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                User user = this.$event.getAuthor();
                Intrinsics.checkNotNullExpressionValue(user, "event.author");
                return DiscordUtilsKt.setDiscordPlaceholders(new DiscordUser(user), it);
            }
            {
                this.$event = privateMessageReceivedEvent;
                super(1);
            }
        }, null, false, 48, null);
        if (embed5.getContent() != null) {
            User user9 = event.getAuthor();
            Intrinsics.checkNotNullExpressionValue(user9, "event.author");
            DiscordUser discordUser = new DiscordUser(user9);
            String string20 = embed5.getContent();
            Intrinsics.checkNotNull(string20);
            String string21 = DiscordUtilsKt.setDiscordPlaceholders(discordUser, string20);
            boolean bl = false;
            boolean bl8 = false;
            String it = string21;
            boolean bl9 = false;
            embed5.setContent(it);
            string = string21;
        } else {
            string = content = null;
        }
        if (!embed5.isEmpty()) {
            event.getChannel().sendMessageEmbeds(embed5.getNative().build(), new MessageEmbed[0]).content(content).queue();
            return;
        }
        PrivateChannel privateChannel = event.getChannel();
        String string22 = content;
        if (string22 == null) {
            string22 = "Are you sure this is a code? A code only contains 4 characters and numbers.";
        }
        privateChannel.sendMessage(string22).queue();
    }

    @NotNull
    public final DiscordEconomyBridge getMain() {
        return this.main;
    }

    public Listener(@NotNull DiscordEconomyBridge main, @NotNull Server server) {
        Intrinsics.checkNotNullParameter((Object)main, "main");
        Intrinsics.checkNotNullParameter(server, "server");
        this.main = main;
        this.logger = server.getLogger();
    }
}

