/*
 * Decompiled with CFR 0.152.
 */
package me.pliexe.discordeconomybridge.discord;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0006J\u0016\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lme/pliexe/discordeconomybridge/discord/CooldownManager;", "", "()V", "cooldowns", "", "", "", "Add", "", "command", "userId", "cooldown", "Remove", "getCooldown", "commandName", "isOnCooldown", "", "key", "DiscordEconomyBridge"})
public final class CooldownManager {
    private final Map<String, Long> cooldowns;

    public final boolean isOnCooldown(@NotNull String key) {
        boolean bl;
        Intrinsics.checkNotNullParameter(key, "key");
        if (this.cooldowns.containsKey(key)) {
            Long l = this.cooldowns.get(key);
            Intrinsics.checkNotNull(l);
            long cooldown = ((Number)l).longValue();
            if (System.currentTimeMillis() > cooldown) {
                this.cooldowns.remove(key);
                bl = false;
            } else {
                bl = true;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public final void Add(@NotNull String command, @NotNull String userId, long cooldown) {
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(userId, "userId");
        this.cooldowns.put(command + userId, System.currentTimeMillis() + cooldown);
    }

    public final void Remove(@NotNull String command, @NotNull String userId) {
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(userId, "userId");
        this.cooldowns.remove(command + userId);
    }

    @NotNull
    public final String getCooldown(@NotNull String commandName, @NotNull String userId) {
        Intrinsics.checkNotNullParameter(commandName, "commandName");
        Intrinsics.checkNotNullParameter(userId, "userId");
        Long l = this.cooldowns.get(commandName + userId);
        Intrinsics.checkNotNull(l);
        long cooldown = ((Number)l).longValue();
        long ms = cooldown - System.currentTimeMillis();
        long seconds = ms / (long)1000 % (long)60;
        long minutes = ms / (long)60000 % (long)60;
        long hours = ms / (long)3600000 % (long)24;
        long days = ms / (long)86400000;
        StringBuilder str = new StringBuilder();
        if (days > 0L) {
            str.append(days + " days, ");
        }
        if (hours > 0L || days > 0L) {
            str.append(hours + " hours, ");
        }
        if (minutes > 0L || hours > 0L || days > 0L) {
            str.append(minutes + " minutes, ");
        }
        str.append(seconds + " seconds");
        String string = str.toString();
        Intrinsics.checkNotNullExpressionValue(string, "str.toString()");
        return string;
    }

    public CooldownManager() {
        boolean bl = false;
        this.cooldowns = new LinkedHashMap();
    }
}

