/*
 * Decompiled with CFR 0.152.
 */
package me.pliexe.discordeconomybridge.checkers;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.pliexe.discordeconomybridge.DiscordEconomyBridge;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"checkForUpdates", "", "version", "", "DiscordEconomyBridge"})
public final class CheckForUpdatesKt {
    public static final void checkForUpdates(@NotNull String version) {
        URLConnection con;
        Intrinsics.checkNotNullParameter(version, "version");
        URL api = new URL("https://api.github.com/repos/Pliexe/DiscordEconomyBridge/releases/latest");
        URLConnection uRLConnection = con = api.openConnection();
        Intrinsics.checkNotNullExpressionValue(uRLConnection, "con");
        uRLConnection.setConnectTimeout(15000);
        con.setReadTimeout(15000);
        String tagName = null;
        try {
            JsonObject json = new Gson().fromJson(CollectionsKt.joinToString$default(TextStreamsKt.readLines(new InputStreamReader(con.getInputStream())), null, null, null, 0, null, null, 63, null), JsonObject.class);
            JsonElement jsonElement = json.get("tag_name");
            Intrinsics.checkNotNullExpressionValue(jsonElement, "json.get(\"tag_name\")");
            String string = jsonElement.getAsString();
            Intrinsics.checkNotNullExpressionValue(string, "json.get(\"tag_name\").asString");
            tagName = StringsKt.replace$default(string, ".", "", false, 4, null);
        }
        catch (JsonParseException e) {
            DiscordEconomyBridge.Companion.getLogger().severe("Failed to check for updates. Code 1.");
            return;
        }
        catch (IOException e) {
            DiscordEconomyBridge.Companion.getLogger().severe("Failed to check for updates. Code 2.");
            e.printStackTrace();
            return;
        }
        catch (ClassCastException e) {
            DiscordEconomyBridge.Companion.getLogger().severe("Failed to check for updates. Code 3.");
            e.printStackTrace();
            return;
        }
        try {
            String string = tagName;
            int n = 1;
            int n2 = tagName.length();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = string3;
            n = 0;
            int latestVersion = Integer.parseInt(string);
            string = StringsKt.replace$default(version, ".", "", false, 4, null);
            n = 0;
            if (latestVersion > Integer.parseInt(string)) {
                DiscordEconomyBridge.Companion.getLogger().info("The plugin is out of date. A new version is available: " + tagName);
                DiscordEconomyBridge.Companion.getLogger().info("https://www.spigotmc.org/resources/discord-economy-bridge-1-7-1-18-slashcommands-minigames-in-discord-supports-discordsrv.90290/");
            } else {
                DiscordEconomyBridge.Companion.getLogger().info("DiscordEconomyBridge is up to date!");
            }
        }
        catch (NumberFormatException e) {
            DiscordEconomyBridge.Companion.getLogger().severe("Failed to check for updates. Code 4.");
            return;
        }
    }
}

