/*
 * Decompiled with CFR 0.152.
 */
package me.pliexe.discordeconomybridge;

import de.leonhard.storage.Config;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.pliexe.discordeconomybridge.DiscordEconomyBridge;
import me.pliexe.discordeconomybridge.discord.DiscordUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\t\u001a\u00020\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a\u000e\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\r\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0010\u0010\u0010\u001a\u00020\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a8\u0006\u0011"}, d2={"checkForConfigurations", "", "main", "Lme/pliexe/discordeconomybridge/DiscordEconomyBridge;", "checkForMessageConfig", "dMessageConfig", "Lde/leonhard/storage/Config;", "logger", "Ljava/util/logging/Logger;", "isConfigSection", "value", "", "tokenCheck", "validateEmbed", "path", "", "validateStringOrList", "DiscordEconomyBridge"})
public final class ConfigurationSafetyCheckKt {
    public static final boolean tokenCheck(@NotNull DiscordEconomyBridge main) {
        Intrinsics.checkNotNullParameter((Object)main, "main");
        Config defaultConfig = main.getDefaultConfig();
        Logger logger = main.getLogger();
        if (!defaultConfig.contains("TOKEN")) {
            logger.severe("TOKEN field missing from config.yml, disabling plugin...");
            return false;
        }
        if (DiscordUtilsKt.getString(defaultConfig.get("TOKEN")) == null) {
            logger.severe("TOKEN field is invalid type. It must be a text(string) in config.yml, disabling plugin...");
            return false;
        }
        return true;
    }

    public static final boolean checkForConfigurations(@NotNull DiscordEconomyBridge main) {
        Intrinsics.checkNotNullParameter((Object)main, "main");
        Logger logger = main.getLogger();
        Config config = main.getDiscordMessagesConfig();
        Logger logger2 = logger;
        Intrinsics.checkNotNullExpressionValue(logger2, "logger");
        return ConfigurationSafetyCheckKt.checkForMessageConfig(config, logger2);
    }

    public static final boolean checkForMessageConfig(@NotNull Config dMessageConfig, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(dMessageConfig, "dMessageConfig");
        Intrinsics.checkNotNullParameter(logger, "logger");
        if (!dMessageConfig.contains("noPermissionMessage")) {
            logger.severe("noPermissionMessage is not set in discord_messages.yml");
            return false;
        }
        if (!ConfigurationSafetyCheckKt.validateEmbed(dMessageConfig, "noPermissionMessage")) {
            logger.severe("You don't have field, description or title set at noPermissionMessage.");
            return false;
        }
        if (!dMessageConfig.contains("failMessage")) {
            logger.severe("failMessage is not set in discord_messages.yml");
            return false;
        }
        if (!ConfigurationSafetyCheckKt.validateEmbed(dMessageConfig, "failMessage")) {
            logger.severe("You don't have field, description or title set at failMessage.");
            return false;
        }
        if (!dMessageConfig.contains("addmoneyCommandEmbed")) {
            logger.severe("addmoneyCommandEmbed is not set in discord_messages.yml");
            return false;
        }
        if (!ConfigurationSafetyCheckKt.validateEmbed(dMessageConfig, "addmoneyCommandEmbed")) {
            logger.severe("You don't have field, description or title set at addmoneyCommandEmbed.");
            return false;
        }
        if (!dMessageConfig.contains("removemoneyCommandEmbed")) {
            logger.severe("removemoneyCommandEmbed is not set in discord_messages.yml");
            return false;
        }
        if (!ConfigurationSafetyCheckKt.validateEmbed(dMessageConfig, "removemoneyCommandEmbed")) {
            logger.severe("You don't have field, description or title set at removemoneyCommandEmbed.");
            return false;
        }
        if (!dMessageConfig.contains("balanceCommandEmbed")) {
            logger.severe("balanceCommandEmbed is not set in discord_messages.yml");
            return false;
        }
        if (!ConfigurationSafetyCheckKt.validateEmbed(dMessageConfig, "balanceCommandEmbed")) {
            logger.severe("You don't have field, description or title set at balanceCommandEmbed.");
            return false;
        }
        if (!dMessageConfig.contains("helpCommandEmbed")) {
            logger.severe("helpCommandEmbed is not set in discord_messages.yml");
            return false;
        }
        if (!ConfigurationSafetyCheckKt.validateEmbed(dMessageConfig, "helpCommandEmbed")) {
            logger.severe("You don't have field, description or title set at helpCommandEmbed.");
            return false;
        }
        if (!dMessageConfig.contains("leaderboardCommandEmbed")) {
            logger.severe("leaderboardCommandEmbed is not set in discord_messages.yml");
            return false;
        }
        if (!(ConfigurationSafetyCheckKt.validateEmbed(dMessageConfig, "leaderboardCommandEmbed") || ConfigurationSafetyCheckKt.validateStringOrList(dMessageConfig.get("leaderboardCommandEmbed.descriptionRepeat")) || ConfigurationSafetyCheckKt.validateStringOrList(dMessageConfig.get("leaderboardCommandEmbed.fieldRepeatName")) && ConfigurationSafetyCheckKt.validateStringOrList(dMessageConfig.get("leaderboardCommandEmbed.fieldRepeatValue")))) {
            logger.severe("You don't have field, description or title set at leaderboardCommandEmbed.");
            return false;
        }
        if (!dMessageConfig.contains("coinflipCommandEmbed")) {
            logger.severe("coinflipCommandEmbed is not set in discord_messages.yml");
            return false;
        }
        if (!ConfigurationSafetyCheckKt.validateEmbed(dMessageConfig, "coinflipCommandEmbed")) {
            logger.severe("You don't have field, description or title set at coinflipCommandEmbed.");
            return false;
        }
        if (!dMessageConfig.contains("coinflipCommandConfirmEmbed")) {
            logger.severe("coinflipCommandConfirmEmbed is not set in discord_messages.yml");
            return false;
        }
        if (!ConfigurationSafetyCheckKt.validateEmbed(dMessageConfig, "coinflipCommandConfirmEmbed")) {
            logger.severe("You don't have field, description or title set at coinflipCommandConfirmEmbed.");
            return false;
        }
        if (!dMessageConfig.contains("coinflipCommandDeclineEmbed")) {
            logger.severe("coinflipCommandDeclineEmbed is not set in discord_messages.yml");
            return false;
        }
        if (!ConfigurationSafetyCheckKt.validateEmbed(dMessageConfig, "coinflipCommandDeclineEmbed")) {
            logger.severe("You don't have field, description or title set at coinflipCommandDeclineEmbed.");
            return false;
        }
        if (!dMessageConfig.contains("blackjackCommandShowEmbed")) {
            logger.severe("blackjackCommandShowEmbed is not set in discord_messages.yml");
            return false;
        }
        if (!ConfigurationSafetyCheckKt.validateEmbed(dMessageConfig, "blackjackCommandShowEmbed")) {
            logger.severe("You don't have field, description or title set at blackjackCommandShowEmbed.");
            return false;
        }
        if (!dMessageConfig.contains("blackjackCommandBlackjackOutcomePlayerEmbed")) {
            logger.severe("blackjackCommandBlackjackOutcomePlayerEmbed is not set in discord_messages.yml");
            return false;
        }
        if (!ConfigurationSafetyCheckKt.validateEmbed(dMessageConfig, "blackjackCommandBlackjackOutcomePlayerEmbed")) {
            logger.severe("You don't have field, description or title set at blackjackCommandBlackjackOutcomePlayerEmbed.");
            return false;
        }
        if (!dMessageConfig.contains("blackjackCommandBlackjackOutcomeDealerEmbed")) {
            logger.severe("blackjackCommandBlackjackOutcomeDealerEmbed is not set in discord_messages.yml");
            return false;
        }
        if (!ConfigurationSafetyCheckKt.validateEmbed(dMessageConfig, "blackjackCommandBlackjackOutcomeDealerEmbed")) {
            logger.severe("You don't have field, description or title set at blackjackCommandBlackjackOutcomeDealerEmbed.");
            return false;
        }
        if (!dMessageConfig.contains("blackjackCommandDrawOutcomeEmbed")) {
            logger.severe("blackjackCommandDrawOutcomeEmbed is not set in discord_messages.yml");
            return false;
        }
        if (!ConfigurationSafetyCheckKt.validateEmbed(dMessageConfig, "blackjackCommandDrawOutcomeEmbed")) {
            logger.severe("You don't have field, description or title set at blackjackCommandDrawOutcomeEmbed.");
            return false;
        }
        if (!dMessageConfig.contains("blackjackCommandDrawBlackjackOutcomeEmbed")) {
            logger.severe("blackjackCommandDrawBlackjackOutcomeEmbed is not set in discord_messages.yml");
            return false;
        }
        if (!ConfigurationSafetyCheckKt.validateEmbed(dMessageConfig, "blackjackCommandDrawBlackjackOutcomeEmbed")) {
            logger.severe("You don't have field, description or title set at blackjackCommandDrawBlackjackOutcomeEmbed.");
            return false;
        }
        if (!dMessageConfig.contains("blackjackCommandBustPlayerEmbed")) {
            logger.severe("blackjackCommandBustPlayerEmbed is not set in discord_messages.yml");
            return false;
        }
        if (!ConfigurationSafetyCheckKt.validateEmbed(dMessageConfig, "blackjackCommandBustPlayerEmbed")) {
            logger.severe("You don't have field, description or title set at blackjackCommandBustPlayerEmbed.");
            return false;
        }
        if (!dMessageConfig.contains("blackjackCommandBustDealerEmbed")) {
            logger.severe("blackjackCommandBustDealerEmbed is not set in discord_messages.yml");
            return false;
        }
        if (!ConfigurationSafetyCheckKt.validateEmbed(dMessageConfig, "blackjackCommandBustDealerEmbed")) {
            logger.severe("You don't have field, description or title set at blackjackCommandBustDealerEmbed.");
            return false;
        }
        if (!dMessageConfig.contains("blackjackCommandPlayerWinEmbed")) {
            logger.severe("blackjackCommandPlayerWinEmbed is not set in discord_messages.yml");
            return false;
        }
        if (!ConfigurationSafetyCheckKt.validateEmbed(dMessageConfig, "blackjackCommandPlayerWinEmbed")) {
            logger.severe("You don't have field, description or title set at blackjackCommandPlayerWinEmbed.");
            return false;
        }
        if (!dMessageConfig.contains("rpsCommand.messages.challenge")) {
            logger.severe("rpsCommand.messages.challenge is not set in discord_messages.yml");
            return false;
        }
        if (!ConfigurationSafetyCheckKt.validateEmbed(dMessageConfig, "rpsCommand.messages.challenge")) {
            logger.severe("You don't have field, description or title set at rpsCommand.messages.challenge.");
            return false;
        }
        if (!dMessageConfig.contains("rpsCommand.messages.declined")) {
            logger.severe("rpsCommand.messages.challenge is not set in discord_messages.yml");
            return false;
        }
        if (!ConfigurationSafetyCheckKt.validateEmbed(dMessageConfig, "rpsCommand.messages.challenge")) {
            logger.severe("You don't have field, description or title set at rpsCommand.messages.challenge.");
            return false;
        }
        if (!dMessageConfig.contains("rpsCommand.messages.game")) {
            logger.severe("rpsCommand.messages.challenge is not set in discord_messages.yml");
            return false;
        }
        if (!ConfigurationSafetyCheckKt.validateEmbed(dMessageConfig, "rpsCommand.messages.challenge")) {
            logger.severe("You don't have field, description or title set at rpsCommand.messages.challenge.");
            return false;
        }
        if (!dMessageConfig.contains("rpsCommand.messages.gameBot")) {
            logger.severe("rpsCommand.messages.challenge is not set in discord_messages.yml");
            return false;
        }
        if (!ConfigurationSafetyCheckKt.validateEmbed(dMessageConfig, "rpsCommand.messages.challenge")) {
            logger.severe("You don't have field, description or title set at rpsCommand.messages.challenge.");
            return false;
        }
        if (!dMessageConfig.contains("rpsCommand.messages.gameOver")) {
            logger.severe("rpsCommand.messages.challenge is not set in discord_messages.yml");
            return false;
        }
        if (!ConfigurationSafetyCheckKt.validateEmbed(dMessageConfig, "rpsCommand.messages.challenge")) {
            logger.severe("You don't have field, description or title set at rpsCommand.messages.challenge.");
            return false;
        }
        if (!dMessageConfig.contains("rpsCommand.messages.draw")) {
            logger.severe("rpsCommand.messages.challenge is not set in discord_messages.yml");
            return false;
        }
        if (!ConfigurationSafetyCheckKt.validateEmbed(dMessageConfig, "rpsCommand.messages.challenge")) {
            logger.severe("You don't have field, description or title set at rpsCommand.messages.challenge.");
            return false;
        }
        if (!dMessageConfig.contains("rpsCommand.messages.gameOverBotPlayerWin")) {
            logger.severe("rpsCommand.messages.challenge is not set in discord_messages.yml");
            return false;
        }
        if (!ConfigurationSafetyCheckKt.validateEmbed(dMessageConfig, "rpsCommand.messages.challenge")) {
            logger.severe("You don't have field, description or title set at rpsCommand.messages.challenge.");
            return false;
        }
        if (!dMessageConfig.contains("rpsCommand.messages.gameOverBotPlayerLose")) {
            logger.severe("rpsCommand.messages.challenge is not set in discord_messages.yml");
            return false;
        }
        if (!ConfigurationSafetyCheckKt.validateEmbed(dMessageConfig, "rpsCommand.messages.challenge")) {
            logger.severe("You don't have field, description or title set at rpsCommand.messages.challenge.");
            return false;
        }
        if (!dMessageConfig.contains("rpsCommand.messages.drawBot")) {
            logger.severe("rpsCommand.messages.challenge is not set in discord_messages.yml");
            return false;
        }
        if (!ConfigurationSafetyCheckKt.validateEmbed(dMessageConfig, "rpsCommand.messages.challenge")) {
            logger.severe("You don't have field, description or title set at rpsCommand.messages.challenge.");
            return false;
        }
        return true;
    }

    public static final boolean validateStringOrList(@Nullable Object value) {
        Object object = value;
        return object instanceof String ? true : object instanceof List;
    }

    public static final boolean isConfigSection(@Nullable Object value) {
        return value instanceof LinkedHashMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean validateEmbed(@NotNull Config dMessageConfig, @NotNull String path) {
        Intrinsics.checkNotNullParameter(dMessageConfig, "dMessageConfig");
        Intrinsics.checkNotNullParameter(path, "path");
        if (ConfigurationSafetyCheckKt.validateStringOrList(dMessageConfig.get(path + ".description"))) return true;
        if (ConfigurationSafetyCheckKt.validateStringOrList(dMessageConfig.get(path + ".title"))) return true;
        if (!ConfigurationSafetyCheckKt.isConfigSection(dMessageConfig.get(path + ".fields"))) return false;
        Set<String> set = dMessageConfig.singleLayerKeySet(path + ".fields");
        Intrinsics.checkNotNullExpressionValue(set, "dMessageConfig.singleLayerKeySet(\"$path.fields\")");
        Collection collection = set;
        boolean bl = false;
        if (collection.isEmpty()) return false;
        return true;
    }
}

