/*
 * Decompiled with CFR 0.152.
 */
package de.leonhard.storage.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class YamlUtils {
    public static List<String> getCommentsFromLines(List<String> lines) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : lines) {
            if (!line.startsWith("#")) continue;
            result.add(line);
        }
        return result;
    }

    public static List<String> getFooterFromLines(List<String> lines) {
        ArrayList<String> result = new ArrayList<String>();
        Collections.reverse(lines);
        for (String line : lines) {
            if (!line.startsWith("#")) {
                Collections.reverse(result);
                return result;
            }
            result.add(line);
        }
        Collections.reverse(result);
        return result;
    }

    public static List<String> getHeaderFromLines(List<String> lines) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : lines) {
            if (!line.startsWith("#")) {
                return result;
            }
            result.add(line);
        }
        return result;
    }

    public static List<String> getPureCommentsFromLines(List<String> lines) {
        List<String> comments = YamlUtils.getCommentsFromLines(lines);
        List<String> header = YamlUtils.getHeaderFromLines(lines);
        List<String> footer = YamlUtils.getFooterFromLines(lines);
        comments.removeAll(header);
        comments.removeAll(footer);
        return comments;
    }

    public static List<String> getLinesWithoutFooterAndHeaderFromLines(List<String> lines) {
        List<String> header = YamlUtils.getHeaderFromLines(lines);
        List<String> footer = YamlUtils.getFooterFromLines(lines);
        lines.removeAll(header);
        lines.removeAll(footer);
        return lines;
    }

    public static List<String> getKeys(List<String> lines) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : lines) {
            if (line.trim().startsWith("#")) continue;
            result.add(line);
        }
        return result;
    }

    private YamlUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

