/*
 * Decompiled with CFR 0.152.
 */
package de.leonhard.storage.internal.provider;

import de.leonhard.storage.internal.provider.ExceptionHandler;
import de.leonhard.storage.internal.provider.InputStreamProvider;
import de.leonhard.storage.internal.provider.MapProvider;
import de.leonhard.storage.shaded.esotericsoftware.yamlbeans.YamlConfig;

public final class LightningProviders {
    private static MapProvider mapProvider;
    private static YamlConfig yamlConfig;
    private static InputStreamProvider inputStreamProvider;
    private static ExceptionHandler exceptionHandler;

    public static MapProvider mapProvider() {
        if (mapProvider == null) {
            mapProvider = new MapProvider(){};
        }
        return mapProvider;
    }

    public static YamlConfig yamlConfig() {
        if (yamlConfig == null) {
            YamlConfig config = new YamlConfig();
            config.writeConfig.setEscapeUnicode(false);
            config.writeConfig.setAutoAnchor(false);
            config.writeConfig.setWriteClassname(YamlConfig.WriteClassName.NEVER);
            yamlConfig = config;
        }
        return yamlConfig;
    }

    public static InputStreamProvider inputStreamProvider() {
        if (inputStreamProvider == null) {
            inputStreamProvider = new InputStreamProvider(){};
        }
        return inputStreamProvider;
    }

    public static ExceptionHandler exceptionHandler() {
        if (exceptionHandler == null) {
            exceptionHandler = new ExceptionHandler(){};
        }
        return exceptionHandler;
    }

    private LightningProviders() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static void mapProvider(MapProvider mapProvider) {
        LightningProviders.mapProvider = mapProvider;
    }

    public static void yamlConfig(YamlConfig yamlConfig) {
        LightningProviders.yamlConfig = yamlConfig;
    }

    public static void inputStreamProvider(InputStreamProvider inputStreamProvider) {
        LightningProviders.inputStreamProvider = inputStreamProvider;
    }

    public static void exceptionHandler(ExceptionHandler exceptionHandler) {
        LightningProviders.exceptionHandler = exceptionHandler;
    }
}

