/*
 * Decompiled with CFR 0.152.
 */
package de.leonhard.storage.internal;

import de.leonhard.storage.internal.settings.DataType;
import de.leonhard.storage.shaded.jetbrains.annotations.NotNull;
import de.leonhard.storage.shaded.json.JSONObject;
import de.leonhard.storage.util.JsonUtils;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FileData {
    private final Map<String, Object> localMap;

    public FileData(Map<String, Object> map, DataType dataType) {
        this.localMap = dataType.getMapImplementation();
        this.localMap.putAll(map);
    }

    public FileData(JSONObject jsonObject) {
        this.localMap = new HashMap<String, Object>(jsonObject.toMap());
    }

    public FileData(JSONObject jsonObject, DataType dataType) {
        this.localMap = dataType.getMapImplementation();
        this.localMap.putAll(jsonObject.toMap());
    }

    public void clear() {
        this.localMap.clear();
    }

    public void loadData(Map<String, Object> map) {
        this.clear();
        if (map != null) {
            this.localMap.putAll(map);
        }
    }

    public Object get(String key) {
        String[] parts = key.split("\\.");
        return this.get(this.localMap, parts, 0);
    }

    private Object get(Map<String, Object> map, String[] key, int id) {
        if (id < key.length - 1) {
            if (map.get(key[id]) instanceof Map) {
                Map tempMap = (Map)map.get(key[id]);
                return this.get(tempMap, key, id + 1);
            }
            return null;
        }
        return map.get(key[id]);
    }

    public synchronized void insert(String key, Object value) {
        String[] parts = key.split("\\.");
        this.localMap.put(parts[0], this.localMap.containsKey(parts[0]) && this.localMap.get(parts[0]) instanceof Map ? this.insert((Map)this.localMap.get(parts[0]), parts, value, 1) : this.insert(new HashMap<String, Object>(), parts, value, 1));
    }

    private Object insert(Map<String, Object> map, String[] key, Object value, int id) {
        if (id < key.length) {
            HashMap<String, Object> tempMap = new HashMap<String, Object>(map);
            HashMap<String, Object> childMap = map.containsKey(key[id]) && map.get(key[id]) instanceof Map ? (Map)map.get(key[id]) : new HashMap<String, Object>();
            tempMap.put(key[id], this.insert(childMap, key, value, id + 1));
            return tempMap;
        }
        return value;
    }

    public boolean containsKey(String key) {
        String[] parts = key.split("\\.");
        return this.containsKey(this.localMap, parts, 0);
    }

    private boolean containsKey(Map<String, Object> map, String[] key, int id) {
        if (id < key.length - 1) {
            if (map.containsKey(key[id]) && map.get(key[id]) instanceof Map) {
                Map tempMap = (Map)map.get(key[id]);
                return this.containsKey(tempMap, key, id + 1);
            }
            return false;
        }
        return map.containsKey(key[id]);
    }

    public synchronized void remove(String key) {
        if (this.containsKey(key)) {
            String[] parts = key.split("\\.");
            this.remove(parts);
        }
    }

    private void remove(@NotNull String[] key) {
        if (key.length == 1) {
            this.localMap.remove(key[0]);
        } else {
            Object tempValue = this.localMap.get(key[0]);
            if (tempValue instanceof Map) {
                this.localMap.put(key[0], this.remove((Map)tempValue, key, 1));
                if (((Map)this.localMap.get(key[0])).isEmpty()) {
                    this.localMap.remove(key[0]);
                }
            }
        }
    }

    private Map<String, Object> remove(Map<String, Object> map, String[] key, int keyIndex) {
        if (keyIndex < key.length - 1) {
            Object tempValue = map.get(key[keyIndex]);
            if (tempValue instanceof Map) {
                map.put(key[keyIndex], this.remove((Map)tempValue, key, keyIndex + 1));
                if (((Map)map.get(key[keyIndex])).isEmpty()) {
                    map.remove(key[keyIndex]);
                }
            }
        } else {
            map.remove(key[keyIndex]);
        }
        return map;
    }

    public Set<String> singleLayerKeySet() {
        return this.localMap.keySet();
    }

    public Set<String> singleLayerKeySet(String key) {
        return this.get(key) instanceof Map ? ((Map)this.get(key)).keySet() : new HashSet<String>();
    }

    public Set<String> keySet() {
        return this.multiLayerKeySet(this.localMap);
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.multiLayerEntrySet(this.localMap);
    }

    public Set<Map.Entry<String, Object>> singleLayerEntrySet() {
        return this.localMap.entrySet();
    }

    public Set<String> keySet(String key) {
        return this.get(key) instanceof Map ? this.multiLayerKeySet((Map)this.get(key)) : new HashSet<String>();
    }

    private Set<String> multiLayerKeySet(Map<String, Object> map) {
        HashSet<String> out = new HashSet<String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                for (String tempKey : this.multiLayerKeySet((Map)entry.getValue())) {
                    out.add(entry.getKey() + "." + tempKey);
                }
                continue;
            }
            out.add(entry.getKey());
        }
        return out;
    }

    private Set<Map.Entry<String, Object>> multiLayerEntrySet(Map<String, Object> map) {
        HashSet<Map.Entry<String, Object>> out = new HashSet<Map.Entry<String, Object>>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (map.get(entry.getKey()) instanceof Map) {
                for (String tempKey : this.multiLayerKeySet((Map)map.get(entry.getKey()))) {
                    out.add(new AbstractMap.SimpleEntry<String, Object>(entry.getKey() + "." + tempKey, entry.getValue()));
                }
                continue;
            }
            out.add(entry);
        }
        return out;
    }

    public int singleLayerSize() {
        return this.localMap.size();
    }

    public int singleLayerSize(String key) {
        return this.get(key) instanceof Map ? ((Map)this.get(key)).size() : 0;
    }

    public int size() {
        return this.localMap.size();
    }

    public int size(String key) {
        return this.localMap.size();
    }

    public void putAll(Map<String, Object> map) {
        this.localMap.putAll(map);
    }

    private int size(Map<String, Object> map) {
        int size = map.size();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!(entry.getValue() instanceof Map)) continue;
            size += this.size((Map)entry.getValue());
        }
        return size;
    }

    public Map<String, Object> toMap() {
        if (this.localMap != null) {
            return this.localMap;
        }
        return new HashMap<String, Object>();
    }

    public JSONObject toJsonObject() {
        return JsonUtils.getJsonFromMap(this.localMap);
    }

    public int hashCode() {
        return this.localMap.hashCode();
    }

    public String toString() {
        return this.localMap.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FileData fileData = (FileData)obj;
        return this.localMap.equals(fileData.localMap);
    }
}

