/*
 * Decompiled with CFR 0.152.
 */
package de.leonhard.storage;

import de.leonhard.storage.internal.FileData;
import de.leonhard.storage.internal.FileType;
import de.leonhard.storage.internal.FlatFile;
import de.leonhard.storage.internal.editor.toml.TomlManager;
import de.leonhard.storage.internal.settings.ReloadSettings;
import de.leonhard.storage.shaded.jetbrains.annotations.Nullable;
import de.leonhard.storage.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.function.Consumer;
import lombok.NonNull;

public class Toml
extends FlatFile {
    public Toml(@NonNull Toml toml) {
        super(toml.getFile());
        if (toml == null) {
            throw new NullPointerException("toml is marked non-null but is null");
        }
        this.fileData = toml.getFileData();
        this.pathPrefix = toml.getPathPrefix();
    }

    public Toml(String name, String path) {
        this(name, path, null);
    }

    public Toml(String name, String path, InputStream inputStream) {
        this(name, path, inputStream, null, null);
    }

    public Toml(@NonNull String name, @NonNull String path, @Nullable InputStream inputStream, @Nullable ReloadSettings reloadSettings, @Nullable Consumer<FlatFile> reloadConsumer) {
        super(name, path, FileType.TOML, reloadConsumer);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (this.create() && inputStream != null) {
            FileUtils.writeToFile(this.file, inputStream);
        }
        if (reloadSettings != null) {
            this.reloadSettings = reloadSettings;
        }
        this.forceReload();
    }

    public Toml(File file) {
        super(file, FileType.TOML);
        this.create();
        this.forceReload();
    }

    @Override
    protected final Map<String, Object> readToMap() throws IOException {
        return TomlManager.read(this.getFile());
    }

    @Override
    protected final void write(FileData data) {
        try {
            TomlManager.write(data.toMap(), this.getFile());
        }
        catch (IOException ioException) {
            System.err.println("Exception while writing fileData to file '" + this.getName() + "'");
            System.err.println("In '" + FileUtils.getParentDirPath(this.file) + "'");
            ioException.printStackTrace();
        }
    }
}

