/*
 * Decompiled with CFR 0.152.
 */
package de.leonhard.storage;

import de.leonhard.storage.Config;
import de.leonhard.storage.Json;
import de.leonhard.storage.Toml;
import de.leonhard.storage.Yaml;
import de.leonhard.storage.internal.FlatFile;
import de.leonhard.storage.internal.provider.InputStreamProvider;
import de.leonhard.storage.internal.provider.LightningProviders;
import de.leonhard.storage.internal.settings.ConfigSettings;
import de.leonhard.storage.internal.settings.DataType;
import de.leonhard.storage.internal.settings.ReloadSettings;
import de.leonhard.storage.shaded.jetbrains.annotations.Nullable;
import de.leonhard.storage.util.FileUtils;
import de.leonhard.storage.util.Valid;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.function.Consumer;
import lombok.NonNull;

public final class LightningBuilder {
    private final InputStreamProvider inputStreamProvider;
    private final String path;
    private String name;
    private InputStream inputStream;
    private ReloadSettings reloadSettings;
    private ConfigSettings configSettings;
    private DataType dataType;
    @Nullable
    private Consumer<FlatFile> reloadConsumer = null;

    private LightningBuilder(String name, String path, InputStreamProvider inputStreamProvider) {
        this.name = name;
        this.path = path;
        this.inputStreamProvider = inputStreamProvider;
    }

    public static LightningBuilder fromPath(@NonNull String name, @NonNull String path) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return new LightningBuilder(name, path, LightningProviders.inputStreamProvider());
    }

    public static LightningBuilder fromPath(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return LightningBuilder.fromFile(path.toFile());
    }

    public static LightningBuilder fromFile(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        Valid.checkBoolean(!file.isDirectory(), "File mustn't be a directory.", "Please use from Directory to use a directory", "This is due to Java-Internals");
        return new LightningBuilder(FileUtils.replaceExtensions(file.getName()), FileUtils.getParentDirPath(file), LightningProviders.inputStreamProvider());
    }

    public static LightningBuilder fromDirectory(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        Valid.checkBoolean(!file.getName().contains("."), "File-Name mustn't contain '.'");
        if (!file.exists()) {
            file.mkdirs();
        }
        return new LightningBuilder(file.getName(), file.getAbsolutePath(), LightningProviders.inputStreamProvider());
    }

    public LightningBuilder reloadCallback(@Nullable Consumer<FlatFile> reloadConsumer) {
        this.reloadConsumer = reloadConsumer;
        return this;
    }

    public LightningBuilder addInputStreamFromFile(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.inputStream = FileUtils.createInputStream(file);
        return this;
    }

    public LightningBuilder addInputStreamFromResource(@NonNull String resource) {
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        this.inputStream = this.inputStreamProvider.createInputStreamFromInnerResource(resource);
        Valid.notNull(this.inputStream, "InputStream is null.", "No inbuilt resource '" + resource + "' found: ");
        return this;
    }

    public LightningBuilder setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
        return this;
    }

    public LightningBuilder addInputStream(@Nullable InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public LightningBuilder setConfigSettings(@NonNull ConfigSettings configSettings) {
        if (configSettings == null) {
            throw new NullPointerException("configSettings is marked non-null but is null");
        }
        this.configSettings = configSettings;
        return this;
    }

    public LightningBuilder setReloadSettings(@NonNull ReloadSettings reloadSettings) {
        if (reloadSettings == null) {
            throw new NullPointerException("reloadSettings is marked non-null but is null");
        }
        this.reloadSettings = reloadSettings;
        return this;
    }

    public LightningBuilder setDataType(@NonNull DataType dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        this.dataType = dataType;
        return this;
    }

    public Config createConfig() {
        return new Config(this.name, this.path, this.inputStream, this.reloadSettings, this.configSettings, this.dataType, this.reloadConsumer);
    }

    public Yaml createYaml() {
        return new Yaml(this.name, this.path, this.inputStream, this.reloadSettings, this.configSettings, this.dataType, this.reloadConsumer);
    }

    public Toml createToml() {
        return new Toml(this.name, this.path, this.inputStream, this.reloadSettings, this.reloadConsumer);
    }

    public Json createJson() {
        return new Json(this.name, this.path, this.inputStream, this.reloadSettings, this.reloadConsumer);
    }
}

