/*
 * Decompiled with CFR 0.152.
 */
package de.maile.daniel.onewayelytra;

import de.maile.daniel.onewayelytra.NBTEditor;
import de.maile.daniel.onewayelytra.OneWayElytra;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Listeners
implements Listener {
    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPlayedBefore()) {
            player.getInventory().setChestplate(this.getElytra());
        }
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (OneWayElytra.INSTANCE.getConfig().getBoolean("elytra_on_respawn_if_no_bed") && !player.getWorld().isGameRule("KEEP_INVENTORY") && player.getBedSpawnLocation() == null) {
            player.getInventory().setChestplate(this.getElytra());
        }
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        int threshold = OneWayElytra.INSTANCE.getRemoveHeight();
        Player player = event.getPlayer();
        if (player.getLocation().getY() < (double)threshold) {
            ItemStack chestPlate = player.getInventory().getChestplate();
            if (player.isOnGround() && chestPlate != null && NBTEditor.hasKey(chestPlate, "one_way_elytra")) {
                player.getInventory().setChestplate(new ItemStack(Material.AIR));
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem != null && NBTEditor.hasKey(clickedItem, "one_way_elytra")) {
            event.setCancelled(true);
        }
    }

    private ItemStack getElytra() {
        ItemStack itemStack = new ItemStack(Material.ELYTRA);
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            String displayName = ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(OneWayElytra.INSTANCE.getConfig().getString("eyltra_name")));
            itemMeta.setDisplayName(displayName);
            itemMeta.setUnbreakable(true);
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
            itemStack.setItemMeta(itemMeta);
        }
        itemStack = NBTEditor.setString(itemStack, "one_way_elytra", "one_way_elytra");
        return itemStack;
    }
}

