/*
 * Decompiled with CFR 0.152.
 */
package com.rozza.mansave;

import com.rozza.mansave.Autocomplete;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;

public class Main
extends JavaPlugin
implements Listener {
    public static ArrayList<Player> hunters;
    public static boolean inGame;
    private int countdownTask;
    public static boolean huntersTakeDamage;
    public static boolean huntersHungerLoss;
    public static boolean suicidalHungerLoss;
    public static int countdownInSeconds;
    public static ItemStack[] hunterSlot;

    static {
        hunterSlot = new ItemStack[9];
    }

    public void onEnable() {
        this.saveDefaultConfig();
        huntersTakeDamage = this.getConfig().getBoolean("huntersTakeDamage");
        huntersHungerLoss = this.getConfig().getBoolean("huntersHungerLoss");
        suicidalHungerLoss = this.getConfig().getBoolean("suicidalHungerLoss");
        countdownInSeconds = this.getConfig().getInt("countdownInSeconds");
        Main.hunterSlot[0] = this.getConfig().getItemStack("hunterSlot0");
        Main.hunterSlot[1] = this.getConfig().getItemStack("hunterSlot1");
        Main.hunterSlot[2] = this.getConfig().getItemStack("hunterSlot2");
        Main.hunterSlot[3] = this.getConfig().getItemStack("hunterSlot3");
        Main.hunterSlot[4] = this.getConfig().getItemStack("hunterSlot4");
        Main.hunterSlot[5] = this.getConfig().getItemStack("hunterSlot5");
        Main.hunterSlot[6] = this.getConfig().getItemStack("hunterSlot6");
        Main.hunterSlot[7] = this.getConfig().getItemStack("hunterSlot7");
        Main.hunterSlot[8] = this.getConfig().getItemStack("hunterSlot8");
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("mansave").setTabCompleter((TabCompleter)new Autocomplete());
        hunters = new ArrayList();
        inGame = false;
    }

    public void onDisable() {
        this.getConfig().set("huntersTakeDamage", (Object)huntersTakeDamage);
        this.getConfig().set("huntersHungerLoss", (Object)huntersHungerLoss);
        this.getConfig().set("suicidalHungerLoss", (Object)suicidalHungerLoss);
        this.getConfig().set("countdownInSeconds", (Object)countdownInSeconds);
        this.getConfig().set("hunterSlot0", (Object)hunterSlot[0]);
        this.getConfig().set("hunterSlot1", (Object)hunterSlot[1]);
        this.getConfig().set("hunterSlot2", (Object)hunterSlot[2]);
        this.getConfig().set("hunterSlot3", (Object)hunterSlot[3]);
        this.getConfig().set("hunterSlot4", (Object)hunterSlot[4]);
        this.getConfig().set("hunterSlot5", (Object)hunterSlot[5]);
        this.getConfig().set("hunterSlot6", (Object)hunterSlot[6]);
        this.getConfig().set("hunterSlot7", (Object)hunterSlot[7]);
        this.getConfig().set("hunterSlot8", (Object)hunterSlot[8]);
        this.saveConfig();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String cmd = command.getName().toLowerCase();
        if (cmd.equals("mansave")) {
            if (args.length == 1) {
                if (args[0].equals("start")) {
                    if (inGame) {
                        sender.sendMessage(ChatColor.RED + "Game already started!");
                    } else {
                        this.startGame();
                    }
                    return true;
                }
                if (args[0].equals("stop")) {
                    if (!inGame) {
                        sender.sendMessage(ChatColor.RED + "Game hasn't started!");
                    } else {
                        this.stopGame("Game force stopped!");
                    }
                    return true;
                }
                if (args[0].contentEquals("setHunterItems")) {
                    Inventory inv = Bukkit.createInventory(null, (int)9, (String)"Choose hunter items:");
                    int i = 0;
                    while (i <= 8) {
                        if (hunterSlot[i] == null) {
                            Main.hunterSlot[i] = new ItemStack(Material.AIR, 1);
                        }
                        inv.addItem(new ItemStack[]{hunterSlot[i]});
                        ++i;
                    }
                    Player p = (Player)sender;
                    p.openInventory(inv);
                    p.sendMessage(ChatColor.BOLD + "Close inventory to save items!");
                    p.sendMessage(ChatColor.GRAY + "Use the creative inventory to get items, then place them in here.");
                    p.sendMessage(ChatColor.GRAY + "Use middle-mouse to stack any item (e.g. potions).");
                    return true;
                }
            } else if (args.length == 2) {
                if (args[0].equals("addHunter")) {
                    Player player = Bukkit.getPlayer((String)args[1]);
                    if (player == null) {
                        sender.sendMessage(ChatColor.RED + "Player not found.");
                        return false;
                    }
                    hunters.add(player);
                    sender.sendMessage(ChatColor.GREEN + player.getName() + " is now a hunter.");
                    return true;
                }
                if (args[0].equals("removeHunter")) {
                    Player player = Bukkit.getPlayer((String)args[1]);
                    if (player == null) {
                        sender.sendMessage(ChatColor.RED + "Player not found.");
                        return false;
                    }
                    hunters.remove(player);
                    sender.sendMessage(ChatColor.GREEN + player.getName() + " is no longer a hunter.");
                    return true;
                }
                if (args[0].equals("huntersTakeDamage")) {
                    huntersTakeDamage = Boolean.parseBoolean(args[1]);
                    if (huntersTakeDamage) {
                        sender.sendMessage(ChatColor.GREEN + "Hunters will now take damage.");
                    } else {
                        sender.sendMessage(ChatColor.GREEN + "Hunters will no longer take damage.");
                    }
                    return true;
                }
                if (args[0].equals("huntersHungerLoss")) {
                    huntersHungerLoss = Boolean.parseBoolean(args[1]);
                    if (huntersHungerLoss) {
                        sender.sendMessage(ChatColor.GREEN + "Hunters will now lose hunger.");
                    } else {
                        sender.sendMessage(ChatColor.GREEN + "Hunters will no longer lose hunger.");
                    }
                    return true;
                }
                if (args[0].equals("suicidalHungerLoss")) {
                    suicidalHungerLoss = Boolean.parseBoolean(args[1]);
                    if (suicidalHungerLoss) {
                        sender.sendMessage(ChatColor.GREEN + "The suicidal will now lose hunger, and be granted a stack of steak.");
                    } else {
                        sender.sendMessage(ChatColor.GREEN + "The suicidal will no longer lose hunger.");
                    }
                    return true;
                }
                if (args[0].equals("countdownInSeconds")) {
                    countdownInSeconds = Integer.parseInt(args[1]);
                    sender.sendMessage(ChatColor.GREEN + "Countdown has been set to " + countdownInSeconds + " seconds.");
                    return true;
                }
            }
        }
        sender.sendMessage(ChatColor.RED + "Invalid command.");
        return false;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (!e.getView().getTitle().equals("Choose hunter items:")) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        if (e.getClick() == ClickType.MIDDLE) {
            if (p.getItemOnCursor().getType() != Material.AIR) {
                return;
            }
            e.setCancelled(true);
            ItemStack i = e.getCurrentItem().clone();
            i.setAmount(64);
            p.setItemOnCursor(i);
        } else if (e.getClick() == ClickType.RIGHT) {
            ItemStack cur = p.getItemOnCursor();
            ItemStack cli = e.getCurrentItem();
            if (cur == null || cli == null) {
                return;
            }
            if (cur.getType() == Material.AIR || cli.getType() == Material.AIR) {
                return;
            }
            if (cur.getType() == cli.getType()) {
                if (cli.getAmount() == 64) {
                    return;
                }
                cli.setAmount(cli.getAmount() + 1);
                if (cur.getAmount() == 0) {
                    p.setItemOnCursor(null);
                } else {
                    cur.setAmount(cur.getAmount() - 1);
                }
            }
            e.setCancelled(true);
        } else if (e.getClick() == ClickType.LEFT) {
            ItemStack cur = p.getItemOnCursor();
            ItemStack cli = e.getCurrentItem();
            if (cli == null || cli.getType() == Material.AIR) {
                if (cur == null || cur.getType() == Material.AIR) {
                    return;
                }
                e.setCancelled(true);
                e.getClickedInventory().setItem(e.getSlot(), cur);
                p.setItemOnCursor(null);
            } else {
                if (cur == null || cur.getType() == Material.AIR) {
                    return;
                }
                if (cur.getType() == cli.getType()) {
                    e.setCancelled(true);
                    int total = cur.getAmount() + cli.getAmount();
                    if (total <= 64) {
                        cli.setAmount(total);
                        p.setItemOnCursor(null);
                    } else {
                        cli.setAmount(64);
                        cur.setAmount(total - 64);
                    }
                }
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent e) {
        InventoryView iv = e.getView();
        if (!iv.getTitle().equals("Choose hunter items:")) {
            return;
        }
        Inventory inv = iv.getTopInventory();
        int i = 0;
        while (i <= 8) {
            Main.hunterSlot[i] = inv.getItem(i);
            ++i;
        }
        e.getPlayer().sendMessage(ChatColor.GREEN + "Hunter items saved!");
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent e) {
        if (e.getEntityType() != EntityType.PLAYER) {
            return;
        }
        if (!inGame) {
            return;
        }
        Player p = e.getEntity();
        if (hunters.contains(p)) {
            e.setKeepInventory(true);
            e.setKeepLevel(true);
        } else {
            e.getDrops().clear();
            e.setDroppedExp(0);
            e.setDeathMessage(String.valueOf(e.getDeathMessage()) + " and won the game!");
            this.stopGame("Hunters lost the game!");
        }
    }

    public void startGame() {
        ScoreboardManager m = Bukkit.getScoreboardManager();
        Scoreboard b = m.getNewScoreboard();
        Objective o = b.registerNewObjective("timer", "", "Countdown");
        o.setDisplaySlot(DisplaySlot.SIDEBAR);
        final Score s = o.getScore("Time left");
        s.setScore(countdownInSeconds);
        this.countdownTask = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Main.getPlugin(Main.class), new Runnable(){

            @Override
            public void run() {
                int score = s.getScore() - 1;
                if (score == 0) {
                    Main.this.stopGame("Time up! Hunters win!");
                } else {
                    s.setScore(s.getScore() - 1);
                }
            }
        }, 20L, 20L);
        for (Player p : Bukkit.getOnlinePlayers()) {
            for (PotionEffect e : p.getActivePotionEffects()) {
                p.removePotionEffect(e.getType());
            }
            p.setFireTicks(0);
            p.setHealth(20.0);
            p.setFoodLevel(20);
            p.setTotalExperience(0);
            p.getInventory().clear();
            p.setScoreboard(b);
            p.sendMessage(ChatColor.GOLD + ChatColor.BOLD + "Game started! Good luck!");
            if (hunters.contains(p) || !suicidalHungerLoss) continue;
            p.getInventory().addItem(new ItemStack[]{new ItemStack(Material.COOKED_BEEF, 64)});
        }
        for (Player h : hunters) {
            this.giveHunterItems(h);
        }
        inGame = true;
    }

    public void stopGame(String msg) {
        Bukkit.getServer().getScheduler().cancelTask(this.countdownTask);
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.sendMessage(ChatColor.GOLD + ChatColor.BOLD + msg);
            p.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
            if (p.isDead()) continue;
            for (PotionEffect e : p.getActivePotionEffects()) {
                p.removePotionEffect(e.getType());
            }
            p.setFireTicks(0);
            p.setHealth(20.0);
            p.setFoodLevel(20);
            p.setTotalExperience(0);
            p.getInventory().clear();
        }
        inGame = false;
    }

    public void giveHunterItems(Player p) {
        PlayerInventory inv = p.getInventory();
        int i = 0;
        while (i <= 8) {
            inv.addItem(new ItemStack[]{hunterSlot[i]});
            ++i;
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent e) {
        if (!inGame) {
            return;
        }
        if (huntersTakeDamage) {
            return;
        }
        if (e.getEntityType() == EntityType.PLAYER && hunters.contains(e.getEntity())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onHungerDeplete(FoodLevelChangeEvent e) {
        if (!inGame) {
            e.setCancelled(true);
            return;
        }
        if (e.getEntityType() != EntityType.PLAYER) {
            return;
        }
        Player p = (Player)e.getEntity();
        if (!huntersHungerLoss && hunters.contains(p)) {
            e.setCancelled(true);
        } else if (!suicidalHungerLoss && !hunters.contains(p)) {
            e.setCancelled(true);
        }
    }
}

