/*
 * Decompiled with CFR 0.152.
 */
package net.cozycosmos.midensfoods.items;

import net.cozycosmos.midensfoods.Main;
import net.cozycosmos.midensfoods.util.CallCustomFoodEaten;
import net.cozycosmos.midensfoods.util.GenerateFoodItemstack;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.plugin.Plugin;

public class IdFoodCreator
implements Listener {
    private final Main plugin = (Main)Main.getPlugin(Main.class);
    FileConfiguration config = this.plugin.getConfig();

    public void ItemRecipe() {
        this.config = this.plugin.getConfig();
        this.config.getConfigurationSection("Recipes").getKeys(false).forEach(recipe -> {
            ItemStack foodItem = GenerateFoodItemstack.withID(recipe);
            if (this.config.getString("Recipes." + recipe + ".Type").equalsIgnoreCase("Furnace")) {
                FurnaceRecipe newFurnaceRecipe = new FurnaceRecipe(foodItem, Material.getMaterial((String)this.config.getString("Recipes." + recipe + ".Recipe.Ingredient")));
                newFurnaceRecipe.setExperience((float)this.config.getInt("Recipes." + recipe + ".Recipe.Experience"));
                newFurnaceRecipe.setCookingTime(this.config.getInt("Recipes." + recipe + ".Recipe.Cook-Time"));
                this.plugin.getServer().addRecipe((Recipe)newFurnaceRecipe);
            } else if (this.config.getString("Recipes." + recipe + ".Type").equalsIgnoreCase("Shaped")) {
                NamespacedKey Key = new NamespacedKey((Plugin)this.plugin, recipe);
                ShapedRecipe theRecipe = new ShapedRecipe(Key, foodItem);
                theRecipe.shape(new String[]{this.config.getString("Recipes." + recipe + ".Recipe.TableLine1"), this.config.getString("Recipes." + recipe + ".Recipe.TableLine2"), this.config.getString("Recipes." + recipe + ".Recipe.TableLine3")});
                this.config.getConfigurationSection("Recipes." + recipe + ".Recipe.LetterKeys").getKeys(false).forEach(Rletter -> {
                    Object ingr = this.checkCustomIngredient(this.config.getString("Recipes." + recipe + ".Recipe.LetterKeys." + Rletter)) ? new RecipeChoice.ExactChoice(GenerateFoodItemstack.withID(this.config.getString("Recipes." + recipe + ".Recipe.LetterKeys." + Rletter).substring(4))) : new RecipeChoice.MaterialChoice(Material.valueOf((String)this.config.getString("Recipes." + recipe + ".Recipe.LetterKeys." + Rletter)));
                    theRecipe.setIngredient(Rletter.charAt(0), (RecipeChoice)ingr);
                });
                this.plugin.getServer().addRecipe((Recipe)theRecipe);
            } else if (!this.config.getString("Recipes." + recipe + ".Type").equalsIgnoreCase("None")) {
                if (this.config.getString("Recipes." + recipe + ".Type").equalsIgnoreCase("Smoker")) {
                    NamespacedKey Key = new NamespacedKey((Plugin)this.plugin, recipe);
                    SmokingRecipe newSmokingRecipe = new SmokingRecipe(Key, foodItem, Material.getMaterial((String)this.config.getString("Recipes." + recipe + ".Recipe.Ingredient")), 0.0f, 0);
                    newSmokingRecipe.setExperience((float)this.config.getInt("Recipes." + recipe + ".Recipe.Experience"));
                    newSmokingRecipe.setCookingTime(this.config.getInt("Recipes." + recipe + ".Recipe.Cook-Time"));
                    this.plugin.getServer().addRecipe((Recipe)newSmokingRecipe);
                } else if (this.config.getString("Recipes." + recipe + ".Type").equalsIgnoreCase("Campfire")) {
                    NamespacedKey Key = new NamespacedKey((Plugin)this.plugin, recipe);
                    CampfireRecipe newCampRecipe = new CampfireRecipe(Key, foodItem, Material.getMaterial((String)this.config.getString("Recipes." + recipe + ".Recipe.Ingredient")), 0.0f, 0);
                    newCampRecipe.setExperience((float)this.config.getInt("Recipes." + recipe + ".Recipe.Experience"));
                    newCampRecipe.setCookingTime(this.config.getInt("Recipes." + recipe + ".Recipe.Cook-Time"));
                    this.plugin.getServer().addRecipe((Recipe)newCampRecipe);
                } else if (this.config.getString("Recipes." + recipe + ".Type").equalsIgnoreCase("Shapeless")) {
                    NamespacedKey Key = new NamespacedKey((Plugin)this.plugin, recipe);
                    ShapelessRecipe newShapelessRecipe = new ShapelessRecipe(Key, foodItem);
                    this.config.getConfigurationSection("Recipes." + recipe + ".Ingredients").getKeys(false).forEach(Ingredient -> {
                        Object ingr = this.checkCustomIngredient(this.config.getString("Recipes." + recipe + ".Ingredients." + Ingredient)) ? new RecipeChoice.ExactChoice(GenerateFoodItemstack.withID(Ingredient.substring(4))) : new RecipeChoice.MaterialChoice(Material.valueOf((String)Ingredient));
                        if (this.config.getInt("Recipes." + recipe + ".Ingredients." + Ingredient) == 1) {
                            newShapelessRecipe.addIngredient((RecipeChoice)ingr);
                        } else if (this.config.getInt("Recipes." + recipe + ".Ingredients." + Ingredient) > 1) {
                            for (int i = 1; i == this.config.getInt("Recipes." + recipe + ".Ingredients." + Ingredient); ++i) {
                                newShapelessRecipe.addIngredient((RecipeChoice)ingr);
                            }
                        }
                    });
                    this.plugin.getServer().addRecipe((Recipe)newShapelessRecipe);
                } else {
                    Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.RED + "Invalid Recipe Type At " + recipe + ". Make sure there are no typos!");
                }
            }
        });
    }

    @EventHandler
    public void foodEaten(FoodLevelChangeEvent event) {
        this.config = this.plugin.getConfig();
        Player p = (Player)event.getEntity();
        if (event.getEntity() instanceof Player && p.getFoodLevel() < event.getFoodLevel() && event.getItem().hasItemMeta() && event.getItem().getItemMeta().hasCustomModelData()) {
            this.config.getConfigurationSection("Recipes").getKeys(false).forEach(food -> {
                if (event.getItem().getItemMeta().getCustomModelData() == this.config.getInt("Recipes." + food + ".Id")) {
                    CallCustomFoodEaten.CallEvent(food, p);
                    return;
                }
            });
        }
    }

    public boolean checkCustomIngredient(String ingr) {
        if (ingr.length() <= 4) {
            return false;
        }
        String prefix = ingr.substring(0, 4);
        return prefix.equals("CFD-");
    }
}

