/*
 * Decompiled with CFR 0.152.
 */
package net.cozycosmos.midensfoods;

import java.io.File;
import net.cozycosmos.midensfoods.commands.Core;
import net.cozycosmos.midensfoods.commands.tabcompleters.CoreTabCompleter;
import net.cozycosmos.midensfoods.events.FoodEaten;
import net.cozycosmos.midensfoods.extras.Metrics;
import net.cozycosmos.midensfoods.extras.UpdateChecker;
import net.cozycosmos.midensfoods.items.IdFoodCreator;
import net.cozycosmos.midensfoods.items.LegacyFoodCreator;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Consumer;

public class Main
extends JavaPlugin {
    public JavaPlugin instance;
    public PluginManager pm;
    public ConsoleCommandSender cs;
    File foodvaluesYml = new File(this.getDataFolder() + "/foodvalues.yml");
    File satvaluesYml = new File(this.getDataFolder() + "/satvalues.yml");
    File messagesYml = new File(this.getDataFolder() + "/messages.yml");

    public void onEnable() {
        this.instance = this;
        this.pm = Bukkit.getServer().getPluginManager();
        this.cs = Bukkit.getServer().getConsoleSender();
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
            this.cs.sendMessage(ChatColor.GRAY + "[MidensFoods] " + ChatColor.GREEN + "If this is your first time using the plugin, you may have to reload the plugin to get it to work properly! (/cf reload)");
        }
        int pluginId = 12329;
        Metrics metrics = new Metrics(this, pluginId);
        new UpdateChecker(this, 88653).getVersion((Consumer<String>)((Consumer)version -> {
            if (this.getDescription().getVersion().equalsIgnoreCase((String)version)) {
                this.cs.sendMessage(ChatColor.GRAY + "[MidensFoods] " + ChatColor.GREEN + "You're running the latest version!");
            } else {
                this.cs.sendMessage(ChatColor.GRAY + "[MidensFoods] " + ChatColor.GREEN + "There's a new update available!");
                this.cs.sendMessage(ChatColor.GRAY + "[MidensFoods] " + ChatColor.GREEN + "You're running version " + this.getDescription().getVersion() + " While the latest version is " + version + "!");
            }
        }));
        if (!this.foodvaluesYml.exists()) {
            this.saveResource("foodvalues.yml", false);
        }
        if (!this.satvaluesYml.exists()) {
            this.saveResource("satvalues.yml", false);
        }
        if (!this.messagesYml.exists()) {
            this.saveResource("messages.yml", false);
        }
        ItemStack recipeItemstack = new ItemStack(Material.REDSTONE);
        this.getConfig().options().copyDefaults();
        this.saveDefaultConfig();
        this.reloadConfig();
        this.registerRecipes();
        this.registerEvents();
        this.registerCommands();
        this.cs.sendMessage(ChatColor.GRAY + "[MidensFoods] " + ChatColor.GREEN + "Miden's Foods Enabled");
        this.cs.sendMessage(ChatColor.GRAY + "[MidensFoods] " + ChatColor.GREEN + "This plugin is still in Beta! Expect Bugs!");
    }

    public void onDisable() {
        this.unloadRecipes();
        this.cs.sendMessage(ChatColor.GRAY + "[MidensFoods] " + ChatColor.RED + "Miden's Foods Disabled");
    }

    public void registerEvents() {
        PluginManager pm = this.getServer().getPluginManager();
        if (this.getConfig().getBoolean("LegacySystem") || Bukkit.getVersion().contains("1.13")) {
            pm.registerEvents((Listener)new LegacyFoodCreator(), (Plugin)this);
            this.cs.sendMessage(ChatColor.GRAY + "[MidensFoods] " + ChatColor.GREEN + "Legacy food system enabled!");
            this.cs.sendMessage(ChatColor.GRAY + "[MidensFoods] " + ChatColor.GREEN + "The modern ID system is incompatible with versions under 1.14!");
        } else {
            pm.registerEvents((Listener)new IdFoodCreator(), (Plugin)this);
        }
        pm.registerEvents((Listener)new FoodEaten(), (Plugin)this);
    }

    public void registerRecipes() {
        if (this.getConfig().getBoolean("LegacySystem") || Bukkit.getVersion().contains("1.13")) {
            LegacyFoodCreator recipe = new LegacyFoodCreator();
            recipe.ItemRecipe();
        } else {
            IdFoodCreator recipe = new IdFoodCreator();
            recipe.ItemRecipe();
        }
    }

    public void registerCommands() {
        this.getCommand("cf").setExecutor((CommandExecutor)new Core());
        this.getCommand("cf").setTabCompleter((TabCompleter)new CoreTabCompleter());
    }

    public void unloadRecipes() {
        Bukkit.resetRecipes();
    }

    public void unloadEvents() {
        HandlerList.unregisterAll((Listener)new LegacyFoodCreator());
        HandlerList.unregisterAll((Listener)new IdFoodCreator());
    }
}

