/*
 * Decompiled with CFR 0.152.
 */
package duder.dudercondense.utils;

import duder.dudercondense.utils.Enchant;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Item {
    private Material material;
    private String name = "%DEFAULT%";
    private List<String> lore = new ArrayList<String>();
    private List<Enchant> enchantments = new ArrayList<Enchant>();
    private int amount;
    private int uses;
    private short type;

    public Item(Material material, int amount, short type) {
        this.material = material;
        this.amount = amount;
        this.type = type;
    }

    public Item setName(String name) {
        this.name = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
        return this;
    }

    public Item setMaterial(Material material) {
        this.material = material;
        return this;
    }

    public Item setAmount(int amount) {
        this.amount = amount;
        return this;
    }

    public Item setType(short type) {
        this.type = type;
        return this;
    }

    public Item setUses(int uses) {
        this.uses = uses;
        return this;
    }

    public Item setLore(List<String> lore) {
        this.lore = lore;
        return this;
    }

    public Item setLore(String[] loreArray) {
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : loreArray) {
            lore.add(line);
        }
        this.lore = lore;
        return this;
    }

    public Item setEnchantments(List<Enchant> enchantments) {
        this.enchantments = enchantments;
        return this;
    }

    public Item setEnchantments(Enchant[] enchantmentsArray) {
        ArrayList<Enchant> enchantments = new ArrayList<Enchant>();
        for (Enchant enchant : enchantmentsArray) {
            enchantments.add(enchant);
        }
        this.enchantments = enchantments;
        return this;
    }

    public Item addEnchantment(Enchant enchantment) {
        this.enchantments.add(enchantment);
        return this;
    }

    public ItemStack getItem() {
        ItemStack item = new ItemStack(this.material, this.amount, this.type);
        ItemMeta meta = item.getItemMeta();
        if (!this.name.equals("%DEFAULT%")) {
            meta.setDisplayName(this.name);
        }
        if (this.lore.size() != 0) {
            meta.setLore(this.lore);
        }
        if (this.enchantments.size() != 0) {
            for (Enchant enchant : this.enchantments) {
                meta.addEnchant(enchant.getEnchantment(), enchant.getPower(), enchant.is());
            }
        }
        item.setItemMeta(meta);
        return item;
    }
}

