/*
 * Decompiled with CFR 0.152.
 */
package me.MasterDev.GoLive;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import me.MasterDev.GoLive.DataManager;
import me.MasterDev.GoLive.Gui;
import me.MasterDev.GoLive.Metrics;
import me.MasterDev.GoLive.UpdateChecker;
import me.MasterDev.GoLive.Utils;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Consumer;

public class Main
extends JavaPlugin
implements Listener {
    static Map<String, Boolean> livePlayer = new HashMap<String, Boolean>();
    Gui gui;
    DataManager datamanager;
    public DataManager data;

    public DataManager getDataManager() {
        return this.data;
    }

    public void onEnable() {
        this.getLogger().info("----------------------------------");
        this.getLogger().info("     GOLIVE      ");
        this.getLogger().info("Author: MasterDev");
        this.getLogger().info("");
        this.getLogger().info("Loading plugin...");
        this.getLogger().info("");
        this.getLogger().info("Enabling the DataManager...");
        this.data = new DataManager(this);
        this.getLogger().info("DataManager enabled!");
        this.getLogger().info("");
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        int pluginId = 11803;
        Metrics metrics = new Metrics(this, pluginId);
        this.getLogger().info("");
        this.getLogger().info("Loading config...");
        this.saveDefaultConfig();
        this.getLogger().info("Config is loaded!");
        this.getLogger().info("");
        this.createDataConfig();
        this.getLogger().info("");
        this.getLogger().info("Checking for updates...");
        new UpdateChecker(this, 88288).getLatestVersion((Consumer<String>)((Consumer)version -> {
            if (this.getDescription().getVersion().equalsIgnoreCase((String)version)) {
                this.getLogger().info("Plugin is up to date!");
            } else {
                this.getLogger().info("An update is available! Please update at https://www.spigotmc.org/resources/88288/");
            }
        }));
        this.getLogger().info("Creating GUI...");
        this.gui = new Gui(this);
        Bukkit.getPluginManager().registerEvents((Listener)this.gui, (Plugin)this);
        this.gui.createInventory();
        this.getLogger().info("GUI created!");
        this.getLogger().info("Plugin loaded!");
        this.getLogger().info("----------------------------------");
    }

    public void onDisable() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            String uuid = p.getPlayer().getUniqueId().toString();
            if (!livePlayer.containsKey(uuid)) {
                return;
            }
            if (!livePlayer.get(uuid).booleanValue()) {
                return;
            }
            if (!livePlayer.get(uuid).booleanValue()) continue;
            Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), Utils.chat(this.getConfig().getString("prefixes.standardrank").replace("%player%", p.getName())));
            return;
        }
    }

    private void createDataConfig() {
        try {
            File file;
            if (!this.getDataFolder().exists()) {
                this.getDataFolder().mkdirs();
            }
            if (!(file = new File(this.getDataFolder(), "data.yml")).exists()) {
                this.getLogger().info("Data.yml not found, creating!");
                this.data.saveDefaultConfig();
                this.data.reloadConfig();
            } else {
                this.getLogger().info("Data.yml found, loading!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        if (p.hasPermission("golive.admin")) {
            new UpdateChecker(this, 88288).getLatestVersion((Consumer<String>)((Consumer)version -> {
                if (!this.getDescription().getVersion().equalsIgnoreCase((String)version)) {
                    p.sendMessage(ChatColor.GRAY + "****************************************************************");
                    p.sendMessage(Utils.chat("&5&lGoLive &cis outdated!"));
                    p.sendMessage(ChatColor.RED + "Newest version: " + version);
                    p.sendMessage(ChatColor.GOLD + "Please Update Here: " + ChatColor.ITALIC + "https://www.spigotmc.org/resources/88288/");
                    p.sendMessage(ChatColor.GRAY + "****************************************************************");
                }
            }));
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (label.equalsIgnoreCase("golive")) {
            if (!sender.hasPermission("golive.admin")) {
                sender.sendMessage(Utils.chat(this.getConfig().getString("messages.noaccess").replace("%player%", sender.getName()).replace("%prefix%", this.getConfig().getString(Utils.chat("prefix.prefix")))));
                return true;
            }
            if (args.length == 0) {
                Player player = (Player)sender;
                player.sendMessage(Utils.chat("&f*********************"));
                player.sendMessage(Utils.chat("&5&lGoLive"));
                player.sendMessage(Utils.chat(""));
                player.sendMessage(Utils.chat("&aVersion: &e3.9"));
                player.sendMessage(Utils.chat("&aAuthor: &eMasterDev"));
                player.sendMessage(Utils.chat(""));
                player.sendMessage(Utils.chat("&fCommands:"));
                player.sendMessage(Utils.chat(""));
                player.sendMessage(Utils.chat("&e/live addlink (link)"));
                player.sendMessage(Utils.chat("&e/live"));
                player.sendMessage(Utils.chat("&e/offline"));
                player.sendMessage(Utils.chat("&e/golive"));
                player.sendMessage(Utils.chat("&e/golive reload"));
                player.sendMessage(Utils.chat("&f*********************"));
                return true;
            }
            if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
                sender.sendMessage(Utils.chat("&aConfig.yml and Data.yml was reloaded! If your changes did not apply, please restart the server."));
                this.reloadConfig();
                this.data.reloadConfig();
                return true;
            }
        }
        final Player player = (Player)sender;
        if (label.equalsIgnoreCase("live")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(Utils.chat(this.getConfig().getString("messages.noaccess").replace("%player%", sender.getName()).replace("%prefix%", this.getConfig().getString(Utils.chat("prefix.prefix")))));
                return true;
            }
            if (!player.hasPermission("golive.live")) {
                sender.sendMessage(Utils.chat(this.getConfig().getString("messages.nopermission").replace("%player%", player.getName()).replace("%prefix%", this.getConfig().getString(Utils.chat("prefix.prefix")))));
                return true;
            }
            if (args.length == 0) {
                if (this.getConfig().getBoolean("settings.livegui")) {
                    player.openInventory(this.gui.livegui);
                    return true;
                }
                String uuid = player.getPlayer().getUniqueId().toString();
                if (!this.data.getConfig().isSet("livelinks." + uuid)) {
                    player.sendMessage(Utils.chat(this.getConfig().getString("messages.nolivelink").replace("%player%", player.getName()).replace("%prefix%", this.getConfig().getString(Utils.chat("prefix.prefix")))));
                    return true;
                }
                String livelink = this.data.getConfig().getString("livelinks." + uuid);
                if (this.getConfig().getBoolean("settings.livemessagehover")) {
                    TextComponent hovermessage = new TextComponent(Utils.chat(this.getConfig().getString("messages.live").replace("%player%", player.getName()).replace("%streamlink%", livelink).replace("%prefix%", this.getConfig().getString(Utils.chat("prefix.prefix")))));
                    hovermessage.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, livelink));
                    hovermessage.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(Utils.chat(this.getConfig().getString("messages.livehover").replace("%player%", player.getName()).replace("%streamlink%", livelink).replace("%prefix%", this.getConfig().getString(Utils.chat("prefix.prefix")))))}));
                    Bukkit.spigot().broadcast((BaseComponent)hovermessage);
                }
                if (!this.getConfig().getBoolean("settings.livemessagehover")) {
                    Bukkit.broadcastMessage((String)Utils.chat(this.getConfig().getString("messages.live").replace("%player%", player.getName()).replace("%streamlink%", livelink).replace("%prefix%", this.getConfig().getString(Utils.chat("prefix.prefix")))));
                }
                if (this.getConfig().getBoolean("settings.titleannouncement")) {
                    player.sendTitle(Utils.chat(this.getConfig().getString("messages.titletext").replace("%player%", player.getName()).replace("%streamlink%", livelink).replace("%prefix%", this.getConfig().getString("prefix.prefix"))), Utils.chat(this.getConfig().getString("messages.titlesubtext").replace("%player%", player.getName()).replace("%streamlink%", livelink).replace("%prefix%", this.getConfig().getString("prefix.prefix"))), this.getConfig().getInt("settings.titlefadein"), this.getConfig().getInt("settings.titlestay"), this.getConfig().getInt("settings.titlefadeout"));
                }
                if (this.getConfig().getBoolean("settings.announcementsound")) {
                    player.playSound(player.getLocation(), this.getConfig().getString("settings.sound"), (float)this.getConfig().getInt("settings.soundvolume"), (float)this.getConfig().getInt("settings.soundpitch"));
                }
                this.reloadConfig();
                player.sendMessage(Utils.chat(this.getConfig().getString("messages.offlinehint").replace("%player%", player.getName()).replace("%streamlink%", livelink).replace("%prefix%", this.getConfig().getString(Utils.chat("prefix.prefix")))));
                Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), this.getConfig().getString("prefixes.liverank").replace("%player%", player.getName()));
                livePlayer.put(uuid, true);
                this.reloadConfig();
                if (!this.getConfig().getBoolean("settings.liverankautoremoval")) {
                    return true;
                }
                Bukkit.getScheduler().runTaskLater((Plugin)this, new Runnable(){

                    @Override
                    public void run() {
                        Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), Utils.chat(((Main)Main.getPlugin(Main.class)).getConfig().getString("prefixes.standardrank").replace("%player%", player.getName())));
                    }
                }, (long)(20 * this.getConfig().getInt("settings.liverankremovedelay")));
                return true;
            }
            if (args[0].equalsIgnoreCase("addlink")) {
                if (!args[1].contains("https://")) {
                    player.sendMessage(Utils.chat(this.getConfig().getString("messages.invalidlink").replace("%player%", player.getName()).replace("%prefix%", this.getConfig().getString(Utils.chat("prefix.prefix")))));
                    return true;
                }
                String livelink = args[1];
                String uuid = player.getPlayer().getUniqueId().toString();
                this.data.getConfig().set("livelinks." + uuid, (Object)livelink);
                this.data.saveConfig();
                player.sendMessage(Utils.chat(this.getConfig().getString("messages.linkset").replace("%player%", player.getName()).replace("%streamlink%", livelink).replace("%prefix%", this.getConfig().getString(Utils.chat("prefix.prefix")))));
                return true;
            }
        }
        if (label.equalsIgnoreCase("offline")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(Utils.chat(this.getConfig().getString("messages.noaccess").replace("%player%", sender.getName()).replace("%prefix%", this.getConfig().getString(Utils.chat("prefix.prefix")))));
                return true;
            }
            if (!player.hasPermission("golive.live")) {
                sender.sendMessage(Utils.chat(this.getConfig().getString("messages.nopermission").replace("%player%", player.getName()).replace("%prefix%", this.getConfig().getString(Utils.chat("prefix.prefix")))));
                return true;
            }
            if (this.getConfig().getBoolean("settings.livegui")) {
                player.openInventory(this.gui.livegui);
                return true;
            }
            String uuid = player.getPlayer().getUniqueId().toString();
            player.sendMessage(Utils.chat(this.getConfig().getString("messages.offline")).replace("%player%", player.getName()).replace("%prefix%", Utils.chat(this.getConfig().getString("prefix.prefix"))));
            Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), Utils.chat(this.getConfig().getString("prefixes.standardrank").replace("%player%", player.getName())));
            livePlayer.put(uuid, false);
            return true;
        }
        return true;
    }
}

