/*
 * Decompiled with CFR 0.152.
 */
package com.popupmc.areaspawner.utils;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class YamlFile {
    private final JavaPlugin plugin;
    private final Map<String, String> mapRefill;
    private final FileConfiguration fileConfig;
    private String fileName;
    private final File file;

    public YamlFile(JavaPlugin plugin, String fileName) {
        this(plugin, fileName, null);
    }

    public YamlFile(JavaPlugin plugin, String fileName, Map<String, String> mapRefill) {
        this.plugin = plugin;
        this.mapRefill = mapRefill;
        this.file = new File(plugin.getDataFolder(), fileName);
        this.fileConfig = new YamlConfiguration();
        this.fileName = fileName;
        this.saveDefault();
        this.loadFileConfiguration();
        if (mapRefill != null) {
            this.refillNodes();
        }
    }

    public void loadFileConfiguration() {
        try {
            if (Strings.isNullOrEmpty((String)this.fileName)) {
                throw new NullPointerException("File name is empty or null.");
            }
            if (!this.fileName.endsWith(".yml")) {
                this.fileName = this.fileName + ".yml";
            }
            this.fileConfig.load(this.file);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void refillNodes() {
        for (Map.Entry<String, String> mapEntry : this.mapRefill.entrySet()) {
            if (this.fileConfig.isSet(mapEntry.getKey())) continue;
            this.fileConfig.set(mapEntry.getKey(), (Object)mapEntry.getValue());
        }
        this.save();
    }

    public void save() {
        try {
            this.fileConfig.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveDefault() {
        if (!this.file.exists()) {
            this.plugin.saveResource(this.fileName, false);
        }
    }

    public File getFile() {
        return this.file;
    }

    public String getFileName() {
        return this.fileName;
    }

    public FileConfiguration getAccess() {
        return this.fileConfig;
    }
}

