/*
 * Decompiled with CFR 0.152.
 */
package com.popupmc.areaspawner.utils;

import com.popupmc.areaspawner.AreaSpawner;
import com.popupmc.areaspawner.utils.Settings;
import java.util.concurrent.TimeUnit;
import org.bukkit.configuration.file.FileConfiguration;

public class TravelCooldownManager {
    private static TravelCooldownManager instance;
    private final AreaSpawner plugin;

    private TravelCooldownManager(AreaSpawner plugin) {
        this.plugin = plugin;
    }

    public long getTimeLeft(String playerName) {
        FileConfiguration cooldownFile = this.plugin.getCooldownYaml().getAccess();
        if (cooldownFile.contains("cooldown." + playerName)) {
            long startTime = cooldownFile.getLong("cooldown." + playerName);
            long cooldownMillis = TimeUnit.SECONDS.toMillis(Settings.getInstance().getTravelCooldown() / 20);
            return startTime + cooldownMillis - System.currentTimeMillis();
        }
        return 0L;
    }

    public void addToCooldown(String playerName) {
        FileConfiguration cooldownFile = this.plugin.getCooldownYaml().getAccess();
        cooldownFile.set("cooldown." + playerName, (Object)System.currentTimeMillis());
        this.plugin.getCooldownYaml().save();
    }

    public static void createInstance(AreaSpawner plugin) {
        if (instance == null) {
            instance = new TravelCooldownManager(plugin);
        }
    }

    public static TravelCooldownManager getInstance() {
        return instance;
    }
}

