/*
 * Decompiled with CFR 0.152.
 */
package com.popupmc.areaspawner.utils;

import com.popupmc.areaspawner.AreaSpawner;
import java.util.ArrayList;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public enum TimeUnit {
    TICKS(1),
    SECONDS(20),
    MINUTES(1200),
    HOURS(72000),
    DAYS(1728000);

    private final int multiplier;

    private TimeUnit(int multiplier) {
        this.multiplier = multiplier;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public static TimeUnit getByAlias(char alias) {
        switch (alias) {
            case 'T': 
            case 't': {
                return TICKS;
            }
            case 'M': 
            case 'm': {
                return MINUTES;
            }
            case 'H': 
            case 'h': {
                return HOURS;
            }
            case 'D': 
            case 'd': {
                return DAYS;
            }
        }
        return SECONDS;
    }

    public static int getTicks(int amount, TimeUnit timeUnit) {
        return amount * timeUnit.getMultiplier();
    }

    public static int getTicks(int amount, char timeUnit) {
        return TimeUnit.getTicks(amount, TimeUnit.getByAlias(timeUnit));
    }

    public static String getTimeString(long ticks) {
        String s;
        FileConfiguration messages = ((AreaSpawner)JavaPlugin.getPlugin(AreaSpawner.class)).getMessagesYaml().getAccess();
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        long days = TimeUnit.getDays(ticks);
        long hours = TimeUnit.getHours(ticks);
        long minutes = TimeUnit.getMinutes(ticks);
        long seconds = TimeUnit.getSeconds(ticks);
        if (days > 0L) {
            s = days + " " + (days > 1L ? messages.getString("messages.days") : messages.getString("messages.day"));
            args.add(s);
        }
        if (hours > 0L) {
            s = hours + " " + (hours > 1L ? messages.getString("messages.hours") : messages.getString("messages.hour"));
            args.add(s);
        }
        if (minutes > 0L) {
            s = minutes + " " + (minutes > 1L ? messages.getString("messages.minutes") : messages.getString("messages.minute"));
            args.add(s);
        }
        s = (seconds >= 0L ? seconds : 0L) + " " + (seconds == 0L || seconds > 1L ? messages.getString("messages.seconds") : messages.getString("messages.second"));
        args.add(s);
        for (int i = 0; i < args.size(); ++i) {
            if (args.size() > 1 && i != 0) {
                sb.append(i == args.size() - 1 ? " " + messages.getString("messages.and") + " " : ", ");
            }
            sb.append((String)args.get(i));
        }
        return sb.toString();
    }

    public static long getTotalSeconds(long ticks) {
        return ticks / 20L;
    }

    public static long getSeconds(long ticks) {
        return java.util.concurrent.TimeUnit.SECONDS.toSeconds(TimeUnit.getTotalSeconds(ticks)) - java.util.concurrent.TimeUnit.MINUTES.toSeconds(TimeUnit.getMinutes(ticks)) - java.util.concurrent.TimeUnit.HOURS.toSeconds(TimeUnit.getHours(ticks)) - java.util.concurrent.TimeUnit.DAYS.toSeconds(TimeUnit.getDays(ticks));
    }

    public static long getMinutes(long ticks) {
        return java.util.concurrent.TimeUnit.SECONDS.toMinutes(TimeUnit.getTotalSeconds(ticks)) - java.util.concurrent.TimeUnit.HOURS.toMinutes(TimeUnit.getHours(ticks)) - java.util.concurrent.TimeUnit.DAYS.toMinutes(TimeUnit.getDays(ticks));
    }

    public static long getHours(long ticks) {
        return java.util.concurrent.TimeUnit.SECONDS.toHours(TimeUnit.getTotalSeconds(ticks)) - java.util.concurrent.TimeUnit.DAYS.toHours(TimeUnit.getDays(ticks));
    }

    public static long getDays(long ticks) {
        return java.util.concurrent.TimeUnit.SECONDS.toDays(TimeUnit.getTotalSeconds(ticks));
    }
}

