/*
 * Decompiled with CFR 0.152.
 */
package com.popupmc.areaspawner.utils;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.popupmc.areaspawner.AreaSpawner;
import com.popupmc.areaspawner.spawn.Region;
import com.popupmc.areaspawner.utils.Logger;
import com.popupmc.areaspawner.utils.TimeUnit;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class Settings {
    private static Settings instance;
    private final AreaSpawner plugin;
    private boolean debug;
    private boolean removeUsedLocation;
    private boolean cacheEnabled;
    private boolean saveCacheToFile;
    private boolean topToBottom;
    private boolean checkPastSurface;
    private boolean checkSafetyOnUse;
    private boolean deleteOnUnsafe;
    private boolean replaceRemovedLocation;
    private boolean spawnOnDeath;
    private boolean spawnOnFirstJoin;
    private boolean spawnOnBed;
    private boolean useAutomaticPermission;
    private boolean essentialsHomeOnRespawn;
    private boolean essentialsSetHomeOnFirstJoin;
    private boolean essentialsSetHomeOnTravel;
    private boolean travelEnabled;
    private boolean removePermissionOnTravel;
    private boolean listIsWhitelist;
    private int cachedLocationsAmount;
    private int findSafeLocationAttempts;
    private int airGapAbove;
    private int timeBetweenLocations;
    private int timeBetweenAttempts;
    private int travelCooldown;
    private String prefix;
    private String worldName;
    private String firstJoinHomeName;
    private String travelHomeName;
    private List<String> blockList;
    private World world;
    private Region allowedRegion;
    private Region forbiddenRegion;

    private Settings(AreaSpawner plugin) {
        instance = this;
        this.plugin = plugin;
        this.reloadFields();
    }

    public void reloadFields() {
        FileConfiguration config = this.plugin.getConfig();
        this.debug = config.getBoolean("debug");
        this.removeUsedLocation = config.getBoolean("delete location on use");
        this.cacheEnabled = config.getBoolean("enable cache");
        this.saveCacheToFile = config.getBoolean("save cache to file");
        this.topToBottom = config.getBoolean("top to bottom");
        this.checkPastSurface = config.getBoolean("check past surface");
        this.checkSafetyOnUse = config.getBoolean("re-check for safety on use");
        this.deleteOnUnsafe = config.getBoolean("delete location on unsafe");
        this.replaceRemovedLocation = config.getBoolean("replace location on remove");
        this.spawnOnDeath = config.getBoolean("spawn on death");
        this.spawnOnFirstJoin = config.getBoolean("spawn on first join");
        this.spawnOnBed = config.getBoolean("spawn on bed");
        this.useAutomaticPermission = config.getBoolean("use permission");
        boolean essentialsEnabled = Bukkit.getPluginManager().getPlugin("Essentials") != null && Bukkit.getPluginManager().isPluginEnabled("Essentials");
        this.essentialsHomeOnRespawn = config.getBoolean("essentials home teleport") && essentialsEnabled;
        this.essentialsSetHomeOnFirstJoin = config.getBoolean("essentials home on first spawn") && essentialsEnabled;
        this.essentialsSetHomeOnTravel = config.getBoolean("home on travel") && essentialsEnabled;
        this.travelEnabled = config.getBoolean("travel enabled");
        this.removePermissionOnTravel = config.getBoolean("remove permission on travel");
        this.listIsWhitelist = config.getBoolean("list is whitelist");
        this.findSafeLocationAttempts = config.getInt("safe spawn attempts");
        this.cachedLocationsAmount = config.getInt("amount of cached spawns");
        this.airGapAbove = config.getInt("air gap above");
        String timeBLString = config.getString("time between generating locations");
        this.timeBetweenLocations = timeBLString != null && timeBLString.length() > 1 ? TimeUnit.getTicks(Integer.parseInt(timeBLString.substring(0, timeBLString.length() - 1)), timeBLString.charAt(timeBLString.length() - 1)) : TimeUnit.getTicks(3, TimeUnit.SECONDS);
        String timeBAString = config.getString("time between location attempts");
        this.timeBetweenAttempts = timeBAString != null && timeBAString.length() > 1 ? TimeUnit.getTicks(Integer.parseInt(timeBAString.substring(0, timeBAString.length() - 1)), timeBAString.charAt(timeBAString.length() - 1)) : TimeUnit.getTicks(5, TimeUnit.TICKS);
        String cooldownString = config.getString("travel cooldown");
        this.travelCooldown = cooldownString != null && cooldownString.length() > 1 ? TimeUnit.getTicks(Integer.parseInt(cooldownString.substring(0, cooldownString.length() - 1)), cooldownString.charAt(cooldownString.length() - 1)) : TimeUnit.getTicks(0, TimeUnit.SECONDS);
        this.prefix = config.getString("prefix");
        this.worldName = config.getString("spawn world");
        this.firstJoinHomeName = config.getString("home on first spawn name");
        this.travelHomeName = config.getString("home on travel name");
        this.blockList = config.getStringList("block list");
        this.world = Bukkit.getWorld((String)this.worldName);
        this.defineAllowedRegion();
        this.defineForbiddenRegion();
    }

    private void defineAllowedRegion() {
        int zRange;
        int yCenter;
        int xCenter;
        FileConfiguration config = this.plugin.getConfig();
        boolean multiverseEnabled = Bukkit.getPluginManager().getPlugin("Multiverse-Core") != null && Bukkit.getPluginManager().isPluginEnabled("Multiverse-Core");
        boolean clampToLimits = config.getBoolean("spawn zone.clamp to limits");
        if (config.getInt("spawn zone.x center") == -1) {
            xCenter = config.getBoolean("spawn zone.default to multiverse") && multiverseEnabled ? ((MultiverseCore)JavaPlugin.getPlugin(MultiverseCore.class)).getMVWorldManager().getMVWorld(this.world).getSpawnLocation().getBlockX() : this.world.getSpawnLocation().getBlockX();
        } else {
            int n = xCenter = clampToLimits ? Math.min(29999984, config.getInt("spawn zone.x center")) : config.getInt("spawn zone.x center");
        }
        if (config.getInt("spawn zone.y center") == -1) {
            yCenter = config.getBoolean("spawn zone.default to multiverse") && multiverseEnabled ? ((MultiverseCore)JavaPlugin.getPlugin(MultiverseCore.class)).getMVWorldManager().getMVWorld(this.world).getSpawnLocation().getBlockY() : this.world.getSpawnLocation().getBlockY();
        } else {
            int n = yCenter = clampToLimits ? Math.min(255, config.getInt("spawn zone.y center")) : config.getInt("spawn zone.y center");
        }
        int zCenter = config.getInt("spawn zone.z center") == -1 ? (config.getBoolean("spawn zone.default to multiverse") && multiverseEnabled ? ((MultiverseCore)JavaPlugin.getPlugin(MultiverseCore.class)).getMVWorldManager().getMVWorld(this.world).getSpawnLocation().getBlockZ() : this.world.getSpawnLocation().getBlockZ()) : (clampToLimits ? Math.min(29999984, config.getInt("spawn zone.z center")) : config.getInt("spawn zone.z center"));
        int xRange = clampToLimits ? Math.min(29999984, config.getInt("spawn zone.x range")) : config.getInt("spawn zone.x range");
        int yRange = clampToLimits ? Math.min(255, config.getInt("spawn zone.y range")) : config.getInt("spawn zone.y range");
        int n = zRange = clampToLimits ? Math.min(29999984, config.getInt("spawn zone.z range")) : config.getInt("spawn zone.z range");
        if (clampToLimits) {
            if (xCenter + xRange > 29999984 || xCenter - xRange < -29999984) {
                xRange = 29999984 - xCenter;
            }
            if (yCenter + yRange > 256 || yCenter - yRange < 0) {
                yRange = 128 - yCenter;
            }
            if (zCenter + zRange > 29999984 || zCenter - zRange < -29999984) {
                zRange = 29999984 - zCenter;
            }
        }
        Logger.debug("Region final centers: " + xCenter + " " + yCenter + " " + zCenter);
        Logger.debug("Region final ranges: " + xRange + " " + yRange + " " + zRange);
        this.allowedRegion = Region.newRegionByRanges(xCenter, yCenter, zCenter, xRange, yRange, zRange);
    }

    private void defineForbiddenRegion() {
        FileConfiguration config = this.plugin.getConfig();
        boolean enabled = config.getBoolean("no spawn zone.enabled");
        int xCenter = enabled ? config.getInt("spawn zone.x center") : 0;
        int zCenter = enabled ? config.getInt("spawn zone.z center") : 0;
        int xRange = enabled ? config.getInt("no spawn zone.x range") : 0;
        int zRange = enabled ? config.getInt("no spawn zone.z range") : 0;
        this.forbiddenRegion = Region.newRegionByRanges(xCenter, 0, zCenter, xRange, 0, zRange);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isRemoveUsedLocation() {
        return this.removeUsedLocation;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public boolean isSaveCacheToFile() {
        return this.saveCacheToFile;
    }

    public boolean isTopToBottom() {
        return this.topToBottom;
    }

    public boolean isNotCheckPastSurface() {
        return !this.checkPastSurface;
    }

    public boolean isCheckSafetyOnUse() {
        return this.checkSafetyOnUse;
    }

    public boolean isDeleteOnUnsafe() {
        return this.deleteOnUnsafe;
    }

    public boolean isReplaceRemovedLocation() {
        return this.replaceRemovedLocation;
    }

    public boolean isSpawnOnDeath() {
        return this.spawnOnDeath;
    }

    public boolean isSpawnOnFirstJoin() {
        return this.spawnOnFirstJoin;
    }

    public boolean isSpawnOnBed() {
        return this.spawnOnBed;
    }

    public boolean isNotUseAutomaticPermission() {
        return !this.useAutomaticPermission;
    }

    public boolean isEssentialsHomeOnRespawn() {
        return this.essentialsHomeOnRespawn;
    }

    public boolean isEssentialsSetHomeOnFirstJoin() {
        return this.essentialsSetHomeOnFirstJoin;
    }

    public boolean isEssentialsSetHomeOnTravel() {
        return this.essentialsSetHomeOnTravel;
    }

    public boolean isTravelEnabled() {
        return this.travelEnabled;
    }

    public boolean isRemovePermissionOnTravel() {
        return this.removePermissionOnTravel;
    }

    public boolean isListIsWhitelist() {
        return this.listIsWhitelist;
    }

    public int getFindSafeLocationAttempts() {
        return this.findSafeLocationAttempts;
    }

    public int getCachedLocationsAmount() {
        return this.cachedLocationsAmount;
    }

    public int getAirGapAbove() {
        return this.airGapAbove;
    }

    public int getTimeBetweenLocations() {
        return this.timeBetweenLocations;
    }

    public int getTimeBetweenLocationAttempts() {
        return this.timeBetweenAttempts;
    }

    public int getTravelCooldown() {
        return this.travelCooldown;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public String getFirstJoinHomeName() {
        return this.firstJoinHomeName;
    }

    public String getTravelHomeName() {
        return this.travelHomeName;
    }

    public List<String> getBlockList() {
        return this.blockList;
    }

    public World getWorld() {
        return this.world;
    }

    public Region getAllowedRegion() {
        return this.allowedRegion;
    }

    public Region getForbiddenRegion() {
        return this.forbiddenRegion;
    }

    public static void createInstance(AreaSpawner plugin) {
        instance = new Settings(plugin);
    }

    public static Settings getInstance() {
        return instance;
    }
}

