/*
 * Decompiled with CFR 0.152.
 */
package com.popupmc.areaspawner.spawn;

import com.popupmc.areaspawner.utils.Logger;
import com.popupmc.areaspawner.utils.Settings;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;

public class Region {
    private final int minX;
    private final int maxX;
    private final int minY;
    private final int maxY;
    private final int minZ;
    private final int maxZ;

    public static Region newRegionByRanges(int xCenter, int yCenter, int zCenter, int xRange, int yRange, int zRange) {
        return new Region(xCenter - xRange, xCenter + xRange, yCenter - yRange, yCenter + yRange, zCenter - zRange, zCenter + zRange);
    }

    public Region(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        Logger.debug("New region created with the following coordinates");
        Logger.debug("X: " + minX + " - " + maxX);
        Logger.debug("Y: " + minY + " - " + maxY);
        Logger.debug("Z: " + minZ + " - " + maxZ);
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.minZ = minZ;
        this.maxZ = maxZ;
    }

    public boolean contains(int pointX, int pointY, int pointZ) {
        return pointX <= this.maxX && pointX >= this.minX && pointY <= this.maxY && pointY >= this.minY && pointZ <= this.maxZ && pointZ >= this.minZ;
    }

    public boolean contains2D(int pointX, int pointZ) {
        return pointX <= this.maxX && pointX >= this.minX && pointZ <= this.maxZ && pointZ >= this.minZ;
    }

    public boolean contains(Region region) {
        return this.contains(region.getMaxX(), region.getMaxY(), region.getMaxZ()) && this.contains(region.getMinX(), region.getMinY(), region.getMinZ());
    }

    public Location generateNewLocation(Region forbidden) {
        Random r = new Random();
        Settings settings = Settings.getInstance();
        Location making = new Location(settings.getWorld(), 0.0, -10.0, 0.0);
        int attempts = Settings.getInstance().getFindSafeLocationAttempts();
        for (int i = 1; i <= attempts; ++i) {
            Logger.debug("&eAttempt number " + i + " to generate location.");
            making.setX((double)(r.nextInt(this.getMaxX() - this.getMinX()) + this.getMinX()));
            making.setZ((double)(r.nextInt(this.getMaxZ() - this.getMinZ()) + this.getMinZ()));
            this.setYValue(making);
            if (Region.isValidLocation(making, forbidden, this)) {
                Logger.debug("&aSafe valid location achieved!");
                return making;
            }
            try {
                Thread.sleep((long)settings.getTimeBetweenLocationAttempts() * 50L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void setYValue(Location loc) {
        Settings settings = Settings.getInstance();
        if (settings.isTopToBottom()) {
            for (int i = this.maxY; i > this.minY; --i) {
                loc.setY((double)i);
                if (loc.getBlock().getType().equals((Object)Material.VOID_AIR) || loc.getBlock().getType().equals((Object)Material.AIR)) continue;
                if (Region.isSafeBlock(loc.getBlock().getType().toString())) {
                    loc.setY((double)(loc.getBlockY() + 1));
                    return;
                }
                if (!settings.isNotCheckPastSurface()) {
                    continue;
                }
                break;
            }
        } else {
            for (int i = this.minY; i < this.maxY; ++i) {
                loc.setY((double)i);
                if (loc.getBlock().getType().equals((Object)Material.VOID_AIR) || loc.getBlock().getType().equals((Object)Material.AIR) || !loc.getBlock().getRelative(BlockFace.UP).getType().equals((Object)Material.AIR)) continue;
                if (Region.isSafeBlock(loc.getBlock().getType().toString())) {
                    loc.setY((double)(loc.getBlockY() + 1));
                    return;
                }
                if (!settings.isNotCheckPastSurface()) {
                    continue;
                }
                break;
            }
        }
        loc.setY(-9999.0);
    }

    private static boolean isSafeBlock(String block) {
        Settings settings = Settings.getInstance();
        if (settings.isListIsWhitelist()) {
            return settings.getBlockList().contains(block);
        }
        return !settings.getBlockList().contains(block);
    }

    public Region getRandomQuadrant() {
        int quadrant = new Random().nextInt(4);
        int xCenter = (this.minX + this.maxX) / 2;
        int zCenter = (this.minZ + this.maxZ) / 2;
        if (quadrant == 0) {
            Logger.debug("The first quadrant is the chosen quadrant");
            return new Region(xCenter, this.maxX, this.minY, this.maxY, this.minZ, zCenter);
        }
        if (quadrant == 1) {
            Logger.debug("The second quadrant is the chosen quadrant");
            return new Region(xCenter, this.maxX, this.minY, this.maxY, zCenter, this.maxZ);
        }
        if (quadrant == 2) {
            Logger.debug("The third quadrant is the chosen quadrant");
            return new Region(this.minX, xCenter, this.minY, this.maxY, this.minZ, zCenter);
        }
        Logger.debug("The fourth quadrant is the chosen quadrant");
        return new Region(this.minX, xCenter, this.minY, this.maxY, zCenter, this.maxZ);
    }

    public Region getRandomStrip() {
        Region forbidden = Settings.getInstance().getForbiddenRegion();
        int strip = new Random().nextInt(4);
        if (strip == 0) {
            Logger.debug("The upper strip is the chosen strip");
            return new Region(forbidden.getMaxX(), this.getMaxX(), this.getMinY(), this.getMaxY(), this.getMinZ(), forbidden.getMaxZ());
        }
        if (strip == 1) {
            Logger.debug("The right side strip is the chosen strip");
            return new Region(this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY(), forbidden.getMaxZ(), this.getMaxZ());
        }
        if (strip == 2) {
            Logger.debug("The lower strip is the chosen strip");
            return new Region(this.getMinX(), forbidden.getMinX(), this.getMinY(), this.getMaxY(), this.getMinZ(), this.getMaxZ());
        }
        Logger.debug("The left side strip is the chosen strip");
        return new Region(this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY(), this.getMinZ(), forbidden.getMaxZ());
    }

    public static boolean isValidLocation(Location loc, Region forbidden, Region allowed) {
        String blockType = loc.getBlock().getType().toString();
        if (loc.getY() < 1.0 || loc.getY() > 255.0) {
            Logger.debug("&cNo non-air, non-void block found.");
            return false;
        }
        if (forbidden.contains2D(loc.getBlockX(), loc.getBlockZ())) {
            Logger.debug("&cLocation is in no-spawn region.");
            return false;
        }
        if (!allowed.contains(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ())) {
            Logger.debug("&cLocation is not in allowed region.");
            return false;
        }
        if (!Region.hasAirGap(loc)) {
            Logger.debug("&cThe air gap was not tall enough, or there were none at all.");
            return false;
        }
        if (!Region.isSafeBlock(blockType)) {
            Logger.debug("&cBlock " + blockType + " is not considered safe.");
            return false;
        }
        return true;
    }

    private static boolean hasAirGap(Location loc) {
        int airGap = Settings.getInstance().getAirGapAbove();
        for (int i = 1; i <= airGap; ++i) {
            if (loc.getBlock().getRelative(BlockFace.UP, i).getType().equals((Object)Material.AIR)) continue;
            return false;
        }
        return true;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }
}

