/*
 * Decompiled with CFR 0.152.
 */
package com.popupmc.areaspawner.spawn;

import com.popupmc.areaspawner.AreaSpawner;
import com.popupmc.areaspawner.spawn.Region;
import com.popupmc.areaspawner.utils.Logger;
import com.popupmc.areaspawner.utils.Settings;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class RandomSpawnCache {
    private static RandomSpawnCache instance;
    private List<Location> spawnLocations;
    private final AreaSpawner plugin;
    private BukkitTask cacheGeneratorTask;
    private boolean stopCache = false;
    private final Settings settings;

    private RandomSpawnCache(AreaSpawner plugin) {
        this.plugin = plugin;
        this.settings = Settings.getInstance();
        this.spawnLocations = new ArrayList<Location>();
        if (Settings.getInstance().isCacheEnabled()) {
            Logger.send("Cache successfully initialized");
            this.loadFromFile();
            this.createSafeSpawns(false);
        } else {
            Logger.send("&eWARNING &f- Location cache is disabled. Locations will be calculated on the spot, players may take a while to respawn depending on your other settings.");
        }
    }

    public void createSafeSpawns(boolean clear) {
        if (clear) {
            this.spawnLocations = new ArrayList<Location>();
        }
        this.createSafeLocations();
    }

    public boolean stopCache() {
        if (this.cacheGeneratorTask == null || this.cacheGeneratorTask.isCancelled() || this.stopCache) {
            return false;
        }
        this.cacheGeneratorTask.cancel();
        this.stopCache = true;
        return true;
    }

    public void teleport(Player player) {
        player.teleport(this.getSafeSpawn(), PlayerTeleportEvent.TeleportCause.PLUGIN);
        Logger.send((CommandSender)player, this.plugin.getMessagesYaml().getAccess().getString("messages.you have been teleported"));
    }

    public Location getSafeSpawn() {
        Random r = new Random();
        if (this.settings.isCacheEnabled() && !this.spawnLocations.isEmpty()) {
            Location location = this.spawnLocations.get(r.nextInt(this.spawnLocations.size()));
            if (this.settings.isCheckSafetyOnUse()) {
                while (!Region.isValidLocation(location, this.settings.getForbiddenRegion(), this.settings.getAllowedRegion())) {
                    if (this.settings.isDeleteOnUnsafe()) {
                        Logger.debug("&cA previously considered safe location is no longer safe, generating a new one in replacement.");
                        this.removeLocation(location);
                    }
                    location = this.spawnLocations.get(r.nextInt(this.spawnLocations.size()));
                }
            }
            Logger.debug("&eA location has been used");
            if (this.settings.isRemoveUsedLocation()) {
                Logger.debug("&eRemoving the used location.");
                this.removeLocation(location);
            }
            return location.clone().add(0.5, 1.0, 0.5);
        }
        return this.settings.getAllowedRegion().getRandomStrip().generateNewLocation(this.settings.getForbiddenRegion());
    }

    private void replaceLocation() {
        Region allowed = this.settings.getAllowedRegion();
        Region forbidden = this.settings.getForbiddenRegion();
        Location loc = allowed.getRandomStrip().generateNewLocation(forbidden);
        if (loc == null) {
            Logger.debug("&cFailed to add replacement location after " + this.settings.getFindSafeLocationAttempts() + " attempts");
        } else {
            Logger.debug("&aReplacement location successfully added!");
            this.spawnLocations.add(loc);
        }
    }

    public void reValidateSpawns() {
        for (Location loc : this.spawnLocations) {
            if (Region.isValidLocation(loc, this.settings.getForbiddenRegion(), this.settings.getAllowedRegion())) continue;
            Logger.debug("&cA location has been detected as no longer safe.");
            if (!this.settings.isDeleteOnUnsafe()) continue;
            this.removeLocation(loc);
        }
    }

    private void removeLocation(Location loc) {
        this.spawnLocations.remove(loc);
        Logger.debug("&aLocation successfully removed from the locations list");
        if (this.settings.isReplaceRemovedLocation()) {
            Logger.debug("&eCreating a new location in replacement.");
            CompletableFuture.runAsync(this::replaceLocation);
        }
    }

    public void createSafeLocations() {
        if (!this.settings.isCacheEnabled()) {
            Logger.send("&eWARNING &f- Location cache is disabled. Locations will be calculated on the spot, players may take a while to respawn depending on your other settings.");
            return;
        }
        Logger.send("&eCreating safe locations...");
        final Region allowed = this.settings.getAllowedRegion();
        final Region forbidden = this.settings.getForbiddenRegion();
        final int amountOfLocationsToAdd = this.settings.getCachedLocationsAmount();
        final int[] locationNumber = new int[]{this.spawnLocations.size()};
        final int[] addedLocations = new int[]{0, 0};
        this.cacheGeneratorTask = new BukkitRunnable(){

            public void run() {
                locationNumber[0] = locationNumber[0] + 1;
                Logger.debug("&eAttempting to add location number " + locationNumber[0]);
                Location loc = allowed.getRandomStrip().generateNewLocation(forbidden);
                if (loc == null) {
                    Logger.debug("&cFailed to add location number " + locationNumber[0] + " after " + RandomSpawnCache.this.settings.getFindSafeLocationAttempts() + " attempts");
                    addedLocations[1] = addedLocations[1] + 1;
                } else {
                    Logger.debug("&aLocation number " + locationNumber[0] + " successfully added!");
                    RandomSpawnCache.this.spawnLocations.add(loc);
                    addedLocations[0] = addedLocations[0] + 1;
                }
                if (locationNumber[0] > amountOfLocationsToAdd || RandomSpawnCache.this.stopCache) {
                    RandomSpawnCache.this.showAddedLocations(addedLocations[0], addedLocations[1]);
                    RandomSpawnCache.this.stopCache = false;
                } else {
                    try {
                        Thread.sleep((long)RandomSpawnCache.this.settings.getTimeBetweenLocations() * 50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    this.run();
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private void showAddedLocations(int succeeded, int failed) {
        if (succeeded > 0) {
            Logger.send("&aSuccessfully added " + succeeded + " new safe spawn locations");
        } else {
            Logger.send("&fNo new locations were added.");
        }
        if (failed > 0) {
            Logger.send("&cFailed to add " + failed + " safe spawn locations");
        }
    }

    public int getLocationsInCache() {
        return this.spawnLocations.size();
    }

    public void saveToFile() {
        if (this.settings.isSaveCacheToFile()) {
            FileConfiguration cache = this.plugin.getCacheYaml().getAccess();
            cache.set("cache", this.spawnLocations);
            cache.set("cache-settings-hash", (Object)this.getMDHash(this.spawnLocations));
            this.plugin.getCacheYaml().save();
            Logger.send("&aSuccessfully saved locations to cache file!");
        }
    }

    public void loadFromFile() {
        if (this.settings.isSaveCacheToFile()) {
            String hash;
            FileConfiguration cache = this.plugin.getCacheYaml().getAccess();
            Logger.debug("&eTrying to load locations from cache file...");
            if (!cache.contains("cache")) {
                Logger.debug("&cNo locations were found. Creating new ones instead.");
                return;
            }
            List locations = cache.getList("cache");
            assert (locations != null);
            if (cache.contains("cache-settings-hash") && (hash = this.getMDHash(locations)) != null && !hash.equals(cache.getString("cache-settings-hash"))) {
                Logger.send("&cThe cache file has been modified. Invalidating cache.");
                Logger.send("&eCreating new locations...");
                return;
            }
            Logger.debug("&aCache file is valid.");
            Logger.debug("&aFound &f" + locations.size() + "&a locations to load.");
            for (Location loc : locations) {
                if (Region.isValidLocation(loc, this.settings.getForbiddenRegion(), this.settings.getAllowedRegion())) {
                    this.spawnLocations.add(loc);
                    Logger.debug("&aAdded a location from the cache file.");
                    continue;
                }
                Logger.debug("&cA location in the cache file was not safe and therefore not added to the spawn list.");
            }
            Logger.debug("&fFinished loading locations from cache file.");
            Logger.send("&f" + this.spawnLocations.size() + "/" + locations.size() + " safe locations were loaded from the cache file");
            cache.set("cache", null);
            this.plugin.getCacheYaml().save();
        }
    }

    private String getMDHash(List<Location> locations) {
        StringBuilder result = new StringBuilder();
        for (Location loc : locations) {
            result.append(loc.toString());
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(result.toString().getBytes());
            byte[] bytes = md.digest();
            StringBuilder toString = new StringBuilder();
            for (byte b : bytes) {
                toString.append(Integer.toHexString(b & 0xFF));
            }
            return toString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            Logger.debug("&cFailed to hash cache file using md5 hash.");
            return null;
        }
    }

    public static void createInstance(AreaSpawner plugin) {
        if (instance == null) {
            instance = new RandomSpawnCache(plugin);
        }
    }

    public static RandomSpawnCache getInstance() {
        return instance;
    }
}

