/*
 * Decompiled with CFR 0.152.
 */
package com.popupmc.areaspawner.events;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.User;
import com.popupmc.areaspawner.AreaSpawner;
import com.popupmc.areaspawner.spawn.RandomSpawnCache;
import com.popupmc.areaspawner.utils.Logger;
import com.popupmc.areaspawner.utils.Settings;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class PlayerDieEvent
implements Listener {
    private final AreaSpawner plugin;

    public PlayerDieEvent(AreaSpawner plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerDeath(PlayerRespawnEvent event) {
        Settings settings = Settings.getInstance();
        Player player = event.getPlayer();
        if (settings.isSpawnOnDeath()) {
            if (!event.isBedSpawn() || !settings.isSpawnOnBed()) {
                if (settings.isEssentialsHomeOnRespawn() && !((Essentials)Bukkit.getPluginManager().getPlugin("Essentials")).getUser(player).getHomes().isEmpty()) {
                    User user = ((Essentials)Bukkit.getPluginManager().getPlugin("Essentials")).getUser(player);
                    try {
                        Location home = user.getHome((String)user.getHomes().get(0));
                        player.teleport(home, PlayerTeleportEvent.TeleportCause.PLUGIN);
                        Logger.send((CommandSender)player, this.plugin.getMessagesYaml().getAccess().getString("messages.teleported to home"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (settings.isNotUseAutomaticPermission() || event.getPlayer().hasPermission("areaSpawner.automatic")) {
                    event.setRespawnLocation(RandomSpawnCache.getInstance().getSafeSpawn());
                    Logger.send((CommandSender)event.getPlayer(), this.plugin.getMessagesYaml().getAccess().getString("messages.you have been teleported"));
                }
            } else {
                Logger.send((CommandSender)event.getPlayer(), this.plugin.getMessagesYaml().getAccess().getString("messages.teleported to bed"));
            }
        }
    }
}

