/*
 * Decompiled with CFR 0.152.
 */
package com.popupmc.areaspawner.commands;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.User;
import com.popupmc.areaspawner.AreaSpawner;
import com.popupmc.areaspawner.spawn.RandomSpawnCache;
import com.popupmc.areaspawner.utils.Logger;
import com.popupmc.areaspawner.utils.Settings;
import com.popupmc.areaspawner.utils.TimeUnit;
import com.popupmc.areaspawner.utils.TravelCooldownManager;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class TravelCommand
implements CommandExecutor {
    private final AreaSpawner plugin;
    private String commandList;
    private String noPerm;
    private String unknown;
    private String travelDisabled;
    private String inCooldown;
    private String notEnoughMoney;
    private String charged;
    private String permissionRemoved;
    private String essentialsHomeSet;
    private String teleported;
    private String invalidPlayer;
    private String teleportedPlayer;

    public TravelCommand(AreaSpawner plugin) {
        this.plugin = plugin;
        this.loadMessages();
    }

    public void loadMessages() {
        FileConfiguration messages = this.plugin.getMessagesYaml().getAccess();
        this.commandList = messages.getString("messages.list of commands");
        this.noPerm = messages.getString("messages.no permission");
        this.unknown = messages.getString("messages.unknown command");
        this.travelDisabled = messages.getString("messages.travel disabled");
        this.inCooldown = messages.getString("messages.still in cooldown");
        this.notEnoughMoney = messages.getString("messages.not enough money");
        this.charged = messages.getString("messages.charged");
        this.permissionRemoved = messages.getString("messages.travel permission removed");
        this.essentialsHomeSet = messages.getString("messages.essentials home set");
        this.teleported = messages.getString("messages.you have been teleported");
        this.invalidPlayer = messages.getString("messages.invalid player");
        this.teleportedPlayer = messages.getString("messages.player has been teleported");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 0 || args[0].equalsIgnoreCase("help")) {
            Logger.send(sender, this.commandList);
            Logger.send(sender, "&f/" + label + " help");
            Logger.send(sender, "&f/" + label + " travel");
            Logger.send(sender, "&f/" + label + " forceTravel (player)");
        } else if (args[0].equalsIgnoreCase("travel")) {
            Settings settings = Settings.getInstance();
            if (sender instanceof ConsoleCommandSender) {
                Logger.send("&cThat command should only be executed by a player.");
                return true;
            }
            FileConfiguration config = this.plugin.getConfig();
            if (!settings.isTravelEnabled()) {
                Logger.send(sender, this.travelDisabled);
                return true;
            }
            if (!sender.hasPermission("areaSpawner.travel")) {
                Logger.send(sender, this.noPerm);
                return true;
            }
            TravelCooldownManager tcm = TravelCooldownManager.getInstance();
            long timeLeft = tcm.getTimeLeft(sender.getName());
            if (timeLeft > 0L && !sender.hasPermission("areaSpawner.cooldown.bypass")) {
                Logger.send(sender, this.inCooldown.replace("%time%", TimeUnit.getTimeString(timeLeft / 50L)));
                return true;
            }
            Player player = (Player)sender;
            int travelPrice = config.getInt("travel cost");
            if (this.plugin.setupEconomy() && travelPrice > 0) {
                Economy econ = this.plugin.getEconomy();
                double balance = econ.getBalance((OfflinePlayer)player);
                if ((double)travelPrice > balance) {
                    Logger.send(sender, this.notEnoughMoney.replace("%amount%", String.valueOf(travelPrice)));
                    return true;
                }
                econ.withdrawPlayer((OfflinePlayer)player, (double)travelPrice);
                Logger.send(sender, this.charged.replace("%price%", String.valueOf(travelPrice)));
            }
            Location location = RandomSpawnCache.getInstance().getSafeSpawn();
            player.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
            Logger.send((CommandSender)player, this.teleported);
            tcm.addToCooldown(sender.getName());
            if (!player.isOp() && settings.isRemovePermissionOnTravel() && this.plugin.getPerms() != null) {
                this.plugin.getPerms().playerRemove(player, "areaSpawner.travel");
                Logger.send(sender, this.permissionRemoved);
            }
            if (settings.isEssentialsSetHomeOnTravel()) {
                User user = ((Essentials)JavaPlugin.getPlugin(Essentials.class)).getUser(player);
                if (user.getHomes().isEmpty()) {
                    user.setHome(settings.getTravelHomeName(), location);
                    Logger.debug("&eEssentials home set for " + player.getName() + ".");
                    Logger.send(sender, this.essentialsHomeSet);
                } else {
                    Logger.debug("&eAn essentials home has not been set for " + player.getName() + " on travel because the player already has at least one home set.");
                }
            }
        } else if (args[0].equalsIgnoreCase("forceTravel")) {
            if (!sender.hasPermission("areaSpawner.forceTravel")) {
                Logger.send(sender, this.noPerm);
                return true;
            }
            if (args.length < 2) {
                Logger.send(sender, "&cUse: " + label + " forceTravel (player)");
                return true;
            }
            Player toTeleport = Bukkit.getPlayer((String)args[1]);
            if (toTeleport == null) {
                Logger.send(sender, this.invalidPlayer);
                return true;
            }
            RandomSpawnCache.getInstance().teleport(toTeleport);
            Logger.send(sender, this.teleportedPlayer.replace("%player%", args[1]));
        } else {
            Logger.send(sender, this.unknown.replace("%command%", label));
        }
        return true;
    }
}

