/*
 * Decompiled with CFR 0.152.
 */
package com.popupmc.areaspawner.commands;

import com.popupmc.areaspawner.AreaSpawner;
import com.popupmc.areaspawner.spawn.RandomSpawnCache;
import com.popupmc.areaspawner.utils.Logger;
import com.popupmc.areaspawner.utils.Settings;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;

public final class MainCommand
implements CommandExecutor {
    private final AreaSpawner plugin;
    private String configFieldsHash;
    private String noPerm;
    private String unknown;
    private String reloaded;
    private String regenerating;
    private String locationsStored;
    private String commandList;

    public MainCommand(AreaSpawner plugin) {
        this.plugin = plugin;
        this.loadMessages();
        this.configFieldsHash = this.getMDHash();
    }

    private void loadMessages() {
        FileConfiguration messages = this.plugin.getMessagesYaml().getAccess();
        this.commandList = messages.getString("messages.list of commands");
        this.noPerm = messages.getString("messages.no permission");
        this.unknown = messages.getString("messages.unknown command");
        this.reloaded = messages.getString("messages.reloaded");
        this.regenerating = messages.getString("messages.regenerating");
        this.locationsStored = messages.getString("messages.number of locations");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 0 || args[0].equalsIgnoreCase("help")) {
            Logger.send(sender, this.commandList);
            Logger.send(sender, "&f/randomSpawn");
            Logger.send(sender, "&f/" + label + " help");
            Logger.send(sender, "&f/" + label + " version");
            Logger.send(sender, "&f/" + label + " reload");
            Logger.send(sender, "&f/" + label + " regenerate");
            Logger.send(sender, "&f/" + label + " locations");
            Logger.send(sender, "&f/" + label + " stopCache");
        } else if (args[0].equalsIgnoreCase("version")) {
            if (!sender.hasPermission("areaSpawner.version")) {
                Logger.send(sender, this.noPerm);
                return true;
            }
            if (!this.plugin.getVersion().equals(this.plugin.getLatestVersion())) {
                Logger.send("&fVersion: &e" + this.plugin.getVersion() + "&f. &cUpdate available!");
                Logger.send("&fDownload here: http://bit.ly/areaSpawnerUpdate");
                return true;
            }
            Logger.send(sender, "&fVersion: &e" + this.plugin.getVersion() + "&f. &aUp to date!");
        } else if (args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("areaSpawner.reload")) {
                Logger.send(sender, this.noPerm);
                return true;
            }
            this.plugin.reload();
            this.loadMessages();
            Logger.send(sender, this.reloaded);
            if (Settings.getInstance().isCacheEnabled() && !this.getMDHash().equals(this.configFieldsHash)) {
                Logger.send(sender, "&cChanges in location/cache detected. Regenerating cached locations.");
                RandomSpawnCache.getInstance().createSafeSpawns(true);
                this.configFieldsHash = this.getMDHash();
            }
        } else if (args[0].equalsIgnoreCase("regenerate")) {
            if (!sender.hasPermission("areaSpawner.regenerate")) {
                Logger.send(sender, this.noPerm);
                return true;
            }
            Logger.send(sender, this.regenerating);
            RandomSpawnCache.getInstance().createSafeSpawns(true);
        } else if (args[0].equalsIgnoreCase("locations")) {
            if (!sender.hasPermission("areaSpawner.locations")) {
                Logger.send(sender, this.noPerm);
                return true;
            }
            Logger.send(sender, this.locationsStored.replace("%locations%", String.valueOf(RandomSpawnCache.getInstance().getLocationsInCache())));
        } else if (args[0].equalsIgnoreCase("stopCache")) {
            if (!sender.hasPermission("areaSpawner.stopCache")) {
                Logger.send(sender, this.noPerm);
                return true;
            }
            RandomSpawnCache rsp = RandomSpawnCache.getInstance();
            int locations = rsp.getLocationsInCache();
            if (rsp.stopCache()) {
                Logger.send(sender, "&aThe cache process will be stopped when it is finished with the current location");
                Logger.send(sender, "&eThere are currently " + locations + " locations saved in cache.");
            } else {
                Logger.send(sender, "&cThe cache process was not running or it is already stopping.");
            }
        } else {
            Logger.send(sender, this.unknown.replace("%command%", label));
        }
        return true;
    }

    private String getMDHash() {
        String[] keys;
        StringBuilder result = new StringBuilder();
        for (String key : keys = new String[]{"spawn world", "spawn zone.clamp to limits", "spawn zone.default to multiverse", "spawn zone.x center", "spawn zone.y center", "spawn zone.z center", "spawn zone.x range", "spawn zone.y range", "spawn zone.z range", "no spawn zone.enabled", "no spawn zone.x range", "no spawn zone.z range", "amount of cached spawns"}) {
            result.append(this.plugin.getConfig().get(key));
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(result.toString().getBytes());
            byte[] bytes = md.digest();
            StringBuilder toString = new StringBuilder();
            for (byte b : bytes) {
                toString.append(Integer.toHexString(b & 0xFF));
            }
            return toString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
    }
}

