/*
 * Decompiled with CFR 0.152.
 */
package com.popupmc.areaspawner;

import com.popupmc.areaspawner.commands.MainCommand;
import com.popupmc.areaspawner.commands.MainCommandTabAutoCompleter;
import com.popupmc.areaspawner.commands.TravelCommand;
import com.popupmc.areaspawner.commands.TravelCommandTabAutoCompleter;
import com.popupmc.areaspawner.events.FirstJoinEvent;
import com.popupmc.areaspawner.events.PlayerDieEvent;
import com.popupmc.areaspawner.events.PlayerJoinUpdateCheck;
import com.popupmc.areaspawner.spawn.RandomSpawnCache;
import com.popupmc.areaspawner.utils.Logger;
import com.popupmc.areaspawner.utils.Settings;
import com.popupmc.areaspawner.utils.TravelCooldownManager;
import com.popupmc.areaspawner.utils.YamlFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class AreaSpawner
extends JavaPlugin {
    private final PluginDescriptionFile pdfFile = this.getDescription();
    private final String version = this.pdfFile.getVersion();
    private String latestVersion;
    private final char color = (char)101;
    private final String name = "&f[&e" + this.pdfFile.getName() + "&f]";
    private TravelCommand travelCommand;
    private Economy econ;
    private Permission perms;
    private YamlFile configYaml;
    private YamlFile messagesYaml;
    private YamlFile cacheYaml;
    private YamlFile cooldownYaml;

    private void send(String msg) {
        Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.name + " " + msg)));
    }

    public void onEnable() {
        this.send("&aEnabled&f. Version: &e" + this.version);
        this.send("&fThank you for using my plugin! &e" + this.pdfFile.getName() + "&f By " + (String)this.pdfFile.getAuthors().get(0));
        this.send("&fJoin my discord server at &chttps://discordapp.com/invite/ZznhQud");
        this.send("Please consider subscribing to my yt channel: &c" + this.pdfFile.getWebsite());
        this.reloadFiles();
        this.checkFilesFields();
        Settings.createInstance(this);
        this.checkDangerousSettings();
        RandomSpawnCache.createInstance(this);
        TravelCooldownManager.createInstance(this);
        if (this.setupEconomy()) {
            Logger.send("&aEconomy hooked successfully.");
        } else {
            Logger.send("&cVault or a vault supported economy plugin has not been found.");
            Logger.send("&cEconomy features disabled.");
        }
        if (this.setupPermissions()) {
            Logger.send("&aPermissions hooked successfully.");
        } else {
            Logger.send("&cVault or a vault supported permissions plugin has not been found.");
            Logger.send("&cPermissions features disabled.");
        }
        this.registerEvents();
        this.registerCommands();
        this.updateChecker();
    }

    public void onDisable() {
        if (RandomSpawnCache.getInstance() != null) {
            RandomSpawnCache.getInstance().saveToFile();
        }
        this.send("&cDisabled&f. Version: &e" + this.version);
        this.send("&fThank you for using my plugin! &e" + this.pdfFile.getName() + "&f By " + (String)this.pdfFile.getAuthors().get(0));
        this.send("&fJoin my discord server at &chttps://discordapp.com/invite/ZznhQud");
        this.send("Please consider subscribing to my yt channel: &c" + this.pdfFile.getWebsite());
    }

    public boolean setupEconomy() {
        Plugin vault = this.getServer().getPluginManager().getPlugin("Vault");
        if (vault == null || !vault.isEnabled()) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.econ = (Economy)rsp.getProvider();
        return true;
    }

    public boolean setupPermissions() {
        Plugin vault = this.getServer().getPluginManager().getPlugin("Vault");
        if (vault == null || !vault.isEnabled()) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Permission.class);
        if (rsp == null) {
            return false;
        }
        this.perms = (Permission)rsp.getProvider();
        return true;
    }

    private void updateChecker() {
        try {
            HttpURLConnection con = (HttpURLConnection)new URL("https://api.spigotmc.org/legacy/update.php?resource=88263").openConnection();
            int timed_out = 1250;
            con.setConnectTimeout(1250);
            con.setReadTimeout(1250);
            this.latestVersion = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
            if (this.latestVersion.length() <= 7 && !this.version.equals(this.latestVersion)) {
                String exclamation = "&e&l(&4&l!&e&l)";
                this.send(exclamation + " &cThere is a new version available. &e(&7" + this.latestVersion + "&e)");
                this.send(exclamation + " &cDownload it here: &fhttp://bit.ly/areaSpawnerUpdate");
            }
        }
        catch (Exception ex) {
            this.send("&cThere was an error while checking for updates");
        }
    }

    public String getVersion() {
        return this.version;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public void reloadFiles() {
        this.configYaml = new YamlFile(this, "config.yml");
        this.messagesYaml = new YamlFile(this, "messages.yml");
        this.cacheYaml = new YamlFile(this, "cache.yml");
        this.cooldownYaml = new YamlFile(this, "travel cooldown.yml");
    }

    public void reload() {
        this.reloadFiles();
        Settings.getInstance().reloadFields();
        RandomSpawnCache.getInstance().reValidateSpawns();
        this.checkDangerousSettings();
        this.travelCommand.loadMessages();
    }

    private void checkFilesFields() {
        YamlConfiguration messagesEndFile = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "messages.yml"));
        FileConfiguration messages = this.getMessagesYaml().getAccess();
        if (!messagesEndFile.contains("messages.teleported to home")) {
            messages.set("messages.teleported to home", (Object)"&aYou have been teleported to your essentials home.");
            this.messagesYaml.save();
        }
        YamlConfiguration configEndFile = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "config.yml"));
        FileConfiguration config = this.getConfigYaml().getAccess();
        if (!configEndFile.contains("time between location attempts")) {
            config.set("time between location attempts", (Object)"5T");
            this.configYaml.save();
        }
    }

    private void registerEvents() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new FirstJoinEvent(this), (Plugin)this);
        pm.registerEvents((Listener)new PlayerDieEvent(this), (Plugin)this);
        pm.registerEvents((Listener)new PlayerJoinUpdateCheck(this), (Plugin)this);
    }

    private void registerCommands() {
        PluginCommand mainCommand = this.getCommand("areaSpawner");
        PluginCommand travelCommand = this.getCommand("randomSpawn");
        if (mainCommand == null || travelCommand == null) {
            this.send("&cERROR while registering plugin commands. Please check your plugin.yml file is correct.");
            this.send("&cDisabling the plugin.");
            this.setEnabled(false);
            return;
        }
        mainCommand.setExecutor((CommandExecutor)new MainCommand(this));
        mainCommand.setTabCompleter((TabCompleter)new MainCommandTabAutoCompleter());
        this.travelCommand = new TravelCommand(this);
        travelCommand.setExecutor((CommandExecutor)this.travelCommand);
        travelCommand.setTabCompleter((TabCompleter)new TravelCommandTabAutoCompleter());
    }

    public void checkDangerousSettings() {
        Settings fields = Settings.getInstance();
        if (fields.getWorldName() == null || fields.getWorld() == null) {
            this.send("&cERROR &f- World is null, please check your world name in config");
            this.send("&fDisabling AreaSpawner...");
            this.setEnabled(false);
            return;
        }
        if (fields.getForbiddenRegion().contains(fields.getAllowedRegion())) {
            this.send("&cERROR &f- The safe region spawn is inside and smaller than the forbidden region spawn");
            this.send("&fDisabling AreaSpawner...");
            this.setEnabled(false);
            return;
        }
        if (!this.getConfig().getBoolean("spawn zone.clamp to limits")) {
            this.send("&eWARNING &f- Clamp to limits is set to false in config, players may be able to spawn off limits in some cases.");
        }
        if (fields.getAirGapAbove() < 2) {
            this.send("&eWARNING &f- Air gap above is set to a value lower than 2 (player height), players may suffocate in walls.");
        }
        if (!fields.isCacheEnabled()) {
            this.send("&eWARNING &f- Location cache is disabled. Locations will be calculated on the spot, players may take a while to respawn depending on your other settings.");
        }
        if (!fields.isCheckSafetyOnUse()) {
            this.send("&eWARNING &f- Locations' safety is not checked once again on use. Players might be teleported to unsafe locations that were considered safe.");
        }
    }

    public Economy getEconomy() {
        return this.econ;
    }

    public Permission getPerms() {
        return this.perms;
    }

    @NotNull
    public FileConfiguration getConfig() {
        return this.getConfigYaml().getAccess();
    }

    public YamlFile getConfigYaml() {
        return this.configYaml;
    }

    public YamlFile getMessagesYaml() {
        return this.messagesYaml;
    }

    public YamlFile getCacheYaml() {
        return this.cacheYaml;
    }

    public YamlFile getCooldownYaml() {
        return this.cooldownYaml;
    }
}

