/*
 * Decompiled with CFR 0.152.
 */
package me.mazenz.saulconomy.vault;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.mazenz.saulconomy.Database;
import me.mazenz.saulconomy.vault.BaseVaultImplementation;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;

public class SaulVaultEconomy
implements BaseVaultImplementation {
    private static final EconomyResponse NOT_IMPLEMENTED = new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Not implemented");
    private final Database db;

    public SaulVaultEconomy(Database db) {
        this.db = db;
    }

    @Override
    public boolean isEnabled() {
        return this.db.isOpen();
    }

    @Override
    public String getName() {
        return "SaulConomy";
    }

    @Override
    public boolean hasBankSupport() {
        return false;
    }

    @Override
    public int fractionalDigits() {
        return -1;
    }

    @Override
    public String format(double amount) {
        return Double.toString(amount);
    }

    @Override
    public String currencyNamePlural() {
        return "Dollars";
    }

    @Override
    public String currencyNameSingular() {
        return "Dollar";
    }

    @Override
    public boolean hasAccount(OfflinePlayer offlinePlayer) {
        boolean bl;
        block8: {
            ResultSet resultSet = this.db.result("SELECT * FROM economy WHERE uuid = ?", s -> s.setString(1, offlinePlayer.getUniqueId().toString()));
            try {
                bl = resultSet.next();
                if (resultSet == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException exception) {
                    this.db.report(exception);
                    return false;
                }
            }
            resultSet.close();
        }
        return bl;
    }

    /*
     * Loose catch block
     */
    @Override
    public double getBalance(OfflinePlayer player) {
        double d;
        block12: {
            ResultSet resultSet;
            block10: {
                double d2;
                block11: {
                    resultSet = this.db.result("SELECT balance FROM economy WHERE uuid = ?", s -> s.setString(1, player.getUniqueId().toString()));
                    if (!resultSet.next()) break block10;
                    d2 = resultSet.getDouble(1);
                    if (resultSet == null) break block11;
                    resultSet.close();
                }
                return d2;
            }
            d = 0.0;
            if (resultSet == null) break block12;
            {
                catch (Throwable throwable) {
                    try {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException exception) {
                        this.db.report(exception);
                        return 0.0;
                    }
                }
            }
            resultSet.close();
        }
        return d;
    }

    @Override
    public boolean has(OfflinePlayer player, double amount) {
        return this.getBalance(player) >= amount;
    }

    @Override
    public EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        return this.setBalance(player, this.getBalance(player) - amount);
    }

    @Override
    public EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        return this.setBalance(player, this.getBalance(player) + amount);
    }

    @Override
    public EconomyResponse createBank(String name, OfflinePlayer player) {
        return NOT_IMPLEMENTED;
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        return NOT_IMPLEMENTED;
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        return NOT_IMPLEMENTED;
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        return NOT_IMPLEMENTED;
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        return NOT_IMPLEMENTED;
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        return NOT_IMPLEMENTED;
    }

    @Override
    public EconomyResponse isBankOwner(String name, OfflinePlayer player) {
        return NOT_IMPLEMENTED;
    }

    @Override
    public EconomyResponse isBankMember(String name, OfflinePlayer player) {
        return NOT_IMPLEMENTED;
    }

    @Override
    public List<String> getBanks() {
        return Collections.emptyList();
    }

    @Override
    public boolean createPlayerAccount(OfflinePlayer player) {
        boolean bl;
        block8: {
            PreparedStatement statement = this.db.statement("INSERT OR IGNORE INTO economy VALUES (?, ?)", s -> {
                s.setString(1, player.getUniqueId().toString());
                s.setDouble(2, 0.0);
            });
            try {
                boolean bl2 = bl = statement.executeUpdate() > 0;
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException exception) {
                    this.db.report(exception);
                    return false;
                }
            }
            statement.close();
        }
        return bl;
    }

    public EconomyResponse setBalance(OfflinePlayer player, double balance) {
        if (balance < 0.0) {
            return new EconomyResponse(balance, balance, EconomyResponse.ResponseType.FAILURE, "Negative balance");
        }
        this.createPlayerAccount(player);
        try (PreparedStatement statement = this.db.statement("UPDATE economy SET balance = ? WHERE uuid = ?", s -> {
            s.setDouble(1, balance);
            s.setString(2, player.getUniqueId().toString());
        });){
            statement.executeUpdate();
        }
        catch (SQLException exception) {
            this.db.report(exception);
        }
        return new EconomyResponse(balance, balance, EconomyResponse.ResponseType.SUCCESS, "");
    }

    public Map<UUID, Double> balTop() {
        LinkedHashMap<UUID, Double> top = new LinkedHashMap<UUID, Double>();
        try (ResultSet resultSet = this.db.result("SELECT * FROM economy ORDER BY balance DESC", s -> {});){
            while (resultSet.next()) {
                top.put(UUID.fromString(resultSet.getString(1)), resultSet.getDouble(2));
            }
        }
        catch (SQLException exception) {
            this.db.report(exception);
        }
        return top;
    }
}

