/*
 * Decompiled with CFR 0.152.
 */
package me.mazenz.saulconomy;

import java.sql.SQLException;
import java.util.logging.Logger;
import me.mazenz.saulconomy.Database;
import me.mazenz.saulconomy.UpdateChecker;
import me.mazenz.saulconomy.commands.Balance;
import me.mazenz.saulconomy.commands.Baltop;
import me.mazenz.saulconomy.commands.Pay;
import me.mazenz.saulconomy.commands.Saul;
import me.mazenz.saulconomy.commands.SetBalance;
import me.mazenz.saulconomy.vault.SaulVaultEconomy;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Consumer;

public class SaulConomy
extends JavaPlugin {
    private Database db;

    public void onEnable() {
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        Logger logger = this.getLogger();
        new UpdateChecker(this, 88223).getVersion((Consumer<String>)((Consumer)version -> {
            logger.info("Checking for Updates...");
            if (this.getDescription().getVersion().equalsIgnoreCase((String)version)) {
                logger.info("No new version available");
            } else {
                logger.info("There is a new version of SaulConomy. https://www.spigotmc.org/resources/saulconomy.88223/");
            }
        }));
        this.db = new Database(this);
        this.db.load();
        SaulVaultEconomy economy = new SaulVaultEconomy(this.db);
        Bukkit.getServicesManager().register(Economy.class, (Object)economy, (Plugin)this, ServicePriority.Normal);
        this.getCommand("balance").setExecutor((CommandExecutor)new Balance(economy, this));
        this.getCommand("setbalance").setExecutor((CommandExecutor)new SetBalance(economy, this));
        this.getCommand("pay").setExecutor((CommandExecutor)new Pay(economy, this));
        this.getCommand("saul").setExecutor((CommandExecutor)new Saul(this));
        this.getCommand("baltop").setExecutor((CommandExecutor)new Baltop(economy, this));
    }

    public void onDisable() {
        try {
            this.db.getConnection().close();
        }
        catch (SQLException exception) {
            this.db.report(exception);
        }
    }
}

