/*
 * Decompiled with CFR 0.152.
 */
package me.mazenz.saulconomy;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import me.mazenz.saulconomy.SaulConomy;
import org.bukkit.ChatColor;
import org.intellij.lang.annotations.Language;

public class Database {
    private final SaulConomy plugin;
    private Connection connection;

    public Database(SaulConomy instance) {
        this.plugin = instance;
    }

    public Connection getConnection() {
        if (this.isOpen()) {
            return this.connection;
        }
        File database = new File(this.plugin.getDataFolder(), "economy.db");
        try {
            database.getParentFile().mkdirs();
            database.createNewFile();
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "File write error: economy.db");
        }
        try {
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + database);
            return this.connection;
        }
        catch (ClassNotFoundException | SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "SQLite exception on initialize", ex);
            return null;
        }
    }

    public void load() {
        this.connection = this.getConnection();
        try (Statement s = this.connection.createStatement();){
            s.executeUpdate("CREATE TABLE IF NOT EXISTS economy (`uuid` varchar(32) NOT NULL, `balance` double(1000) NOT NULL, PRIMARY KEY (`uuid`));");
        }
        catch (SQLException exception) {
            this.report(exception);
        }
    }

    public boolean isOpen() {
        if (this.connection == null) {
            return false;
        }
        try {
            return !this.connection.isClosed();
        }
        catch (SQLException exception) {
            return false;
        }
    }

    public PreparedStatement statement(@Language(value="SQLite") String query, Initializer initializer) throws SQLException {
        PreparedStatement statement = this.getConnection().prepareStatement(query);
        initializer.apply(statement);
        return statement;
    }

    public ResultSet result(@Language(value="SQLite") String query, Initializer initializer) throws SQLException {
        return this.statement(query, initializer).executeQuery();
    }

    public void report(SQLException exception) {
        this.plugin.getLogger().log(Level.SEVERE, ChatColor.RED + "Unhandled exception: " + exception.getMessage(), exception);
    }

    public static interface Initializer {
        public void apply(PreparedStatement var1) throws SQLException;
    }
}

