/*
 * Decompiled with CFR 0.152.
 */
package uk.co.samuelzcloud.dev.plugins.BiomeSelector;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import uk.co.samuelzcloud.dev.plugins.BiomeSelector.a.a;
import uk.co.samuelzcloud.dev.plugins.BiomeSelector.b.b;
import uk.co.samuelzcloud.dev.plugins.BiomeSelector.c.c;
import uk.co.samuelzcloud.dev.plugins.BiomeSelector.c.d;
import uk.co.samuelzcloud.dev.plugins.BiomeSelector.c.e;
import uk.co.samuelzcloud.dev.plugins.BiomeSelector.c.g;
import uk.co.samuelzcloud.dev.plugins.BiomeSelector.c.i;
import uk.co.samuelzcloud.dev.plugins.BiomeSelector.c.j;

public class BiomeSelector
extends JavaPlugin {
    private static BiomeSelector instance;
    private PluginManager manager;
    private e log;
    private d config;
    private j updateChecker;
    private c cooldownManager;
    private uk.co.samuelzcloud.dev.plugins.BiomeSelector.c.b biomesStore;
    private File configFile;
    private File biomesFile;
    private HashMap<UUID, Inventory> biomeViewers;
    private Economy economy;

    public void onEnable() {
        instance = this;
        File file = new File(this.getDataFolder().getAbsolutePath());
        file.mkdirs();
        this.configFile = new File(file, "config.yml");
        this.biomesFile = new File(file, "biomes.yml");
        this.manager = this.getServer().getPluginManager();
        this.log = new e(this);
        this.config = new d();
        this.updateChecker = new j(this, 8821);
        this.cooldownManager = new c(this, this.getCustomConfig().d("CooldownSeconds"));
        this.biomesStore = new uk.co.samuelzcloud.dev.plugins.BiomeSelector.c.b();
        this.biomeViewers = new HashMap();
        if (this.getCustomConfig().j("UseEconomy") && !this.setupVaultHookIn().booleanValue() && this.getEconomy() == null) {
            this.getLog().f("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            this.getLog().f("!!!!! ERROR:  No Vault dependency was found! !!!!!");
            this.getLog().f("!!! (If you have Vault, and see this message,  !!!");
            this.getLog().f("!!!   it means you need an economy plugin!)    !!!");
            this.getLog().d("!!!   BiomeSelector will NOT use economy! !!!");
            this.getLog().f("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            this.getLog().f("Vault project page; http://dev.bukkit.org/bukkit-plugins/vault/");
            this.getCustomConfig().a("UseEconomy", false);
            return;
        }
        this.getCommand("biomeselector").setExecutor((CommandExecutor)new uk.co.samuelzcloud.dev.plugins.BiomeSelector.a.b(this));
        this.getCommand("biomeselector").setTabCompleter((TabCompleter)new uk.co.samuelzcloud.dev.plugins.BiomeSelector.a.b(this));
        this.getCommand("biomes").setExecutor((CommandExecutor)new a(this));
        this.getCommand("biomes").setTabCompleter((TabCompleter)new a(this));
        this.getManager().registerEvents((Listener)new b(this), (Plugin)this);
        this.getManager().registerEvents((Listener)new uk.co.samuelzcloud.dev.plugins.BiomeSelector.b.a(this), (Plugin)this);
        this.getManager().registerEvents((Listener)new uk.co.samuelzcloud.dev.plugins.BiomeSelector.b.c(this), (Plugin)this);
        this.setupMetrics();
        this.checkUpdates();
    }

    public void onDisable() {
        for (UUID uUID : this.getBiomeViewers().keySet()) {
            Player player = this.getServer().getPlayer(uUID);
            if (player == null) continue;
            player.closeInventory();
            this.getBiomeViewers().remove(uUID);
        }
    }

    public PluginManager getManager() {
        return this.manager;
    }

    public e getLog() {
        return this.log;
    }

    public d getCustomConfig() {
        return this.config;
    }

    public j getUpdateChecker() {
        return this.updateChecker;
    }

    public uk.co.samuelzcloud.dev.plugins.BiomeSelector.c.b getBiomesStore() {
        return this.biomesStore;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public File getBiomesFile() {
        return this.biomesFile;
    }

    public HashMap<UUID, Inventory> getBiomeViewers() {
        return this.biomeViewers;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public c getCooldownManager() {
        return this.cooldownManager;
    }

    private void setupMetrics() {
        g g2 = new g((Plugin)this);
        if (g2.a()) {
            this.getLog().d("The metrics system has been started!");
        }
    }

    private Boolean setupVaultHookIn() {
        if (this.manager.getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider registeredServiceProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (registeredServiceProvider == null) {
            return false;
        }
        this.economy = (Economy)registeredServiceProvider.getProvider();
        return this.economy != null;
    }

    private void checkUpdates() {
        if (this.getCustomConfig().j("UpdateChecker")) {
            this.getUpdateChecker().e();
            switch (1.a[this.getUpdateChecker().a().ordinal()]) {
                case 1: {
                    this.getLog().d("There is a update ready to be downloaded! Current version is " + this.getUpdateChecker().b() + ", update is " + this.getUpdateChecker().c());
                    break;
                }
                case 2: {
                    this.getLog().d("No updates found - latest is " + this.getUpdateChecker().c());
                    break;
                }
                case 3: {
                    this.getLog().f("You're using a DEV BUILD! This MAY contain bugs! Using " + this.getUpdateChecker().b() + ", latest STABLE version is " + this.getUpdateChecker().c());
                    break;
                }
                case 4: {
                    this.getLog().e("Unable to check for updates due to API failure.");
                    break;
                }
                case 5: {
                    this.getLog().e("Unable to check for updates due to API failure.");
                }
            }
        }
    }

    public uk.co.samuelzcloud.dev.plugins.BiomeSelector.c.a getBiomeItemFromWarpName(String string) {
        ConfigurationSection configurationSection = this.getBiomesStore().a("Biomes");
        if (configurationSection == null || configurationSection.getKeys(false).size() == 0) {
            return null;
        }
        for (String string2 : configurationSection.getKeys(false)) {
            uk.co.samuelzcloud.dev.plugins.BiomeSelector.c.a a2;
            if (!configurationSection.contains(string2) || !(a2 = this.getBiomeItem(Integer.parseInt(string2))).g().equalsIgnoreCase(string)) continue;
            return a2;
        }
        return null;
    }

    public uk.co.samuelzcloud.dev.plugins.BiomeSelector.c.a getBiomeItem(int n) {
        Location location;
        Material material;
        ConfigurationSection configurationSection = this.getBiomesStore().a("Biomes." + n);
        String string = configurationSection.getString("Material");
        if (string == null || string.equalsIgnoreCase("")) {
            string = "BARRIER";
        }
        if ((material = Material.getMaterial((String)string.toUpperCase())) == null || new ItemStack(material, 1) == null) {
            material = Material.BARRIER;
            this.getLog().f("MATERIAL ERROR - biome " + configurationSection.getStringList("Warp_Name") + " has invalid material name set for icon: " + string);
        }
        ItemStack itemStack = new ItemStack(material, 1);
        double d2 = configurationSection.contains("Price") ? configurationSection.getDouble("Price") : this.getCustomConfig().f("DefaultPrice");
        String string2 = configurationSection.getString("Display_Name");
        List list = configurationSection.getStringList("Lore");
        String string3 = configurationSection.getString("Warp_Name");
        String string4 = configurationSection.getString("Location");
        assert (string4 != null);
        String[] stringArray = string4.split(";");
        if (stringArray.length == 0) {
            return null;
        }
        World world = this.getServer().getWorld(stringArray[0]);
        if (world == null) {
            this.getLog().e("ERROR - the world for " + string3 + " does not exist or is incorrect. (" + stringArray[0] + ")");
            return null;
        }
        if (stringArray.length == 4) {
            double d3 = Double.valueOf(stringArray[1]);
            double d4 = Double.valueOf(stringArray[2]);
            double d5 = Double.valueOf(stringArray[3]);
            location = new Location(world, d3, d4, d5);
        } else if (stringArray.length == 6) {
            double d6;
            double d7;
            double d8;
            double d9;
            double d10 = Double.valueOf(stringArray[1]);
            location = new Location(world, d10, d9 = Double.valueOf(stringArray[2]).doubleValue(), d8 = Double.valueOf(stringArray[3]).doubleValue(), (float)(d7 = Double.valueOf(stringArray[4]).doubleValue()), (float)(d6 = Double.valueOf(stringArray[5]).doubleValue()));
            if (location == null) {
                this.getLog().e("ERROR - error using the configured location for biome: " + string3);
                return null;
            }
        } else {
            this.log.e("Error with location in config. Remember to use this format: WORLD;X;Y;Z;Yaw;Pitch");
            return null;
        }
        return new uk.co.samuelzcloud.dev.plugins.BiomeSelector.c.a(itemStack.getType(), 1, n, string2, string3, location, d2, list);
    }

    public ItemStack createItem(Material material, int n, String string, List<String> list) {
        ItemStack itemStack = new ItemStack(material, n);
        ItemMeta itemMeta = itemStack.getItemMeta();
        assert (itemMeta != null);
        itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)string) + "");
        itemMeta.setLore(this.getLog().a(list));
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_POTION_EFFECTS, ItemFlag.HIDE_UNBREAKABLE, ItemFlag.HIDE_DESTROYS});
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static UUID getUUID(String string) {
        UUID uUID;
        try {
            uUID = new i(Collections.singletonList(string)).a().get(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return uUID;
    }

    public static BiomeSelector getInstance() {
        return instance;
    }
}

