/*
 * Decompiled with CFR 0.152.
 */
package me.dave.structurevoidviewer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.dave.structurevoidviewer.StructureVoidViewer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class UserEvents
implements Listener {
    private final StructureVoidViewer plugin;
    private final HashMap<UUID, List<Location>> playerMap = new HashMap();

    public UserEvents(StructureVoidViewer instance) {
        this.plugin = instance;
        this.displayParticles();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!this.isHoldingStructureVoid(player)) {
            return;
        }
        UUID playerUUID = player.getUniqueId();
        this.playerMap.put(playerUUID, null);
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent event) {
        UUID playerUUID = event.getPlayer().getUniqueId();
        this.playerMap.remove(playerUUID);
    }

    @EventHandler
    public void onItemHoldEvent(PlayerItemHeldEvent event) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            Player player = event.getPlayer();
            if (!this.isHoldingStructureVoid(player)) {
                return;
            }
            UUID playerUUID = player.getUniqueId();
            this.playerMap.put(playerUUID, null);
        }, 1L);
    }

    @EventHandler
    public void onItemMoveEvent(InventoryClickEvent event) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            UUID playerUUID = event.getWhoClicked().getUniqueId();
            Player player = Bukkit.getPlayer((UUID)playerUUID);
            if (player == null || !this.isHoldingStructureVoid(player)) {
                return;
            }
            this.playerMap.put(playerUUID, null);
        }, 1L);
    }

    @EventHandler
    public void onPlayerSwapHandsEvent(PlayerSwapHandItemsEvent event) {
        ItemStack currItem = event.getMainHandItem();
        if (currItem == null || currItem.getType() != Material.STRUCTURE_VOID) {
            return;
        }
        UUID playerUUID = event.getPlayer().getUniqueId();
        this.playerMap.put(playerUUID, null);
    }

    private void displayParticles() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            for (UUID playerUUID : this.playerMap.keySet()) {
                Player player = Bukkit.getPlayer((UUID)playerUUID);
                if (player == null || !this.isHoldingStructureVoid(player)) {
                    this.playerMap.remove(playerUUID);
                    continue;
                }
                List<Location> nearbyStructureVoids = this.getNearbyStructureVoids(player.getLocation(), 5);
                this.playerMap.put(playerUUID, nearbyStructureVoids);
            }
        }, 0L, 20L);
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            for (UUID playerUUID : this.playerMap.keySet()) {
                Player player = Bukkit.getPlayer((UUID)playerUUID);
                if (player == null || !this.isHoldingStructureVoid(player)) {
                    this.playerMap.remove(playerUUID);
                    continue;
                }
                List<Location> locations = this.playerMap.get(playerUUID);
                if (locations == null) continue;
                for (Location location : locations) {
                    if (location.getBlock().getType() != Material.STRUCTURE_VOID) continue;
                    player.spawnParticle(Particle.CRIT_MAGIC, location, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }, 0L, 2L);
    }

    private List<Location> getNearbyStructureVoids(Location location, int radius) {
        ArrayList<Location> locations = new ArrayList<Location>();
        for (int x = location.getBlockX() - radius; x <= location.getBlockX() + radius; ++x) {
            for (int y = location.getBlockY() - radius; y <= location.getBlockY() + radius; ++y) {
                for (int z = location.getBlockZ() - radius; z <= location.getBlockZ() + radius; ++z) {
                    Block currBlock = location.getWorld().getBlockAt(x, y, z);
                    if (currBlock.getType() != Material.STRUCTURE_VOID) continue;
                    locations.add(currBlock.getLocation().clone().add(0.5, 0.5, 0.5));
                }
            }
        }
        return locations;
    }

    private boolean isHoldingStructureVoid(Player player) {
        PlayerInventory inventory = player.getInventory();
        if (inventory.getItemInMainHand().getType() == Material.STRUCTURE_VOID) {
            return true;
        }
        return inventory.getItemInOffHand().getType() == Material.STRUCTURE_VOID;
    }
}

