/*
 * Decompiled with CFR 0.152.
 */
package me.ilayaharoni.manhuntremasterd;

import java.util.Random;
import me.ilayaharoni.manhuntremasterd.PlayerMove;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class ManHuntRemasterd
extends JavaPlugin
implements Listener {
    public PlayerMove move = null;
    int numOfPlayersOnline = this.getServer().getOnlinePlayers().size();
    public Material[] blocksToStandOn = new Material[this.numOfPlayersOnline];
    public Player[] playersOnline = new Player[this.numOfPlayersOnline];
    public int timerMax = 300;

    public void onEnable() {
        this.getLogger().info("started up!");
        this.getLogger().info(this.numOfPlayersOnline + "");
    }

    public void onDisable() {
        this.getLogger().info("Shut down!");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int i;
        Object[] save = this.getServer().getOnlinePlayers().toArray();
        for (i = 0; i < save.length; ++i) {
            this.playersOnline[i] = (Player)save[i];
        }
        if (sender instanceof Player) {
            if (command.getName().equals("blshuffle")) {
                for (i = 0; i < this.numOfPlayersOnline; ++i) {
                    this.blocksToStandOn[i] = this.getRandomBlock();
                }
                i = 0;
                for (Player p : this.playersOnline) {
                    if (this.blocksToStandOn[i] != null) {
                        p.sendMessage(ChatColor.GOLD + "Stand on " + this.castBlockToString(this.blocksToStandOn[i]));
                    }
                    ++i;
                }
                this.move = new PlayerMove(this);
                this.getServer().getPluginManager().registerEvents((Listener)this.move, (Plugin)this);
            }
            if (command.getName().equals("blstand")) {
                Player player = (Player)sender;
                player.sendMessage(ChatColor.GREEN + "You are standing on " + this.getBlockUnderString(player));
                player.sendMessage(ChatColor.GREEN + "You need to stand on " + this.castBlockToString(this.getBlockToStandOnFromPlayer(player)));
            }
            if (command.getName().equals("settimer") && args.length > 0) {
                try {
                    this.timerMax = Integer.parseInt(args[0]);
                    ((Player)sender).sendMessage(ChatColor.YELLOW + "Timer is now set to " + this.timerMax);
                }
                catch (Exception e) {
                    ((Player)sender).sendMessage(ChatColor.DARK_RED + "Hey you need to add a number to set: /<settimer> <number>");
                }
            }
        }
        return false;
    }

    public void reset() {
    }

    public void deletePlayerMove() {
        this.move = null;
    }

    public Player getWinner() {
        for (int i = 0; i < this.numOfPlayersOnline; ++i) {
            if (this.blocksToStandOn[i] != null) continue;
            return this.playersOnline[i];
        }
        return null;
    }

    public int getNumOfPlayersFound() {
        int numOfPlayers = 0;
        for (int i = 0; i < this.numOfPlayersOnline; ++i) {
            if (this.blocksToStandOn[i] != null) continue;
            ++numOfPlayers;
        }
        return numOfPlayers;
    }

    public Player[] allDonePlayer(Player[] playersArr) {
        int length = 0;
        for (int i = 0; i < playersArr.length; ++i) {
            if (this.blocksToStandOn[i] != null) continue;
            ++length;
        }
        Player[] save = new Player[length];
        for (int i = 0; i < playersArr.length; ++i) {
            if (this.blocksToStandOn[i] != null) continue;
            save[i] = this.playersOnline[i];
        }
        return save;
    }

    public Material[] allDoneBlocks(Material[] blocksArr) {
        int length = 0;
        for (int i = 0; i < blocksArr.length; ++i) {
            if (this.blocksToStandOn[i] != null) continue;
            ++length;
        }
        Material[] save = new Material[length];
        for (int i = 0; i < blocksArr.length; ++i) {
            if (this.blocksToStandOn[i] != null) continue;
            save[i] = this.blocksToStandOn[i];
        }
        return save;
    }

    public Material getRandomBlock() {
        Random rnd = new Random();
        int count = rnd.nextInt(145);
        for (Material block : Material.values()) {
            if (block.isBlock() & count != 0) {
                --count;
                continue;
            }
            if (count != 0 || !block.isBlock()) continue;
            return block;
        }
        return null;
    }

    public Material getBlockToStandOnFromPlayer(Player player) {
        for (int i = 0; i < this.numOfPlayersOnline; ++i) {
            if (!this.playersOnline[i].equals(player)) continue;
            return this.blocksToStandOn[i];
        }
        return null;
    }

    public void setBlocksToStandOnNull(Player p) {
        for (int i = 0; i < this.numOfPlayersOnline; ++i) {
            if (!this.playersOnline[i].equals(p)) continue;
            this.blocksToStandOn[i] = null;
        }
    }

    public String getBlockUnderString(Player P) {
        Location blockLocation = P.getLocation();
        blockLocation.setY((double)(blockLocation.getBlockY() - 1));
        String blockUnder = blockLocation.getBlock().getBlockData().toString();
        blockUnder = blockUnder.split("\\{")[1];
        blockUnder = blockUnder.split("\\[")[0];
        blockUnder = blockUnder.split("}")[0];
        return blockUnder;
    }

    public String castBlockToString(Material block) {
        if (block != null) {
            String blockUnder = block.createBlockData().toString();
            blockUnder = blockUnder.split("\\{")[1];
            blockUnder = blockUnder.split("\\[")[0];
            blockUnder = blockUnder.split("}")[0];
            return blockUnder;
        }
        return null;
    }
}

