/*
 * Decompiled with CFR 0.152.
 */
package me.allstarzplays.itemmanagers;

import java.util.ArrayList;
import java.util.List;
import me.allstarzplays.generalmanagers.CompoundAttribute;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Material;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CustomItem {
    private Material item;
    private String name;
    private int damage;
    private short unbreakingLvl;
    private List<String> description;
    private CompoundAttribute modifiers;
    private List<String> info = new ArrayList<String>();

    public CustomItem(Material item, String name, int damage, short unbreakingLvl, List<String> description, CompoundAttribute modifiers) {
        this.item = item;
        this.name = name;
        this.damage = damage;
        this.unbreakingLvl = unbreakingLvl;
        this.description = description;
        this.modifiers = modifiers;
    }

    public CustomItem() {
    }

    public ItemStack create() {
        ItemStack item = new ItemStack(this.getItem());
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(this.getName());
        ArrayList coloredDescription = new ArrayList();
        this.description.forEach(i -> coloredDescription.add(ChatColor.translateAlternateColorCodes((char)'&', (String)i)));
        meta.setLore(coloredDescription);
        int count = 0;
        for (AttributeModifier mod : this.modifiers.getAttributeModifiers()) {
            meta.addAttributeModifier(this.modifiers.getAttributes().get(count), mod);
            ++count;
        }
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        item.setItemMeta(meta);
        return item;
    }

    public Material getItem() {
        return this.item;
    }

    public void setItem(Material item) {
        this.item = item;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getDamage() {
        return this.damage;
    }

    public void setDamage(int damage) {
        this.damage = damage;
    }

    public List<String> getDescription() {
        return this.description;
    }

    public void setDescription(List<String> description) {
        this.description = description;
    }

    public short getUnbreakingLvl() {
        return this.unbreakingLvl;
    }

    public void setUnbreakingLvl(short unbreakingLvl) {
        this.unbreakingLvl = unbreakingLvl;
    }

    public CompoundAttribute getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(CompoundAttribute modifiers) {
        this.modifiers = modifiers;
    }
}

