/*
 * Decompiled with CFR 0.152.
 */
package at.ibizgamer.rtp.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public final class TeleportUtils {
    private static final Set<Material> UNSAFE_MATERIALS = new HashSet<Material>();
    public static final int RADIUS = 3;
    public static final Vector3D[] VOLUME;

    static {
        UNSAFE_MATERIALS.add(Material.LAVA);
        UNSAFE_MATERIALS.add(Material.STATIONARY_LAVA);
        UNSAFE_MATERIALS.add(Material.FIRE);
        ArrayList<Vector3D> pos = new ArrayList<Vector3D>();
        int x = -3;
        while (x <= 3) {
            int y = -3;
            while (y <= 3) {
                int z = -3;
                while (z <= 3) {
                    pos.add(new Vector3D(x, y, z));
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        Collections.sort(pos, new Comparator<Vector3D>(){

            @Override
            public int compare(Vector3D a, Vector3D b) {
                return a.x * a.x + a.y * a.y + a.z * a.z - b.x * b.x + b.y * b.y + b.z * b.z;
            }
        });
        VOLUME = pos.toArray(new Vector3D[0]);
    }

    public static boolean isBlockAboveAir(World world, int x, int y, int z) {
        return y > world.getMaxHeight() || !world.getBlockAt(x, y - 1, z).getType().isSolid();
    }

    public static boolean isBlockUnsafe(World world, int x, int y, int z) {
        Block block = world.getBlockAt(x, y, z);
        Block below = world.getBlockAt(x, y - 1, z);
        Block above = world.getBlockAt(x, y + 1, z);
        return UNSAFE_MATERIALS.contains(below.getType()) || block.getType().isSolid() || above.getType().isSolid() || TeleportUtils.isBlockAboveAir(world, x, y, z);
    }

    public static Location safeizeLocation(Location location) {
        World world = location.getWorld();
        int x = location.getBlockX();
        int y = (int)location.getY();
        int z = location.getBlockZ();
        int origX = x;
        int origY = y;
        int origZ = z;
        location.setY((double)location.getWorld().getHighestBlockYAt(location));
        while (TeleportUtils.isBlockAboveAir(world, x, y, z)) {
            if (--y >= 0) continue;
            y = origY;
            break;
        }
        if (TeleportUtils.isBlockUnsafe(world, x, y, z)) {
            x = Math.round(location.getX()) == (long)origX ? x - 1 : x + 1;
            z = Math.round(location.getZ()) == (long)origZ ? z - 1 : z + 1;
        }
        int i = 0;
        while (TeleportUtils.isBlockUnsafe(world, x, y, z)) {
            if (++i >= VOLUME.length) {
                x = origX;
                y = origY + 3;
                z = origZ;
                break;
            }
            x = origX + TeleportUtils.VOLUME[i].x;
            y = origY + TeleportUtils.VOLUME[i].y;
            z = origZ + TeleportUtils.VOLUME[i].z;
        }
        while (TeleportUtils.isBlockUnsafe(world, x, y, z)) {
            if (++y < world.getMaxHeight()) continue;
            ++x;
            break;
        }
        while (TeleportUtils.isBlockUnsafe(world, x, y, z)) {
            if (--y > 1) continue;
            y = world.getHighestBlockYAt(++x, z);
            if (x - 48 <= location.getBlockX()) continue;
            return null;
        }
        return new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5, location.getYaw(), location.getPitch());
    }

    public static class Vector3D {
        public int x;
        public int y;
        public int z;

        public Vector3D(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

