/*
 * Decompiled with CFR 0.152.
 */
package at.ibizagamer.rtp.handlers;

import at.ibizagamer.rtp.main.Main;
import at.ibizgamer.rtp.utils.TeleportUtils;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class TeleportHandler {
    private final Main plugin;
    private final Player player;
    private final World world;
    private int xCoord = -1;
    private int zCoord = -1;
    private int xF;
    private int yF;
    private int zF;

    public TeleportHandler(Main plugin, Player player, World world, int xCoord, int zCoord) {
        this.plugin = plugin;
        this.player = player;
        this.world = world;
        this.xCoord = xCoord;
        this.zCoord = zCoord;
    }

    public void teleport() {
        Location location = this.getLocation();
        if (location == null) {
            this.player.sendMessage(" ");
            this.player.sendMessage(String.valueOf(Main.prefix) + "\u00a7cEs wurde keine sichere Position gefunden!");
            this.player.sendMessage(String.valueOf(Main.prefix) + "\u00a7cBitte versuche es erneunt...");
            return;
        }
        this.player.teleport(location);
        this.player.sendMessage(" ");
        this.player.sendMessage(String.valueOf(Main.prefix) + "\u00a7aDu wurdest erfolgreich teleportiert!");
        this.player.sendMessage(" ");
        this.player.sendMessage(String.valueOf(Main.prefix) + "\u00a72X: \u00a7a" + this.xF);
        this.player.sendMessage(String.valueOf(Main.prefix) + "\u00a72Y: \u00a7a" + this.yF);
        this.player.sendMessage(String.valueOf(Main.prefix) + "\u00a72Z: \u00a7a" + this.zF);
        this.player.sendMessage(String.valueOf(Main.prefix) + "\u00a72World: \u00a7a" + this.world.getName());
    }

    public int getX() {
        return this.xF;
    }

    public int getY() {
        return this.yF;
    }

    public int getZ() {
        return this.zF;
    }

    private void set(double x, double y, double z) {
        this.xF = (int)x;
        this.yF = (int)y;
        this.zF = (int)z;
    }

    protected Location getLocation() {
        int y;
        int x = this.plugin.getRandom().nextInt(this.xCoord);
        int z = this.plugin.getRandom().nextInt(this.zCoord);
        Location location = TeleportUtils.safeizeLocation(new Location(this.world, (double)(x = this.randomizeType(x)), (double)(y = 63), (double)(z = this.randomizeType(z))));
        if (location == null) {
            return null;
        }
        String block = location.getBlock().getType().toString();
        String biome = location.getBlock().getBiome().toString();
        if (this.plugin.getConfigHandler().getBiomeBlacklist().contains(biome)) {
            location = TeleportUtils.safeizeLocation(this.getLocation());
        }
        if (this.plugin.getConfigHandler().getBlockBlacklist().contains(block)) {
            location = TeleportUtils.safeizeLocation(this.getLocation());
        }
        if (location == null) {
            return null;
        }
        this.set(location.getX(), location.getY(), location.getZ());
        return location;
    }

    protected int randomizeType(int i) {
        int j = this.plugin.getRandom().nextInt(2);
        switch (j) {
            case 0: {
                return -i;
            }
            case 1: {
                return i;
            }
        }
        return -1;
    }
}

