/*
 * Decompiled with CFR 0.152.
 */
package at.ibizagamer.rtp.handlers;

import at.ibizagamer.rtp.main.Main;
import java.util.List;
import java.util.Set;
import org.bukkit.World;

public class ConfigHandler {
    private final Main plugin;
    private final List<String> biomeBlacklist;
    private final List<String> blockBlacklist;

    public ConfigHandler(Main plugin) {
        this.plugin = plugin;
        this.biomeBlacklist = plugin.getConfig().getStringList("biome-blacklist");
        this.blockBlacklist = plugin.getConfig().getStringList("block-blacklist");
    }

    public String getPrefix() {
        String prefix = this.plugin.getConfig().getString("prefix").replace("&", "\u00a7");
        return prefix;
    }

    public String getWorld() {
        String prefix = this.plugin.getConfig().getString("world");
        return prefix;
    }

    public Boolean getPermissionEnabled() {
        Boolean prefix = this.plugin.getConfig().getBoolean("permission-enabled");
        return prefix;
    }

    public Boolean getTorchEnabled() {
        Boolean torch = this.plugin.getConfig().getBoolean("torch");
        return torch;
    }

    public String getPermission() {
        String prefix = this.plugin.getConfig().getString("permission");
        return prefix;
    }

    public List<String> getBiomeBlacklist() {
        return this.biomeBlacklist;
    }

    public List<String> getBlockBlacklist() {
        return this.blockBlacklist;
    }

    public boolean isWorldRTPEnabled(World world) {
        Set set = this.plugin.getConfig().getConfigurationSection("worlds").getKeys(false);
        return set.contains(world.getName());
    }

    public int getMaxX(World world) {
        return (int)this.plugin.getConfig().getDouble("worlds." + world.getName() + ".max-x", 1000.0);
    }

    public int getMaxZ(World world) {
        return (int)this.plugin.getConfig().getDouble("worlds." + world.getName() + ".max-z", 1000.0);
    }
}

