/*
 * Decompiled with CFR 0.152.
 */
package pl.kiwimc.announcer;

import org.bukkit.ChatColor;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import pl.kiwimc.announcer.AnnounceCommand;
import pl.kiwimc.announcer.AnnouncerTask;
import pl.kiwimc.announcer.Metrics;

public final class AnnouncerPlugin
extends JavaPlugin {
    BukkitTask announcerTask;

    public void onEnable() {
        this.saveDefaultConfig();
        new Metrics((Plugin)this, 9529);
        new AnnounceCommand(this);
        this.announcerTask = new AnnouncerTask(this).runTaskTimer((Plugin)this, 0L, 20L * (long)this.getConfig().getInt("options.period", 300));
    }

    public void onDisable() {
        this.announcerTask.cancel();
    }

    public void announceBossbar(String message, int time) {
        final BossBar bar = this.getServer().createBossBar(ChatColor.translateAlternateColorCodes((char)'&', (String)message), BarColor.YELLOW, BarStyle.SOLID, new BarFlag[0]);
        bar.setProgress(0.0);
        for (Player player : this.getServer().getOnlinePlayers()) {
            bar.addPlayer(player);
        }
        final double toBeAdded = 1.0 / (double)(20 * time);
        new BukkitRunnable(){

            public void run() {
                if (bar.getProgress() + toBeAdded > 1.0) {
                    bar.setProgress(1.0);
                    bar.removeAll();
                    this.cancel();
                } else {
                    bar.setProgress(bar.getProgress() + toBeAdded);
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 1L);
    }
}

