/*
 * Decompiled with CFR 0.152.
 */
package splix.me.listeners;

import java.io.IOException;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import splix.me.ScoreBoard.SplixScoreBoard;
import splix.me.Storage.GlobalStorage;
import splix.me.action.PillagerAction;
import splix.me.action.ShulkerAction;
import splix.me.action.SkeletonAction;
import splix.me.action.SpiderAction;
import splix.me.action.ZombieAction;
import splix.me.arena.arena1.main.Arena1Main;
import splix.me.arena.arena1.update.Update;
import splix.me.main.Main;

public class EntityEvent
implements Listener {
    private Main plugin;

    public EntityEvent(Main plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) throws IOException {
        try {
            if (this.plugin.getConfig().getBoolean("PermChallenges.EntityEvents.Events.ZombieKill.Activated") && event.getEntity().getType().equals((Object)EntityType.ZOMBIE)) {
                ZombieAction.KilledZombie(event.getEntity().getKiller());
            }
            if (this.plugin.getConfig().getBoolean("PermChallenges.EntityEvents.Events.SkeletonKill.Activated") && event.getEntity().getType().equals((Object)EntityType.SKELETON)) {
                SkeletonAction.KilledSkeleton(event.getEntity().getKiller());
            }
            if (this.plugin.getConfig().getBoolean("PermChallenges.EntityEvents.Events.SpiderKill.Activated") && event.getEntity().getType().equals((Object)EntityType.SPIDER)) {
                SpiderAction.KilledSpider(event.getEntity().getKiller());
            }
            if (this.plugin.getConfig().getBoolean("PermChallenges.EntityEvents.Events.ShulkerKill.Activated") && event.getEntity().getType().equals((Object)EntityType.SHULKER)) {
                ShulkerAction.KilledShulker(event.getEntity().getKiller());
            }
            if (this.plugin.getConfig().getBoolean("PermChallenges.EntityEvents.Events.PillagerKill.Activated") && event.getEntity().getType().equals((Object)EntityType.PILLAGER)) {
                PillagerAction.KilledPillager(event.getEntity().getKiller());
            }
        }
        catch (NullPointerException e) {
            return;
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        try {
            if (this.plugin.getConfig().getBoolean("DailyChallenges.ArenaChallenge.Activated") && event.getEntity().equals(Arena1Main.p)) {
                Update.PlayerDeath(event);
            }
        }
        catch (NullPointerException e) {
            return;
        }
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        try {
            if (this.plugin.getConfig().getBoolean("DailyChallenges.ArenaChallenge.Activated") && event.getPlayer().equals(Arena1Main.p)) {
                Update.PlayerRespawn(event);
            }
        }
        catch (NullPointerException e) {
            return;
        }
    }

    @EventHandler
    public void onPlayerJoinEvent(PlayerJoinEvent event) {
        if (this.plugin.getConfig().getBoolean("ScoreBoard.Enabled")) {
            Player joining = event.getPlayer();
            GlobalStorage.ScoreBoardStatus.put(joining, true);
            SplixScoreBoard.CreateScoreBoard(joining);
        }
    }

    @EventHandler
    public void onShootEvent(EntityShootBowEvent event) {
        if (!event.getEntity().getType().equals((Object)EntityType.PLAYER) || this.plugin.getConfig().getBoolean("PermChallenges.EntityEvents.Events.ShootArrow.Activated")) {
            // empty if block
        }
    }
}

