/*
 * Decompiled with CFR 0.152.
 */
package me.quantiom.advancedvanish.sync;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import me.quantiom.advancedvanish.AdvancedVanish;
import me.quantiom.advancedvanish.config.Config;
import me.quantiom.advancedvanish.event.PlayerUnVanishEvent;
import me.quantiom.advancedvanish.event.PlayerVanishEvent;
import me.quantiom.advancedvanish.shaded.kotlin.Metadata;
import me.quantiom.advancedvanish.shaded.kotlin.jvm.internal.Intrinsics;
import me.quantiom.advancedvanish.sync.IServerSyncStore;
import me.quantiom.advancedvanish.sync.impl.RedisServerSyncStore;
import me.quantiom.advancedvanish.sync.impl.SqlServerSyncStore;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u000bJ\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001eH\u0007J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020 H\u0007J\u0018\u0010!\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u0004H\u0002J\u0006\u0010#\u001a\u00020\u0017R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR&\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lme/quantiom/advancedvanish/sync/ServerSyncManager;", "Lorg/bukkit/event/Listener;", "()V", "crossServerSupportEnabled", "", "getCrossServerSupportEnabled", "()Z", "setCrossServerSupportEnabled", "(Z)V", "loginVanishStates", "", "Ljava/util/UUID;", "getLoginVanishStates", "()Ljava/util/Map;", "setLoginVanishStates", "(Ljava/util/Map;)V", "serverSyncStoreImpl", "Lme/quantiom/advancedvanish/sync/IServerSyncStore;", "getServerSyncStoreImpl", "()Lme/quantiom/advancedvanish/sync/IServerSyncStore;", "setServerSyncStoreImpl", "(Lme/quantiom/advancedvanish/sync/IServerSyncStore;)V", "close", "", "get", "key", "onAsyncJoin", "event", "Lorg/bukkit/event/player/AsyncPlayerPreLoginEvent;", "onUnVanish", "Lme/quantiom/advancedvanish/event/PlayerUnVanishEvent;", "onVanish", "Lme/quantiom/advancedvanish/event/PlayerVanishEvent;", "setAsync", "value", "setup", "advancedvanish"})
public final class ServerSyncManager
implements Listener {
    @NotNull
    public static final ServerSyncManager INSTANCE = new ServerSyncManager();
    private static boolean crossServerSupportEnabled;
    @Nullable
    private static IServerSyncStore serverSyncStoreImpl;
    @NotNull
    private static Map<UUID, Boolean> loginVanishStates;

    private ServerSyncManager() {
    }

    public final boolean getCrossServerSupportEnabled() {
        return crossServerSupportEnabled;
    }

    public final void setCrossServerSupportEnabled(boolean bl) {
        crossServerSupportEnabled = bl;
    }

    @Nullable
    public final IServerSyncStore getServerSyncStoreImpl() {
        return serverSyncStoreImpl;
    }

    public final void setServerSyncStoreImpl(@Nullable IServerSyncStore iServerSyncStore) {
        serverSyncStoreImpl = iServerSyncStore;
    }

    @NotNull
    public final Map<UUID, Boolean> getLoginVanishStates() {
        return loginVanishStates;
    }

    public final void setLoginVanishStates(@NotNull Map<UUID, Boolean> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        loginVanishStates = map;
    }

    /*
     * WARNING - void declaration
     */
    public final void setup() {
        Config key$iv;
        void this_$iv;
        Object object = Config.INSTANCE;
        String string = "cross-server-support.enabled";
        Object default$iv = false;
        boolean $i$f$getValueOrDefault = false;
        FileConfiguration fileConfiguration = this_$iv.getSavedConfig();
        Intrinsics.checkNotNull((Object)fileConfiguration);
        Object value$iv = fileConfiguration.get((String)((Object)key$iv));
        if (((Boolean)(value$iv instanceof Boolean ? value$iv : default$iv)).booleanValue()) {
            IServerSyncStore iServerSyncStore;
            void key$iv2;
            void this_$iv2;
            key$iv = Config.INSTANCE;
            default$iv = "cross-server-support.mode";
            String default$iv2 = "redis";
            boolean $i$f$getValueOrDefault2 = false;
            FileConfiguration fileConfiguration2 = this_$iv2.getSavedConfig();
            Intrinsics.checkNotNull((Object)fileConfiguration2);
            Object value$iv2 = fileConfiguration2.get((String)key$iv2);
            String string2 = ((String)(value$iv2 instanceof String ? value$iv2 : default$iv2)).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            object = string2;
            if (Intrinsics.areEqual((Object)object, (Object)"redis")) {
                iServerSyncStore = RedisServerSyncStore.INSTANCE;
            } else if (Intrinsics.areEqual((Object)object, (Object)"sql")) {
                iServerSyncStore = SqlServerSyncStore.INSTANCE;
            } else {
                Level level = Level.WARNING;
                Intrinsics.checkNotNullExpressionValue((Object)level, (String)"WARNING");
                AdvancedVanish.INSTANCE.log(level, "Invalid mode set for cross-server-support. Please double check your config.");
                return;
            }
            IServerSyncStore iServerSyncStore2 = serverSyncStoreImpl = iServerSyncStore;
            Intrinsics.checkNotNull((Object)iServerSyncStore2);
            crossServerSupportEnabled = iServerSyncStore2.setup();
        } else {
            IServerSyncStore iServerSyncStore = serverSyncStoreImpl;
            if (iServerSyncStore != null) {
                iServerSyncStore.close();
            }
            crossServerSupportEnabled = false;
        }
    }

    public final void close() {
        block0: {
            IServerSyncStore iServerSyncStore = serverSyncStoreImpl;
            if (iServerSyncStore == null) break block0;
            iServerSyncStore.close();
        }
    }

    @EventHandler
    public final void onAsyncJoin(@NotNull AsyncPlayerPreLoginEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        UUID uUID = event.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"event.uniqueId");
        boolean it = this.get(uUID);
        boolean bl = false;
        UUID uUID2 = event.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"event.uniqueId");
        loginVanishStates.put(uUID2, it);
    }

    @EventHandler(ignoreCancelled=true)
    public final void onVanish(@NotNull PlayerVanishEvent event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        ServerSyncManager $this$onVanish_u24lambda_u2d1 = this;
        boolean bl = false;
        if (!event.getOnJoin()) {
            UUID uUID = event.getPlayer().getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"event.player.uniqueId");
            $this$onVanish_u24lambda_u2d1.setAsync(uUID, true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public final void onUnVanish(@NotNull PlayerUnVanishEvent event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        ServerSyncManager $this$onUnVanish_u24lambda_u2d2 = this;
        boolean bl = false;
        if (!event.getOnLeave()) {
            UUID uUID = event.getPlayer().getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"event.player.uniqueId");
            $this$onUnVanish_u24lambda_u2d2.setAsync(uUID, false);
        }
    }

    public final boolean get(@NotNull UUID key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!crossServerSupportEnabled) {
            return false;
        }
        IServerSyncStore iServerSyncStore = serverSyncStoreImpl;
        Boolean bl = iServerSyncStore != null ? Boolean.valueOf(iServerSyncStore.get(key)) : null;
        Intrinsics.checkNotNull((Object)bl);
        return bl;
    }

    private final void setAsync(UUID key, boolean value) {
        block1: {
            if (!crossServerSupportEnabled) {
                return;
            }
            IServerSyncStore iServerSyncStore = serverSyncStoreImpl;
            if (iServerSyncStore == null) break block1;
            iServerSyncStore.setAsync(key, value);
        }
    }

    static {
        HashMap hashMap = Maps.newHashMap();
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMap()");
        loginVanishStates = hashMap;
    }
}

