/*
 * Decompiled with CFR 0.152.
 */
package me.quantiom.advancedvanish.shaded.acf;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.quantiom.advancedvanish.locales.MessageKeyProvider;
import me.quantiom.advancedvanish.shaded.acf.ACFPatterns;
import me.quantiom.advancedvanish.shaded.acf.ACFUtil;
import me.quantiom.advancedvanish.shaded.acf.Annotations;
import me.quantiom.advancedvanish.shaded.acf.BaseCommand;
import me.quantiom.advancedvanish.shaded.acf.CommandCompletionContext;
import me.quantiom.advancedvanish.shaded.acf.CommandCompletions;
import me.quantiom.advancedvanish.shaded.acf.CommandConditions;
import me.quantiom.advancedvanish.shaded.acf.CommandContexts;
import me.quantiom.advancedvanish.shaded.acf.CommandExecutionContext;
import me.quantiom.advancedvanish.shaded.acf.CommandHelp;
import me.quantiom.advancedvanish.shaded.acf.CommandHelpFormatter;
import me.quantiom.advancedvanish.shaded.acf.CommandIssuer;
import me.quantiom.advancedvanish.shaded.acf.CommandOperationContext;
import me.quantiom.advancedvanish.shaded.acf.CommandParameter;
import me.quantiom.advancedvanish.shaded.acf.CommandReplacements;
import me.quantiom.advancedvanish.shaded.acf.CommandRouter;
import me.quantiom.advancedvanish.shaded.acf.ConditionContext;
import me.quantiom.advancedvanish.shaded.acf.ExceptionHandler;
import me.quantiom.advancedvanish.shaded.acf.IssuerLocaleChangedCallback;
import me.quantiom.advancedvanish.shaded.acf.Locales;
import me.quantiom.advancedvanish.shaded.acf.LogLevel;
import me.quantiom.advancedvanish.shaded.acf.MessageFormatter;
import me.quantiom.advancedvanish.shaded.acf.MessageType;
import me.quantiom.advancedvanish.shaded.acf.RegisteredCommand;
import me.quantiom.advancedvanish.shaded.acf.RootCommand;
import me.quantiom.advancedvanish.shaded.acf.UnresolvedDependencyException;
import me.quantiom.advancedvanish.shaded.acf.UnstableAPI;
import me.quantiom.advancedvanish.shaded.acf.annotation.Dependency;
import me.quantiom.advancedvanish.shaded.acf.lib.util.Table;
import org.jetbrains.annotations.NotNull;

public abstract class CommandManager<IT, I extends CommandIssuer, FT, MF extends MessageFormatter<FT>, CEC extends CommandExecutionContext<CEC, I>, CC extends ConditionContext<I>> {
    static ThreadLocal<Stack<CommandOperationContext>> commandOperationContext = ThreadLocal.withInitial(() -> new Stack<CommandOperationContext>(){

        @Override
        public synchronized CommandOperationContext peek() {
            return super.size() == 0 ? null : (CommandOperationContext)super.peek();
        }
    });
    protected Map<String, RootCommand> rootCommands = new HashMap<String, RootCommand>();
    protected final CommandReplacements replacements = new CommandReplacements(this);
    protected final CommandConditions<I, CEC, CC> conditions = new CommandConditions(this);
    protected ExceptionHandler defaultExceptionHandler = null;
    boolean logUnhandledExceptions = true;
    protected Table<Class<?>, String, Object> dependencies = new Table();
    protected CommandHelpFormatter helpFormatter = new CommandHelpFormatter(this);
    protected boolean usePerIssuerLocale = false;
    protected List<IssuerLocaleChangedCallback<I>> localeChangedCallbacks = new ArrayList<IssuerLocaleChangedCallback<I>>();
    protected Set<Locale> supportedLanguages = new HashSet<Locale>(Arrays.asList(Locales.ENGLISH, Locales.DUTCH, Locales.GERMAN, Locales.SPANISH, Locales.FRENCH, Locales.CZECH, Locales.PORTUGUESE, Locales.SWEDISH, Locales.NORWEGIAN_BOKMAAL, Locales.NORWEGIAN_NYNORSK, Locales.RUSSIAN, Locales.BULGARIAN, Locales.HUNGARIAN, Locales.TURKISH, Locales.JAPANESE, Locales.CHINESE, Locales.SIMPLIFIED_CHINESE, Locales.TRADITIONAL_CHINESE));
    protected Map<MessageType, MF> formatters = new IdentityHashMap<MessageType, MF>();
    protected MF defaultFormatter;
    protected int defaultHelpPerPage = 10;
    protected Map<UUID, Locale> issuersLocale = new ConcurrentHashMap<UUID, Locale>();
    private Set<String> unstableAPIs = new HashSet<String>();
    private Annotations annotations = new Annotations<CommandManager>(this);
    private CommandRouter router = new CommandRouter(this);

    public static CommandOperationContext getCurrentCommandOperationContext() {
        return commandOperationContext.get().peek();
    }

    public static CommandIssuer getCurrentCommandIssuer() {
        CommandOperationContext context = commandOperationContext.get().peek();
        return context != null ? (CommandIssuer)context.getCommandIssuer() : null;
    }

    public static CommandManager getCurrentCommandManager() {
        CommandOperationContext context = commandOperationContext.get().peek();
        return context != null ? context.getCommandManager() : null;
    }

    public MF setFormat(MessageType type2, MF formatter) {
        return (MF)((MessageFormatter)this.formatters.put(type2, formatter));
    }

    public MF getFormat(MessageType type2) {
        return (MF)((MessageFormatter)this.formatters.getOrDefault(type2, this.defaultFormatter));
    }

    public void setFormat(MessageType type2, FT ... colors) {
        MF format = this.getFormat(type2);
        for (int i = 1; i <= colors.length; ++i) {
            ((MessageFormatter)format).setColor(i, colors[i - 1]);
        }
    }

    public void setFormat(MessageType type2, int i, FT color) {
        MF format = this.getFormat(type2);
        ((MessageFormatter)format).setColor(i, color);
    }

    public MF getDefaultFormatter() {
        return this.defaultFormatter;
    }

    public void setDefaultFormatter(MF defaultFormatter) {
        this.defaultFormatter = defaultFormatter;
    }

    public CommandConditions<I, CEC, CC> getCommandConditions() {
        return this.conditions;
    }

    public abstract CommandContexts<?> getCommandContexts();

    public abstract CommandCompletions<?> getCommandCompletions();

    @Deprecated
    @UnstableAPI
    public CommandHelp generateCommandHelp(@NotNull String command) {
        this.verifyUnstableAPI("help");
        CommandOperationContext context = CommandManager.getCurrentCommandOperationContext();
        if (context == null) {
            throw new IllegalStateException("This method can only be called as part of a command execution.");
        }
        return this.generateCommandHelp((CommandIssuer)context.getCommandIssuer(), command);
    }

    @Deprecated
    @UnstableAPI
    public CommandHelp generateCommandHelp(CommandIssuer issuer, @NotNull String command) {
        this.verifyUnstableAPI("help");
        return this.generateCommandHelp(issuer, this.obtainRootCommand(command));
    }

    @Deprecated
    @UnstableAPI
    public CommandHelp generateCommandHelp() {
        this.verifyUnstableAPI("help");
        CommandOperationContext context = CommandManager.getCurrentCommandOperationContext();
        if (context == null) {
            throw new IllegalStateException("This method can only be called as part of a command execution.");
        }
        String commandLabel = context.getCommandLabel();
        return this.generateCommandHelp((CommandIssuer)context.getCommandIssuer(), this.obtainRootCommand(commandLabel));
    }

    @Deprecated
    @UnstableAPI
    public CommandHelp generateCommandHelp(CommandIssuer issuer, RootCommand rootCommand) {
        this.verifyUnstableAPI("help");
        return new CommandHelp(this, rootCommand, issuer);
    }

    @Deprecated
    @UnstableAPI
    public int getDefaultHelpPerPage() {
        this.verifyUnstableAPI("help");
        return this.defaultHelpPerPage;
    }

    @Deprecated
    @UnstableAPI
    public void setDefaultHelpPerPage(int defaultHelpPerPage) {
        this.verifyUnstableAPI("help");
        this.defaultHelpPerPage = defaultHelpPerPage;
    }

    @Deprecated
    @UnstableAPI
    public void setHelpFormatter(CommandHelpFormatter helpFormatter) {
        this.helpFormatter = helpFormatter;
    }

    @Deprecated
    @UnstableAPI
    public CommandHelpFormatter getHelpFormatter() {
        return this.helpFormatter;
    }

    CommandRouter getRouter() {
        return this.router;
    }

    public abstract void registerCommand(BaseCommand var1);

    public abstract boolean hasRegisteredCommands();

    public abstract boolean isCommandIssuer(Class<?> var1);

    public abstract I getCommandIssuer(Object var1);

    public abstract RootCommand createRootCommand(String var1);

    public abstract Locales getLocales();

    public boolean usingPerIssuerLocale() {
        return this.usePerIssuerLocale;
    }

    public boolean usePerIssuerLocale(boolean setting) {
        boolean old = this.usePerIssuerLocale;
        this.usePerIssuerLocale = setting;
        return old;
    }

    public ConditionContext createConditionContext(CommandIssuer issuer, String config) {
        return new ConditionContext<CommandIssuer>(issuer, config);
    }

    public abstract CommandExecutionContext createCommandContext(RegisteredCommand var1, CommandParameter var2, CommandIssuer var3, List<String> var4, int var5, Map<String, Object> var6);

    public abstract CommandCompletionContext createCompletionContext(RegisteredCommand var1, CommandIssuer var2, String var3, String var4, String[] var5);

    public abstract void log(LogLevel var1, String var2, Throwable var3);

    public void log(LogLevel level, String message) {
        this.log(level, message, null);
    }

    public CommandReplacements getCommandReplacements() {
        return this.replacements;
    }

    public boolean hasPermission(CommandIssuer issuer, Set<String> permissions) {
        for (String permission : permissions) {
            if (this.hasPermission(issuer, permission)) continue;
            return false;
        }
        return true;
    }

    public boolean hasPermission(CommandIssuer issuer, String permission) {
        if (permission == null || permission.isEmpty()) {
            return true;
        }
        for (String perm : ACFPatterns.COMMA.split(permission)) {
            if (perm.isEmpty() || issuer.hasPermission(perm)) continue;
            return false;
        }
        return true;
    }

    public synchronized RootCommand getRootCommand(@NotNull String cmd) {
        return this.rootCommands.get(ACFPatterns.SPACE.split(cmd.toLowerCase(Locale.ENGLISH), 2)[0]);
    }

    public synchronized RootCommand obtainRootCommand(@NotNull String cmd) {
        return this.rootCommands.computeIfAbsent(ACFPatterns.SPACE.split(cmd.toLowerCase(Locale.ENGLISH), 2)[0], this::createRootCommand);
    }

    public abstract Collection<RootCommand> getRegisteredRootCommands();

    public RegisteredCommand createRegisteredCommand(BaseCommand command, String cmdName, Method method, String prefSubCommand) {
        return new RegisteredCommand(command, cmdName, method, prefSubCommand);
    }

    public void setDefaultExceptionHandler(ExceptionHandler exceptionHandler) {
        if (exceptionHandler == null && !this.logUnhandledExceptions) {
            throw new IllegalArgumentException("You may not disable the default exception handler and have logging of unhandled exceptions disabled");
        }
        this.defaultExceptionHandler = exceptionHandler;
    }

    public void setDefaultExceptionHandler(ExceptionHandler exceptionHandler, boolean logExceptions) {
        if (exceptionHandler == null && !logExceptions) {
            throw new IllegalArgumentException("You may not disable the default exception handler and have logging of unhandled exceptions disabled");
        }
        this.logUnhandledExceptions = logExceptions;
        this.defaultExceptionHandler = exceptionHandler;
    }

    public boolean isLoggingUnhandledExceptions() {
        return this.logUnhandledExceptions;
    }

    public ExceptionHandler getDefaultExceptionHandler() {
        return this.defaultExceptionHandler;
    }

    protected boolean handleUncaughtException(BaseCommand scope, RegisteredCommand registeredCommand, CommandIssuer sender, List<String> args, Throwable t) {
        if (t instanceof InvocationTargetException && t.getCause() != null) {
            t = t.getCause();
        }
        boolean result = false;
        if (scope.getExceptionHandler() != null) {
            result = scope.getExceptionHandler().execute(scope, registeredCommand, sender, args, t);
        } else if (this.defaultExceptionHandler != null) {
            result = this.defaultExceptionHandler.execute(scope, registeredCommand, sender, args, t);
        }
        return result;
    }

    public void sendMessage(IT issuerArg, MessageType type2, MessageKeyProvider key, String ... replacements) {
        this.sendMessage((CommandIssuer)this.getCommandIssuer(issuerArg), type2, key, replacements);
    }

    public void sendMessage(CommandIssuer issuer, MessageType type2, MessageKeyProvider key, String ... replacements) {
        String message = this.formatMessage(issuer, type2, key, replacements);
        for (String msg : ACFPatterns.NEWLINE.split(message)) {
            issuer.sendMessageInternal(ACFUtil.rtrim(msg));
        }
    }

    public String formatMessage(CommandIssuer issuer, MessageType type2, MessageKeyProvider key, String ... replacements) {
        String message = this.getLocales().getMessage(issuer, key.getMessageKey());
        if (replacements.length > 0) {
            message = ACFUtil.replaceStrings(message, replacements);
        }
        message = this.getCommandReplacements().replace(message);
        message = this.getLocales().replaceI18NStrings(message);
        MessageFormatter formatter = (MessageFormatter)this.formatters.getOrDefault(type2, this.defaultFormatter);
        if (formatter != null) {
            message = formatter.format(message);
        }
        return message;
    }

    public void onLocaleChange(IssuerLocaleChangedCallback<I> onChange) {
        this.localeChangedCallbacks.add(onChange);
    }

    public void notifyLocaleChange(I issuer, Locale oldLocale, Locale newLocale) {
        this.localeChangedCallbacks.forEach(cb -> {
            try {
                cb.onIssuerLocaleChange(issuer, oldLocale, newLocale);
            }
            catch (Exception e) {
                this.log(LogLevel.ERROR, "Error in notifyLocaleChange", e);
            }
        });
    }

    public Locale setIssuerLocale(IT issuer, Locale locale) {
        I commandIssuer = this.getCommandIssuer(issuer);
        Locale old = this.issuersLocale.put(commandIssuer.getUniqueId(), locale);
        if (!Objects.equals(old, locale)) {
            this.notifyLocaleChange(commandIssuer, old, locale);
        }
        return old;
    }

    public Locale getIssuerLocale(CommandIssuer issuer) {
        Locale locale;
        if (this.usingPerIssuerLocale() && issuer != null && (locale = this.issuersLocale.get(issuer.getUniqueId())) != null) {
            return locale;
        }
        return this.getLocales().getDefaultLocale();
    }

    CommandOperationContext<I> createCommandOperationContext(BaseCommand command, CommandIssuer issuer, String commandLabel, String[] args, boolean isAsync) {
        return new CommandOperationContext<CommandIssuer>(this, issuer, command, commandLabel, args, isAsync);
    }

    public Set<Locale> getSupportedLanguages() {
        return this.supportedLanguages;
    }

    public void addSupportedLanguage(Locale locale) {
        this.supportedLanguages.add(locale);
        this.getLocales().loadMissingBundles();
    }

    public <T> void registerDependency(Class<? extends T> clazz, T instance) {
        this.registerDependency(clazz, clazz.getName(), instance);
    }

    public <T> void registerDependency(Class<? extends T> clazz, String key, T instance) {
        if (this.dependencies.containsKey(clazz, key)) {
            throw new IllegalStateException("There is already an instance of " + clazz.getName() + " with the key " + key + " registered!");
        }
        this.dependencies.put(clazz, key, instance);
    }

    void injectDependencies(BaseCommand baseCommand) {
        Class<?> clazz = baseCommand.getClass();
        do {
            for (Field field : clazz.getDeclaredFields()) {
                if (!this.annotations.hasAnnotation(field, Dependency.class)) continue;
                String dependency = this.annotations.getAnnotationValue(field, Dependency.class);
                String key = dependency;
                key = key.isEmpty() ? field.getType().getName() : key;
                Object object = this.dependencies.row(field.getType()).get(key);
                if (object == null) {
                    throw new UnresolvedDependencyException("Could not find a registered instance of " + field.getType().getName() + " with key " + key + " for field " + field.getName() + " in class " + baseCommand.getClass().getName());
                }
                try {
                    boolean accessible = field.isAccessible();
                    if (!accessible) {
                        field.setAccessible(true);
                    }
                    field.set(baseCommand, object);
                    field.setAccessible(accessible);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        } while (!(clazz = clazz.getSuperclass()).equals(BaseCommand.class));
    }

    @Deprecated
    public void enableUnstableAPI(String api) {
        this.unstableAPIs.add(api);
    }

    void verifyUnstableAPI(String api) {
        if (!this.unstableAPIs.contains(api)) {
            throw new IllegalStateException("Using an unstable API that has not been enabled ( " + api + "). See https://acfunstable.emc.gs");
        }
    }

    boolean hasUnstableAPI(String api) {
        return this.unstableAPIs.contains(api);
    }

    Annotations getAnnotations() {
        return this.annotations;
    }

    public String getCommandPrefix(CommandIssuer issuer) {
        return "";
    }
}

