/*
 * Decompiled with CFR 0.152.
 */
package me.quantiom.advancedvanish.shaded.acf;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.List;
import me.quantiom.advancedvanish.shaded.acf.ACFPatterns;
import me.quantiom.advancedvanish.shaded.acf.BaseCommand;
import me.quantiom.advancedvanish.shaded.acf.BukkitCommandManager;
import me.quantiom.advancedvanish.shaded.acf.CommandManager;
import me.quantiom.advancedvanish.shaded.acf.RegisteredCommand;
import me.quantiom.advancedvanish.shaded.acf.RootCommand;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.plugin.Plugin;

public class BukkitRootCommand
extends Command
implements RootCommand,
PluginIdentifiableCommand {
    private final BukkitCommandManager manager;
    private final String name;
    private BaseCommand defCommand;
    private SetMultimap<String, RegisteredCommand> subCommands = HashMultimap.create();
    private List<BaseCommand> children = new ArrayList<BaseCommand>();
    boolean isRegistered = false;

    BukkitRootCommand(BukkitCommandManager manager, String name) {
        super(name);
        this.manager = manager;
        this.name = name;
    }

    @Override
    public String getDescription() {
        RegisteredCommand command = this.getDefaultRegisteredCommand();
        if (command != null && !command.getHelpText().isEmpty()) {
            return command.getHelpText();
        }
        if (command != null && command.scope.description != null) {
            return command.scope.description;
        }
        if (this.defCommand.description != null) {
            return this.defCommand.description;
        }
        return super.getDescription();
    }

    @Override
    public String getCommandName() {
        return this.name;
    }

    public List<String> tabComplete(CommandSender sender, String commandLabel, String[] args) throws IllegalArgumentException {
        if (commandLabel.contains(":")) {
            commandLabel = ACFPatterns.COLON.split(commandLabel, 2)[1];
        }
        return this.getTabCompletions(this.manager.getCommandIssuer(sender), commandLabel, args);
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (commandLabel.contains(":")) {
            commandLabel = ACFPatterns.COLON.split(commandLabel, 2)[1];
        }
        this.execute(this.manager.getCommandIssuer(sender), commandLabel, args);
        return true;
    }

    public boolean testPermissionSilent(CommandSender target) {
        return this.hasAnyPermission(this.manager.getCommandIssuer(target));
    }

    @Override
    public void addChild(BaseCommand command) {
        if (this.defCommand == null || !command.subCommands.get((Object)"__default").isEmpty()) {
            this.defCommand = command;
        }
        this.addChildShared(this.children, this.subCommands, command);
        this.setPermission(this.getUniquePermission());
    }

    @Override
    public CommandManager getManager() {
        return this.manager;
    }

    @Override
    public SetMultimap<String, RegisteredCommand> getSubCommands() {
        return this.subCommands;
    }

    @Override
    public List<BaseCommand> getChildren() {
        return this.children;
    }

    @Override
    public BaseCommand getDefCommand() {
        return this.defCommand;
    }

    public Plugin getPlugin() {
        return this.manager.getPlugin();
    }
}

