/*
 * Decompiled with CFR 0.152.
 */
package me.quantiom.advancedvanish.redis;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import me.quantiom.advancedvanish.AdvancedVanish;
import me.quantiom.advancedvanish.config.Config;
import me.quantiom.advancedvanish.event.PlayerUnVanishEvent;
import me.quantiom.advancedvanish.event.PlayerVanishEvent;
import me.quantiom.advancedvanish.shaded.kotlin.Metadata;
import me.quantiom.advancedvanish.shaded.kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0019J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020!H\u0007J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020#H\u0007J\u0018\u0010$\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u0019H\u0002J\u0006\u0010&\u001a\u00020\u0017R&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lme/quantiom/advancedvanish/redis/RedisManager;", "Lorg/bukkit/event/Listener;", "()V", "loginVanishStates", "", "Ljava/util/UUID;", "", "getLoginVanishStates", "()Ljava/util/Map;", "setLoginVanishStates", "(Ljava/util/Map;)V", "pool", "Lredis/clients/jedis/JedisPool;", "getPool", "()Lredis/clients/jedis/JedisPool;", "setPool", "(Lredis/clients/jedis/JedisPool;)V", "proxySupportEnabled", "getProxySupportEnabled", "()Z", "setProxySupportEnabled", "(Z)V", "close", "", "get", "", "key", "getPlayerKey", "uuid", "onAsyncJoin", "event", "Lorg/bukkit/event/player/AsyncPlayerPreLoginEvent;", "onUnVanish", "Lme/quantiom/advancedvanish/event/PlayerUnVanishEvent;", "onVanish", "Lme/quantiom/advancedvanish/event/PlayerVanishEvent;", "setAsync", "value", "setup", "advancedvanish"})
public final class RedisManager
implements Listener {
    @NotNull
    public static final RedisManager INSTANCE = new RedisManager();
    @Nullable
    private static JedisPool pool;
    private static boolean proxySupportEnabled;
    @NotNull
    private static Map<UUID, Boolean> loginVanishStates;

    private RedisManager() {
    }

    @Nullable
    public final JedisPool getPool() {
        return pool;
    }

    public final void setPool(@Nullable JedisPool jedisPool) {
        pool = jedisPool;
    }

    public final boolean getProxySupportEnabled() {
        return proxySupportEnabled;
    }

    public final void setProxySupportEnabled(boolean bl) {
        proxySupportEnabled = bl;
    }

    @NotNull
    public final Map<UUID, Boolean> getLoginVanishStates() {
        return loginVanishStates;
    }

    public final void setLoginVanishStates(@NotNull Map<UUID, Boolean> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        loginVanishStates = map;
    }

    /*
     * WARNING - void declaration
     */
    public final void setup() {
        String key$iv;
        Object this_$iv;
        Object object = Config.INSTANCE;
        String string = "cross-server-support.enabled";
        Object default$iv = false;
        boolean $i$f$getValueOrDefault = false;
        FileConfiguration fileConfiguration = ((Config)this_$iv).getSavedConfig();
        Intrinsics.checkNotNull((Object)fileConfiguration);
        Object value$iv = fileConfiguration.get(key$iv);
        if (((Boolean)(value$iv instanceof Boolean ? value$iv : default$iv)).booleanValue()) {
            Object object2;
            void var3_6;
            this_$iv = Config.INSTANCE;
            key$iv = "cross-server-support.redis.ip";
            default$iv = "127.0.0.1";
            $i$f$getValueOrDefault = false;
            FileConfiguration fileConfiguration2 = ((Config)this_$iv).getSavedConfig();
            Intrinsics.checkNotNull((Object)fileConfiguration2);
            value$iv = fileConfiguration2.get(key$iv);
            String string2 = (String)(value$iv instanceof String ? value$iv : default$iv);
            this_$iv = Config.INSTANCE;
            key$iv = "cross-server-support.redis.port";
            default$iv = 6379;
            $i$f$getValueOrDefault = false;
            FileConfiguration fileConfiguration3 = ((Config)this_$iv).getSavedConfig();
            Intrinsics.checkNotNull((Object)fileConfiguration3);
            value$iv = fileConfiguration3.get(key$iv);
            int n = ((Number)(value$iv instanceof Integer ? value$iv : default$iv)).intValue();
            String string3 = null;
            this_$iv = Config.INSTANCE;
            key$iv = "cross-server-support.redis.auth";
            default$iv = "";
            $i$f$getValueOrDefault = false;
            FileConfiguration fileConfiguration4 = ((Config)this_$iv).getSavedConfig();
            Intrinsics.checkNotNull((Object)fileConfiguration4);
            value$iv = fileConfiguration4.get(key$iv);
            this_$iv = (CharSequence)(value$iv instanceof String ? value$iv : var3_6);
            if (this_$iv.length() == 0) {
                String string4 = string3;
                int n2 = n;
                String string5 = string2;
                boolean bl = false;
                Object var9_12 = null;
                string2 = string5;
                n = n2;
                string3 = string4;
                object2 = var9_12;
            } else {
                object2 = this_$iv;
            }
            String string6 = (String)object2;
            String string7 = string3;
            int n3 = n;
            String string8 = string2;
            pool = new JedisPool(string8, n3, string7, string6);
            try {
                JedisPool jedisPool = pool;
                Intrinsics.checkNotNull((Object)jedisPool);
                jedisPool.getResource().get("test");
            }
            catch (Exception e) {
                pool = null;
                Level level = Level.SEVERE;
                Intrinsics.checkNotNullExpressionValue((Object)level, (String)"SEVERE");
                AdvancedVanish.Companion.log(level, "There was an error while attempting to make a connection with Redis: ");
                e.printStackTrace();
                return;
            }
            proxySupportEnabled = true;
            object = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"INFO");
            AdvancedVanish.Companion.log((Level)object, "Successfully connected to Redis.");
        } else {
            pool = null;
            proxySupportEnabled = false;
        }
    }

    public final void close() {
        JedisPool jedisPool = pool;
        if (jedisPool != null) {
            jedisPool.close();
        }
    }

    @EventHandler
    public final void onAsyncJoin(@NotNull AsyncPlayerPreLoginEvent event) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        UUID uUID = event.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"event.uniqueId");
        String string = this.get(this.getPlayerKey(uUID));
        if (string == null) {
            bl = null;
        } else {
            String it = string;
            boolean bl2 = false;
            Map<UUID, Boolean> map = this.getLoginVanishStates();
            UUID uUID2 = event.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"event.uniqueId");
            bl = map.put(uUID2, Intrinsics.areEqual((Object)it, (Object)"true"));
        }
        Boolean got = bl;
    }

    @EventHandler(ignoreCancelled=true)
    public final void onVanish(@NotNull PlayerVanishEvent event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        RedisManager $this$onVanish_u24lambda_u2d2 = this;
        boolean bl = false;
        if (!event.getOnJoin()) {
            UUID uUID = event.getPlayer().getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"event.player.uniqueId");
            $this$onVanish_u24lambda_u2d2.setAsync($this$onVanish_u24lambda_u2d2.getPlayerKey(uUID), "true");
        }
    }

    @EventHandler(ignoreCancelled=true)
    public final void onUnVanish(@NotNull PlayerUnVanishEvent event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        RedisManager $this$onUnVanish_u24lambda_u2d3 = this;
        boolean bl = false;
        if (!event.getOnLeave()) {
            UUID uUID = event.getPlayer().getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"event.player.uniqueId");
            $this$onUnVanish_u24lambda_u2d3.setAsync($this$onUnVanish_u24lambda_u2d3.getPlayerKey(uUID), "false");
        }
    }

    @Nullable
    public final String get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String returnValue = null;
        if (proxySupportEnabled && pool != null) {
            try {
                JedisPool jedisPool = pool;
                Intrinsics.checkNotNull((Object)jedisPool);
                Jedis resource = jedisPool.getResource();
                boolean bl = false;
                returnValue = resource.get(key);
                resource.close();
            }
            catch (Exception e) {
                Level level = Level.SEVERE;
                Intrinsics.checkNotNullExpressionValue((Object)level, (String)"SEVERE");
                AdvancedVanish.Companion.log(level, "There was an error while attempting to make a connection with Redis: ");
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    private final void setAsync(String key, String value) {
        if (!proxySupportEnabled || pool == null) {
            return;
        }
        BukkitScheduler bukkitScheduler = Bukkit.getScheduler();
        AdvancedVanish advancedVanish = AdvancedVanish.Companion.getInstance();
        Intrinsics.checkNotNull((Object)advancedVanish);
        bukkitScheduler.runTaskAsynchronously((Plugin)advancedVanish, () -> RedisManager.setAsync$lambda-6(this, key, value));
    }

    private final String getPlayerKey(UUID uuid) {
        return Intrinsics.stringPlus((String)"advancedvanish-", (Object)uuid);
    }

    private static final void setAsync$lambda-6(RedisManager this$0, String $key, String $value) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
        try {
            JedisPool jedisPool = pool;
            Intrinsics.checkNotNull((Object)jedisPool);
            Jedis resource = jedisPool.getResource();
            boolean bl = false;
            resource.set($key, $value);
            resource.close();
        }
        catch (Exception e) {
            Level level = Level.SEVERE;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"SEVERE");
            AdvancedVanish.Companion.log(level, "There was an error while attempting to make a connection with Redis: ");
            e.printStackTrace();
        }
    }

    static {
        HashMap hashMap = Maps.newHashMap();
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMap()");
        loginVanishStates = hashMap;
    }
}

