/*
 * Decompiled with CFR 0.152.
 */
package me.quantiom.advancedvanish.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import me.quantiom.advancedvanish.AdvancedVanish;
import me.quantiom.advancedvanish.AdvancedVanishPlugin;
import me.quantiom.advancedvanish.command.VanishCommand;
import me.quantiom.advancedvanish.config.Config;
import me.quantiom.advancedvanish.hook.HooksManager;
import me.quantiom.advancedvanish.permission.IPermissionsHandler;
import me.quantiom.advancedvanish.permission.PermissionsManager;
import me.quantiom.advancedvanish.shaded.acf.BaseCommand;
import me.quantiom.advancedvanish.shaded.acf.annotation.CommandAlias;
import me.quantiom.advancedvanish.shaded.acf.annotation.CommandCompletion;
import me.quantiom.advancedvanish.shaded.acf.annotation.Default;
import me.quantiom.advancedvanish.shaded.acf.annotation.HelpCommand;
import me.quantiom.advancedvanish.shaded.acf.annotation.Subcommand;
import me.quantiom.advancedvanish.shaded.acf.annotation.Syntax;
import me.quantiom.advancedvanish.shaded.acf.bukkit.contexts.OnlinePlayer;
import me.quantiom.advancedvanish.shaded.kotlin.Metadata;
import me.quantiom.advancedvanish.shaded.kotlin.Pair;
import me.quantiom.advancedvanish.shaded.kotlin.TuplesKt;
import me.quantiom.advancedvanish.shaded.kotlin.Unit;
import me.quantiom.advancedvanish.shaded.kotlin.collections.CollectionsKt;
import me.quantiom.advancedvanish.shaded.kotlin.jvm.functions.Function1;
import me.quantiom.advancedvanish.shaded.kotlin.jvm.internal.Intrinsics;
import me.quantiom.advancedvanish.state.VanishStateManager;
import me.quantiom.advancedvanish.util.AdvancedVanishAPI;
import me.quantiom.advancedvanish.util.AdvancedVanishAPIKt;
import me.quantiom.advancedvanish.util.ExtensionsKt;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@CommandAlias(value="vanish|advancedvanish|v")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0003J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0003J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0003J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0003J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0003J \u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0003J\u0018\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0003J\u0018\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0003J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0003J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0003J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lme/quantiom/advancedvanish/command/VanishCommand;", "Lme/quantiom/advancedvanish/shaded/acf/BaseCommand;", "()V", "HELP_MESSAGE", "", "", "onHelp", "", "sender", "Lorg/bukkit/command/CommandSender;", "onInteractCommand", "player", "Lorg/bukkit/entity/Player;", "onListCommand", "onPriorityCommand", "onReloadCommand", "onSetCommand", "target", "Lme/quantiom/advancedvanish/shaded/acf/bukkit/contexts/OnlinePlayer;", "status", "onStatusCommand", "onToggleCommand", "onVanishCommand", "onVersionCommand", "permissionCheck", "", "key", "default", "advancedvanish"})
public final class VanishCommand
extends BaseCommand {
    @NotNull
    public static final VanishCommand INSTANCE = new VanishCommand();
    @NotNull
    private static final List<String> HELP_MESSAGE;

    private VanishCommand() {
    }

    @Default
    private final void onVanishCommand(Player player) {
        if (!this.permissionCheck((CommandSender)player, "permissions.vanish", "advancedvanish.vanish")) {
            return;
        }
        if (AdvancedVanishAPIKt.isVanished(player)) {
            AdvancedVanishAPI.unVanishPlayer$default(AdvancedVanishAPI.INSTANCE, player, false, 2, null);
            ExtensionsKt.sendConfigMessage((CommandSender)player, "vanish-off");
        } else {
            AdvancedVanishAPI.vanishPlayer$default(AdvancedVanishAPI.INSTANCE, player, false, 2, null);
            ExtensionsKt.sendConfigMessage((CommandSender)player, "vanish-on");
        }
    }

    @Subcommand(value="version")
    private final void onVersionCommand(CommandSender sender) {
        if (!this.permissionCheck(sender, "permissions.version-command", "advancedvanish.version-command")) {
            return;
        }
        Pair[] pairArray = new Pair[1];
        StringBuilder stringBuilder = new StringBuilder().append('v');
        AdvancedVanishPlugin advancedVanishPlugin = AdvancedVanish.INSTANCE.getInstance();
        Intrinsics.checkNotNull((Object)((Object)advancedVanishPlugin));
        pairArray[0] = TuplesKt.to((Object)"%version%", (Object)stringBuilder.append(advancedVanishPlugin.getDescription().getVersion()).toString());
        ExtensionsKt.sendConfigMessage(sender, "version-command", pairArray);
    }

    @Subcommand(value="reload|reloadconfig")
    private final void onReloadCommand(CommandSender sender) {
        Unit unit;
        if (!this.permissionCheck(sender, "permissions.reload-config-command", "advancedvanish.reload-config-command")) {
            return;
        }
        Config.INSTANCE.reload();
        Unit it = unit = Unit.INSTANCE;
        boolean bl = false;
        ExtensionsKt.sendConfigMessage(sender, "config-reloaded");
        HooksManager.INSTANCE.reloadHooks();
        PermissionsManager.INSTANCE.setupPermissionsHandler();
    }

    @Subcommand(value="interact")
    private final void onInteractCommand(Player player) {
        if (!this.permissionCheck((CommandSender)player, "permissions.interact-command", "advancedvanish.interact-command")) {
            return;
        }
        if (!AdvancedVanishAPIKt.isVanished(player)) {
            ExtensionsKt.sendConfigMessage((CommandSender)player, "must-be-vanished-to-use-command");
        } else if (VanishStateManager.INSTANCE.getInteractEnabled().contains(player.getUniqueId())) {
            VanishStateManager.INSTANCE.getInteractEnabled().remove(player.getUniqueId());
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"%interact-status%", (Object)"off")};
            ExtensionsKt.sendConfigMessage((CommandSender)player, "vanish-interact-toggled", pairArray);
        } else {
            Set<UUID> set = VanishStateManager.INSTANCE.getInteractEnabled();
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueId");
            set.add(uUID);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"%interact-status%", (Object)"on")};
            ExtensionsKt.sendConfigMessage((CommandSender)player, "vanish-interact-toggled", pairArray);
        }
    }

    @Subcommand(value="priority")
    private final void onPriorityCommand(Player player) {
        if (!this.permissionCheck((CommandSender)player, "permissions.priority-command", "advancedvanish.priority-command")) {
            return;
        }
        if (PermissionsManager.INSTANCE.getHandler() == null) {
            ExtensionsKt.sendConfigMessage((CommandSender)player, "not-using-vanish-priority");
        } else {
            CommandSender commandSender = (CommandSender)player;
            Pair[] pairArray = new Pair[1];
            IPermissionsHandler iPermissionsHandler = PermissionsManager.INSTANCE.getHandler();
            Intrinsics.checkNotNull((Object)iPermissionsHandler);
            pairArray[0] = TuplesKt.to((Object)"%priority%", (Object)String.valueOf(iPermissionsHandler.getVanishPriority(player)));
            ExtensionsKt.sendConfigMessage(commandSender, "vanish-priority", pairArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Subcommand(value="list")
    private final void onListCommand(Player player) {
        Player p0;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        if (!this.permissionCheck((CommandSender)player, "permissions.list-command", "advancedvanish.list-command")) {
            return;
        }
        Iterable $this$map$iv = AdvancedVanishAPI.INSTANCE.getVanishedPlayers();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            UUID uUID = (UUID)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Bukkit.getPlayer((UUID)p0));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            p0 = (Player)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v0 = it;
            Intrinsics.checkNotNull((Object)v0);
            collection.add(v0);
        }
        String players2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, (Function1)onListCommand.players.3.INSTANCE, (int)30, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"%vanished-players%", (Object)(((CharSequence)players2).length() == 0 ? "None" : players2))};
        ExtensionsKt.sendConfigMessage((CommandSender)player, "vanished-list", pairArray);
    }

    @Subcommand(value="status")
    @Syntax(value="<player>")
    @CommandCompletion(value="@players")
    private final void onStatusCommand(CommandSender sender, OnlinePlayer target) {
        if (!this.permissionCheck(sender, "permissions.status-command", "advancedvanish.status-command")) {
            return;
        }
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)"%target-name%", (Object)target.player.getName());
        Player player = target.player;
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"target.player");
        pairArray[1] = TuplesKt.to((Object)"%vanish-status%", (Object)(AdvancedVanishAPIKt.isVanished(player) ? "on" : "off"));
        Player player2 = target.player;
        Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"target.player");
        pairArray[2] = TuplesKt.to((Object)"%vanish-status-word%", (Object)(AdvancedVanishAPIKt.isVanished(player2) ? "vanished" : "not vanished"));
        ExtensionsKt.sendConfigMessage(sender, "vanish-status-command", pairArray);
    }

    /*
     * Unable to fully structure code
     */
    @Subcommand(value="set")
    @Syntax(value="<player> <on/off>")
    @CommandCompletion(value="@players")
    private final void onSetCommand(CommandSender sender, OnlinePlayer target, String status) {
        if (!this.permissionCheck(sender, "permissions.set-other-command", "advancedvanish.set-other-command")) {
            return;
        }
        v0 = status.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        if (Intrinsics.areEqual((Object)v0, (Object)"on")) ** GOTO lbl-1000
        v1 = status.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        if (Intrinsics.areEqual((Object)v1, (Object)"true")) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        toChange = v2;
        sendAlready = false;
        v3 = target.player;
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"target.player");
        if (AdvancedVanishAPIKt.isVanished(v3)) {
            if (toChange) {
                sendAlready = true;
            } else {
                v4 = target.player;
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"target.player");
                AdvancedVanishAPI.unVanishPlayer$default(AdvancedVanishAPI.INSTANCE, v4, false, 2, null);
            }
        } else if (!toChange) {
            sendAlready = true;
        } else {
            v5 = target.player;
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"target.player");
            AdvancedVanishAPI.vanishPlayer$default(AdvancedVanishAPI.INSTANCE, v5, false, 2, null);
        }
        if (sendAlready) {
            var6_6 = new Pair[3];
            var6_6[0] = TuplesKt.to((Object)"%target-name%", (Object)target.player.getName());
            v6 = target.player;
            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"target.player");
            var6_6[1] = TuplesKt.to((Object)"%vanish-status%", (Object)(AdvancedVanishAPIKt.isVanished(v6) != false ? "on" : "off"));
            v7 = target.player;
            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"target.player");
            var6_6[2] = TuplesKt.to((Object)"%vanish-status-word%", (Object)(AdvancedVanishAPIKt.isVanished(v7) != false ? "vanished" : "not vanished"));
            ExtensionsKt.sendConfigMessage(sender, "vanish-set-other-command-already", var6_6);
        } else {
            var6_7 = new Pair[3];
            var6_7[0] = TuplesKt.to((Object)"%target-name%", (Object)target.player.getName());
            v8 = target.player;
            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"target.player");
            var6_7[1] = TuplesKt.to((Object)"%vanish-status%", (Object)(AdvancedVanishAPIKt.isVanished(v8) != false ? "on" : "off"));
            v9 = target.player;
            Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"target.player");
            var6_7[2] = TuplesKt.to((Object)"%vanish-status-word%", (Object)(AdvancedVanishAPIKt.isVanished(v9) != false ? "vanished" : "not vanished"));
            ExtensionsKt.sendConfigMessage(sender, "vanish-set-other-command", var6_7);
        }
    }

    @Subcommand(value="toggle")
    @Syntax(value="<player>")
    @CommandCompletion(value="@players")
    private final void onToggleCommand(CommandSender sender, OnlinePlayer target) {
        if (!this.permissionCheck(sender, "permissions.toggle-other-command", "advancedvanish.toggle-other-command")) {
            return;
        }
        Player player = target.player;
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"target.player");
        if (AdvancedVanishAPIKt.isVanished(player)) {
            Player player2 = target.player;
            Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"target.player");
            AdvancedVanishAPI.unVanishPlayer$default(AdvancedVanishAPI.INSTANCE, player2, false, 2, null);
        } else {
            Player player3 = target.player;
            Intrinsics.checkNotNullExpressionValue((Object)player3, (String)"target.player");
            AdvancedVanishAPI.vanishPlayer$default(AdvancedVanishAPI.INSTANCE, player3, false, 2, null);
        }
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)"%target-name%", (Object)target.player.getName());
        Player player4 = target.player;
        Intrinsics.checkNotNullExpressionValue((Object)player4, (String)"target.player");
        pairArray[1] = TuplesKt.to((Object)"%vanish-status%", (Object)(AdvancedVanishAPIKt.isVanished(player4) ? "on" : "off"));
        Player player5 = target.player;
        Intrinsics.checkNotNullExpressionValue((Object)player5, (String)"target.player");
        pairArray[2] = TuplesKt.to((Object)"%vanish-status-word%", (Object)(AdvancedVanishAPIKt.isVanished(player5) ? "vanished" : "not vanished"));
        ExtensionsKt.sendConfigMessage(sender, "vanish-set-other-command", pairArray);
    }

    @HelpCommand
    private final void onHelp(CommandSender sender) {
        if (!this.permissionCheck(sender, "permissions.help-command", "advancedvanish.help-command")) {
            return;
        }
        Iterable $this$forEach$iv = HELP_MESSAGE;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            ExtensionsKt.sendComponentMessage(sender, ExtensionsKt.color(it));
        }
    }

    private final boolean permissionCheck(CommandSender sender, String key, String string) {
        Config this_$iv = Config.INSTANCE;
        boolean $i$f$getValueOrDefault = false;
        FileConfiguration fileConfiguration = this_$iv.getSavedConfig();
        Intrinsics.checkNotNull((Object)fileConfiguration);
        Object value$iv = fileConfiguration.get(key);
        if (!sender.hasPermission((String)(value$iv instanceof String ? value$iv : string))) {
            ExtensionsKt.sendConfigMessage(sender, "no-permission");
            return false;
        }
        return true;
    }

    static {
        Object[] objectArray = new String[]{"", "<red><strikethrough>----------</strikethrough><bold> AdvancedVanish </bold><red><strikethrough>----------", "<red>/vanish <dark_gray>- <white>Toggle vanish.", "<red>/vanish version <dark_gray>- <white>Shows the version of the plugin.", "<red>/vanish reload <dark_gray>- <white>Reloads the config and hooks.", "<red>/vanish interact <dark_gray>- <white>Toggles interacting with blocks while in vanish.", "<red>/vanish priority <dark_gray>- <white>Displays your vanish priority.", "<red>/vanish list <dark_gray>- <white>Displays a list of vanished players.", "<red>/vanish status <player> <dark_gray>- <white>Check if a player is in vanish.", "<red>/vanish set <player> <on/off> <dark_gray>- <white>Set another player's vanish.", "<red>/vanish toggle <player> <dark_gray>- <white>Toggle another player's vanish.", "<red><strikethrough>-----------------------------------", ""};
        HELP_MESSAGE = CollectionsKt.listOf((Object[])objectArray);
    }
}

