/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.explosion;

import io.github.guillex7.explodeany.block.BlockDatabase;
import io.github.guillex7.explodeany.block.BlockStatus;
import io.github.guillex7.explodeany.configuration.section.EntityConfiguration;
import io.github.guillex7.explodeany.configuration.section.EntityMaterialConfiguration;
import io.github.guillex7.explodeany.configuration.section.ParticleConfiguration;
import io.github.guillex7.explodeany.configuration.section.SoundConfiguration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;

public class ExplosionManager {
    private static ExplosionManager instance;

    private ExplosionManager() {
    }

    public static ExplosionManager getInstance() {
        if (instance == null) {
            instance = new ExplosionManager();
        }
        return instance;
    }

    public void removeHandledBlocksFromList(Map<Material, EntityMaterialConfiguration> materialConfigurations, List<Block> blockList) {
        Iterator<Block> iterator = blockList.iterator();
        while (iterator.hasNext()) {
            Block block = iterator.next();
            if (!materialConfigurations.containsKey(block.getType())) continue;
            iterator.remove();
        }
    }

    public boolean manageExplosion(Map<Material, EntityMaterialConfiguration> materialConfigurations, EntityConfiguration entityConfiguration, Location sourceLocation, int explosionRadius, float explosionPower) {
        ParticleConfiguration particleConfiguration;
        int cx = sourceLocation.getBlockX();
        int cy = sourceLocation.getBlockY();
        int cz = sourceLocation.getBlockZ();
        Vector sourceVector = new Vector(cx, cy, cz);
        int cxpr = cx + explosionRadius;
        int cypr = cy + explosionRadius;
        int czpr = cz + explosionRadius;
        int squaredExplosionRadius = explosionRadius * explosionRadius;
        int x = cx - explosionRadius;
        while (x < cxpr) {
            int y = cy - explosionRadius;
            while (y < cypr) {
                int z = cz - explosionRadius;
                while (z < czpr) {
                    Block block;
                    EntityMaterialConfiguration materialConfiguration;
                    double squaredDistance = sourceVector.distanceSquared(new Vector(x, y, z));
                    if (!((double)squaredExplosionRadius < squaredDistance) && (materialConfiguration = materialConfigurations.get((block = sourceLocation.getWorld().getBlockAt(x, y, z)).getType())) != null) {
                        this.damageBlock(materialConfiguration, block, sourceLocation, squaredExplosionRadius, squaredDistance);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        SoundConfiguration soundConfiguration = entityConfiguration.getSoundConfiguration();
        if (soundConfiguration.getSound() != null) {
            this.playSound(soundConfiguration, sourceLocation);
        }
        if ((particleConfiguration = entityConfiguration.getParticleConfiguration()).getParticle() != null) {
            this.spawnParticles(particleConfiguration, sourceLocation);
        }
        if (entityConfiguration.isExplosionDamageBlocksUnderwater() && sourceLocation.getBlock().isLiquid()) {
            sourceLocation.getBlock().setType(Material.AIR);
            return sourceLocation.getWorld().createExplosion(sourceLocation, explosionPower * entityConfiguration.getUnderwaterExplosionFactor().floatValue());
        }
        return false;
    }

    public void damageBlock(EntityMaterialConfiguration materialConfiguration, Block targetBlock, Location sourceLocation, int squaredExplosionRadius, double squaredDistance) {
        double maximumSquaredDistance = (double)squaredExplosionRadius * materialConfiguration.getExplosionRadiusFactor();
        if (squaredDistance > maximumSquaredDistance) {
            return;
        }
        double effectiveDamage = materialConfiguration.getDamage();
        if (materialConfiguration.isUnderwaterAffected() && this.performUnderwaterDetection(materialConfiguration, sourceLocation, targetBlock.getLocation())) {
            effectiveDamage *= materialConfiguration.getUnderwaterDamageFactor();
        }
        BlockStatus affectedBlockStatus = BlockDatabase.getInstance().getBlockStatus(targetBlock);
        affectedBlockStatus.damage(effectiveDamage *= 1.0 - materialConfiguration.getDistanceAttenuationFactor() * (squaredDistance - 1.0) / maximumSquaredDistance);
        if (affectedBlockStatus.shouldBreak()) {
            ParticleConfiguration particleConfiguration;
            SoundConfiguration soundConfiguration = materialConfiguration.getSoundConfiguration();
            if (soundConfiguration.getSound() != null) {
                this.playSound(soundConfiguration, targetBlock.getLocation());
            }
            if ((particleConfiguration = materialConfiguration.getParticleConfiguration()).getParticle() != null) {
                this.spawnParticles(particleConfiguration, targetBlock.getLocation());
            }
            if (materialConfiguration.shouldBeDropped()) {
                targetBlock.breakNaturally();
            } else {
                targetBlock.setType(Material.AIR);
            }
            BlockDatabase.getInstance().removeBlockStatus(targetBlock);
        }
    }

    private boolean performUnderwaterDetection(EntityMaterialConfiguration materialConfiguration, Location source, Location target) {
        return materialConfiguration.isFancyUnderwaterDetection() ? this.isLiquidInTrajectory(source, target) : source.getBlock().isLiquid();
    }

    private boolean isLiquidInTrajectory(Location source, Location target) {
        if (source.equals((Object)target)) {
            return source.getBlock().isLiquid();
        }
        BlockIterator it = new BlockIterator(source.getWorld(), source.toVector(), target.toVector().subtract(source.toVector()), 0.0, (int)source.distance(target));
        while (it.hasNext()) {
            if (!it.next().isLiquid()) continue;
            return true;
        }
        return false;
    }

    private void spawnParticles(ParticleConfiguration particleConfiguration, Location at) {
        at.getWorld().spawnParticle(particleConfiguration.getParticle(), at.getX(), at.getY(), at.getZ(), particleConfiguration.getAmount().intValue(), particleConfiguration.getDeltaX().doubleValue(), particleConfiguration.getDeltaY().doubleValue(), particleConfiguration.getDeltaZ().doubleValue(), particleConfiguration.getSpeed().doubleValue(), (Object)particleConfiguration.getOptions(), particleConfiguration.isForce().booleanValue());
    }

    private void playSound(SoundConfiguration soundConfiguration, Location at) {
        at.getWorld().playSound(at, soundConfiguration.getSound(), soundConfiguration.getVolume().floatValue(), soundConfiguration.getPitch().floatValue());
    }
}

