/*
 * Decompiled with CFR 0.152.
 */
package io.github.guillex7.explodeany.configuration.section;

import io.github.guillex7.explodeany.configuration.ConfigurationManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;

public class ParticleConfiguration {
    private static final Set<Particle> particlesWithData = new HashSet<Particle>(Arrays.asList(Particle.REDSTONE));
    public static final String ROOT_PATH = "Particles";
    private static final String NAME_PATH = "Name";
    private static final String DELTA_X_PATH = "DeltaX";
    private static final String DELTA_Y_PATH = "DeltaY";
    private static final String DELTA_Z_PATH = "DeltaZ";
    private static final String AMOUNT_PATH = "Amount";
    private static final String SPEED_PATH = "Speed";
    private static final String FORCE_PATH = "Force";
    private static final String RED_PATH = "Red";
    private static final String BLUE_PATH = "Blue";
    private static final String GREEN_PATH = "Green";
    private static final String SIZE_PATH = "Size";
    private Particle particle;
    private Double deltaX;
    private Double deltaY;
    private Double deltaZ;
    private Integer amount;
    private Double speed;
    private Boolean force;
    private Particle.DustOptions options;

    public static ParticleConfiguration of(Particle particle, Double deltaX, Double deltaY, Double deltaZ, Integer amount, Double speed, Boolean force, Particle.DustOptions options) {
        return new ParticleConfiguration(particle, deltaX, deltaY, deltaZ, amount, speed, force, options);
    }

    public static ParticleConfiguration byDefault() {
        return new ParticleConfiguration(null, 1.0, 1.0, 1.0, 1000, 1.0, false, new Particle.DustOptions(Color.BLACK, 1.0f));
    }

    public static ParticleConfiguration fromConfigurationSection(ConfigurationSection section) {
        Particle particle;
        ParticleConfiguration defaults = ParticleConfiguration.byDefault();
        try {
            particle = Particle.valueOf((String)section.getString(NAME_PATH).toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            particle = null;
        }
        Particle.DustOptions options = particlesWithData.contains(particle) ? new Particle.DustOptions(Color.fromRGB((int)ConfigurationManager.ensureRange(section.getInt(RED_PATH, defaults.getOptions().getColor().getRed()), 255, 0), (int)ConfigurationManager.ensureRange(section.getInt(GREEN_PATH, defaults.getOptions().getColor().getGreen()), 255, 0), (int)ConfigurationManager.ensureRange(section.getInt(BLUE_PATH, defaults.getOptions().getColor().getBlue()), 255, 0)), (float)ConfigurationManager.ensureMin(section.getDouble(SIZE_PATH, (double)defaults.getOptions().getSize()), 0.0)) : null;
        return ParticleConfiguration.of(particle, section.getDouble(DELTA_X_PATH, defaults.getDeltaX().doubleValue()), section.getDouble(DELTA_Y_PATH, defaults.getDeltaY().doubleValue()), section.getDouble(DELTA_Z_PATH, defaults.getDeltaZ().doubleValue()), ConfigurationManager.ensureMin(section.getInt(AMOUNT_PATH, defaults.getAmount().intValue()), 0), ConfigurationManager.ensureMin(section.getDouble(SPEED_PATH, defaults.getSpeed().doubleValue()), 0.0), section.getBoolean(FORCE_PATH, defaults.isForce().booleanValue()), options);
    }

    public ParticleConfiguration(Particle particle, Double deltaX, Double deltaY, Double deltaZ, Integer amount, Double speed, Boolean force, Particle.DustOptions options) {
        this.particle = particle;
        this.deltaX = deltaX;
        this.deltaY = deltaY;
        this.deltaZ = deltaZ;
        this.amount = amount;
        this.speed = speed;
        this.force = force;
        this.options = options;
    }

    public Particle getParticle() {
        return this.particle;
    }

    public void setParticle(Particle particle) {
        this.particle = particle;
    }

    public Double getDeltaX() {
        return this.deltaX;
    }

    public void setDeltaX(Double deltaX) {
        this.deltaX = deltaX;
    }

    public Double getDeltaY() {
        return this.deltaY;
    }

    public void setDeltaY(Double deltaY) {
        this.deltaY = deltaY;
    }

    public Double getDeltaZ() {
        return this.deltaZ;
    }

    public void setDeltaZ(Double deltaZ) {
        this.deltaZ = deltaZ;
    }

    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public Double getSpeed() {
        return this.speed;
    }

    public void setSpeed(Double speed) {
        this.speed = speed;
    }

    public Boolean isForce() {
        return this.force;
    }

    public void setForce(Boolean force) {
        this.force = force;
    }

    public Particle.DustOptions getOptions() {
        return this.options;
    }

    public void setOptions(Particle.DustOptions options) {
        this.options = options;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.amount == null ? 0 : this.amount.hashCode());
        result = 31 * result + (this.deltaX == null ? 0 : this.deltaX.hashCode());
        result = 31 * result + (this.deltaY == null ? 0 : this.deltaY.hashCode());
        result = 31 * result + (this.deltaZ == null ? 0 : this.deltaZ.hashCode());
        result = 31 * result + (this.force == null ? 0 : this.force.hashCode());
        result = 31 * result + (this.options == null ? 0 : this.options.hashCode());
        result = 31 * result + (this.particle == null ? 0 : this.particle.hashCode());
        result = 31 * result + (this.speed == null ? 0 : this.speed.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParticleConfiguration other = (ParticleConfiguration)obj;
        if (this.amount == null ? other.amount != null : !this.amount.equals(other.amount)) {
            return false;
        }
        if (this.deltaX == null ? other.deltaX != null : !this.deltaX.equals(other.deltaX)) {
            return false;
        }
        if (this.deltaY == null ? other.deltaY != null : !this.deltaY.equals(other.deltaY)) {
            return false;
        }
        if (this.deltaZ == null ? other.deltaZ != null : !this.deltaZ.equals(other.deltaZ)) {
            return false;
        }
        if (this.force == null ? other.force != null : !this.force.equals(other.force)) {
            return false;
        }
        if (this.options == null ? other.options != null : !this.options.equals(other.options)) {
            return false;
        }
        if (this.particle != other.particle) {
            return false;
        }
        return !(this.speed == null ? other.speed != null : !this.speed.equals(other.speed));
    }

    public String toString() {
        return "ParticleConfiguration [particle=" + this.particle + ", deltaX=" + this.deltaX + ", deltaY=" + this.deltaY + ", deltaZ=" + this.deltaZ + ", amount=" + this.amount + ", speed=" + this.speed + ", force=" + this.force + ", options=" + this.options + "]";
    }
}

